/* 
 * PRefAttr.c - Handle reflection attribute requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexReflectionAttribute (pexi, ambient, diffuse, specular,
			specularConc, transmissionCoef, specularColor)
    register pexC *pexi;
    FLOAT ambient;
    FLOAT diffuse;
    FLOAT specular;
    FLOAT specularConc;
    FLOAT transmissionCoef;
    pexColorSpecifier specularColor;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexSurfaceReflectionAttr oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCReflectionAttr;
    oc.head.length = sizeof (pexSurfaceReflectionAttr)>>2;
    oc.ambient = ambient;
    oc.diffuse = diffuse;
    oc.specular = specular;
    oc.specularConc = specularConc;
    oc.transmissionCoef = transmissionCoef;
    oc.specularColor = specularColor;
    
    req->numCommands++;

    pexPackData (pexi, (char *)(&oc), sizeof(pexSurfaceReflectionAttr));
    req->length	+= sizeof (pexSurfaceReflectionAttr)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}
