/* 
 * PQuadMesh.c - Routines to send a Quad Mesh packet.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexQuadrilateralMesh (pexi,
		      colorType,
		      m, n,
		      vertices,
		      vertexNormals,
		      vertexColors,
		      facetNormals,
		      facetColors)

    register pexC *pexi;
    pexColorType colorType;
    CARD32 m, n;
    pexCoord3D *vertices;
    pexVector3D *vertexNormals;
    pexColorSpecifier *vertexColors;
    pexVector3D *facetNormals;
    pexColorSpecifier *facetColors;
{
    register CARD32 i, numElements;
    register pexCoord3D *pV;
    register pexVector3D *pVN;
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    CARD32 totalLen, colorSize;
    pexBitmaskShort vertexAttribs = 0;
    pexBitmaskShort facetAttribs = 0;
    int one_shot = 0;

    pexQuadrilateralMesh oc;


    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands (pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    numElements = m*n;

    if (vertexNormals != NULL)
	vertexAttribs |= GANormal;
    if (vertexColors != NULL)
	vertexAttribs |= GAColor;
    if (facetNormals != NULL)
	facetAttribs |= GANormal;
    if (facetColors != NULL)
	facetAttribs |= GAColor;

    /* This is a kludge, since colors per facet and colors per normal are not
     * now implemented.
     */
    colorSize = 0;

    totalLen = ((sizeof (pexQuadrilateralMesh)) +     /* space for struct */
		(sizeof (pexCoord3D)*numElements) +           /* ...for vertices */
		((facetAttribs & GANormal) ?          /* ...facet norms */
		 (sizeof (pexVector3D)*(m-1)*(n-1)) : 0) +
		((facetAttribs & GAColor) ?           /* ...facet colors */
		 colorSize : 0) +
		((vertexAttribs & GANormal) ?         /* ...vertex norms */
		 (sizeof (pexVector3D)*numElements) : 0) +
		((vertexAttribs & GAColor) ?          /* ...vertex colors */
		 colorSize : 0));

    oc.head.elementType = OCQuadrilateralMesh;
    oc.head.length = totalLen>>2;

    oc.colorType = colorType;
    oc.mPts = m;
    oc.nPts = n;
    oc.facetAttribs = facetAttribs;
    oc.vertexAttribs = vertexAttribs;
    oc.pad = 0;

    pexPackData (pexi, (char *)(&oc), sizeof(pexQuadrilateralMesh));

    if (facetAttribs & GANormal)
    {
	pexPackData (pexi, facetNormals, (sizeof (pexVector3D)*(m-1)*(n-1)));
    }

    if (facetAttribs & GAColor)
	printf("We don't handle color for quad meshes.\n");

    if (!vertexAttribs)
    {
	pexPackData (pexi, vertices, sizeof (pexCoord3D)*numElements);
    }
    else
	for (i = 0, pV = vertices, pVN = vertexNormals;
	     i < numElements;
	     i++, pV++, pVN++)
	{
	    pexPackData (pexi, pV, sizeof (pexCoord3D));

	    if (vertexAttribs & GANormal)
	    {
		pexPackData (pexi, pVN,
			  sizeof (pexVector3D));
	    }
	    if (vertexAttribs & GAColor)
		printf("We don't handle color for quad meshes.\n");
	};

    req->numCommands++;
    req->length += (totalLen>>2);

    if (one_shot)
	PexEndRendComm(pexi);
};
