/* 
 * PPolyline.c - Pack a polyline packet
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *			   All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"



/*
 ******************************************************************************
 *
 *	Function:	PexPolyline(num_points, points)
 *
 *	On Entry:	num_points		Number of vertices in polygon.
 *				points			Array of coordinates.
 *
 *	On Exit:	Polyline added to open structure.
 *
 *	Notes:
 *		Not yet fully implemented.  Currently polyline data is drawn 
 *		immediately since structure code not yet in place.
 *
 ******************************************************************************
 */
int
PexPolyline(pexi, num_points, points)
    register pexC *pexi;
    int		num_points;	/* number of points	*/
    pexCoord3D	*points;	/* array of points	*/
{
	pexRenderOutputCommandsReq *req;
	register Display *dpy = pexi->phigsDisplay;
	pexPolyline oc;
	long nbytes;
	CARD32 totalLen;
	int one_shot = 0;

	if( ( req = pexi->curRenderOut ) == 0 )
	{
	    PexRenderOutputCommands(pexi);
	    one_shot++;
	    req = pexi->curRenderOut;
	}

	nbytes = num_points * sizeof( pexCoord3D );
	totalLen = sizeof ( pexPolyline ) + nbytes;

	oc.head.elementType = OCPolyline;
	oc.head.length      = totalLen>>2;

	pexPackData( pexi, (char *)(&oc), sizeof(pexPolyline) );
	pexPackData( pexi, (char *)points, nbytes);

	req->numCommands++;
	req->length += totalLen>>2;

	if ( one_shot )
	    PexEndRendComm (pexi);
}




PexViewIndex( pexi, index )
    register pexC *pexi;
    int index;
{
   register pexRenderOutputCommandsReq *req;
   register Display *dpy;
   pexViewIndex *pView;
   long nbytes;

   dpy = pexi->phigsDisplay;

   LockDisplay( dpy );

   nbytes = sizeof( pexViewIndex );
   GetPexFltReqExtra(RenderOutputCommands, nbytes, req );

   req->rdr = pexi->renderer;
   req->numCommands = 1;

   req++;	/* now req points at the next thing past the
		   RenderOutputCommand structure so we'll now
		   set the pewViewIndex pointer to point there 
		   */
   pView = ( pexViewIndex *)req;

   pView->head.elementType = OCViewIndex;
   pView->head.length = sizeof(*pView) / 4;
   pView->index = index;

   UnlockDisplay( dpy );
   SyncHandle();

}
