/* 
 * PFillArea.c - pack an opt data item along with the easy stuff.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexFillAreaWithData(pexi,
		    shape,
		    colorType,
		    ignoreEdges,
		    n, vertices,
		    vertexNormals,
		    vertexColors,
		    facetNormal,
		    facetColor)
    
    register pexC *pexi;
    CARD16 shape, ignoreEdges;
    pexColorType colorType;
    CARD32 n;
    pexCoord3D vertices[];
    pexVector3D vertexNormals[];
    pexColorSpecifier vertexColors[];
    pexVector3D *facetNormal;
    pexColorSpecifier *facetColor;
    
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    CARD32 i, totalLen, colorSize;
    pexBitmaskShort vertexAttribs = 0;
    pexBitmaskShort facetAttribs = 0;
    int one_shot = 0;
    
    pexFillAreaWithData oc; 
    

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    if ((char *)vertexNormals != NULL)
	vertexAttribs |= GANormal;
    if ((char *)vertexColors != NULL)
	vertexAttribs |= GAColor;
    if ((char *)facetNormal != NULL)
	facetAttribs |= GANormal;
    if ((char *)facetColor != NULL)
	facetAttribs |= GAColor;

    /* this must some day change
     * It is a kluge
     */
    colorSize = 0;
    
    totalLen = (sizeof(pexFillAreaWithData) +	   /* space for struct */
		4 +                                /* space for n */
		sizeof(pexCoord3D)*n +		   /* for vertices */

		((facetAttribs  & GANormal ) ? sizeof(pexVector3D) : 0) +
		((facetAttribs  & GAColor  ) ? colorSize : 0) +

		((vertexAttribs & GANormal ) ? n * sizeof(pexVector3D) : 0) +
		((vertexAttribs & GAColor  ) ? n * colorSize : 0));

    oc.head.elementType = OCExtFillArea;
    oc.head.length = totalLen>>2;

    oc.shape = shape;
    oc.ignoreEdges = ignoreEdges;
    oc.colorType = colorType;
    oc.facetAttribs = facetAttribs;
    oc.vertexAttribs = vertexAttribs;
    oc.pad = 0;
    
    pexPackData( pexi, (char *)(&oc), sizeof(pexFillAreaWithData) );
    pexPackData( pexi, (char *)(&n), 4);

    if (facetAttribs & GANormal)
    {
	pexPackData( pexi, (char *) facetNormal, sizeof(pexVector3D));
    }
    
    if (facetAttribs & GAColor)
    {
	printf("We don't handle Color for fillareas\n");
    }
    
    if (!vertexAttribs)
    {
	pexPackData( pexi, (char *)vertices, n*sizeof(pexCoord3D));
    }
    else
	for (i = 0; i < n; i++)
	{
	    pexPackData( pexi, (char *) &(vertices[i]), sizeof (pexCoord3D));

	    if (vertexAttribs & GANormal)
	    {
		pexPackData(pexi, (char *)&(vertexNormals[i]),
			 sizeof(pexVector3D));
	    }
	    
	    if (vertexAttribs & GAColor)
	    {
		printf("We don't handle Color for fillareas\n");
	    };
	    
	};
    req->numCommands++;
    req->length += totalLen / 4;
    
    if ( one_shot )
	PexEndRendComm(pexi);
};
