/* 
 * PEXpacket.h - X Protocol packetizing macros.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef PEX_PACKET_H
#define PEX_PACKET_H

#include "floatconv.h"

/*
 * PEX Protocol packetizing macros.
 */


/*
 * GetPexReq - Get the next avilable X request packet in the buffer and
 * return it.
 *
 * "name" is the name of the request, e.g. CreatePixmap, OpenFont, etc.
 * "req" is the name of the request pointer.
 *
 * Assumptions
 *
 *	there is a variable declared as 'Display *dpy'
 *
 */


#define GetPexReq(name, req) \
        if ((dpy->bufptr + sizeof(pex/**/name/**/Req)) > dpy->bufmax)\
                _XFlush(dpy);\
        req = (pex/**/name/**/Req *)(dpy->last_req = dpy->bufptr);\
        req->length = (sizeof(pex/**/name/**/Req))>>2;\
        req->reqType = pexi->PEXReqCode;\
        req->opcode = PEX_/**/name;\
        dpy->bufptr += sizeof(pex/**/name/**/Req);\
        dpy->request++




/* GetPexReqExtra is the same as GetPexReq, but allocates "n" additional
   bytes after the request. "n" must be a multiple of 4!  */


#define GetPexReqExtra(name, n, req) \
        if ((dpy->bufptr + sizeof(pex/**/name/**/Req) + n) > dpy->bufmax)\
                _XFlush(dpy);\
        req = (pex/**/name/**/Req *)(dpy->last_req = dpy->bufptr);\
        req->length = (sizeof(pex/**/name/**/Req) + n)>>2;\
        req->reqType = pexi->PEXReqCode;\
        req->opcode = PEX_/**/name;\
        dpy->bufptr += sizeof(pex/**/name/**/Req) + n;\
        dpy->request++


/* GetPexFltReq is the same as GetPexReq, but it assumes that the request
 * structure "struct Pex##name##Req" has a field for float format. It
 * assigns the Float format field of the request to MyFloatType (defined in
 * floatdef.h) 
 */

#define GetPexFltReq(name, req) \
        if ((dpy->bufptr + sizeof(pex/**/name/**/Req)) > dpy->bufmax)\
                _XFlush(dpy);\
        req = (pex/**/name/**/Req *)(dpy->last_req = dpy->bufptr);\
        req->length = (sizeof(pex/**/name/**/Req))>>2;\
        req->reqType = pexi->PEXReqCode;\
        req->opcode = PEX_/**/name;\
	req->format.fpFormat = MyFloatType;\
        dpy->bufptr += sizeof(pex/**/name/**/Req);\
        dpy->request++




/* GetPexFltReqExtra is the same as GetPexFltReq, but allocates "n" additional
   bytes after the request. "n" must be a multiple of 4!  */


#define GetPexFltReqExtra(name, n, req) \
        if ((dpy->bufptr + sizeof(pex/**/name/**/Req) + n) > dpy->bufmax)\
                _XFlush(dpy);\
        req = (pex/**/name/**/Req *)(dpy->last_req = dpy->bufptr);\
        req->length = (sizeof(pex/**/name/**/Req) + n)>>2;\
        req->reqType = pexi->PEXReqCode;\
        req->opcode = PEX_/**/name;\
	req->format.fpFormat = MyFloatType;\
        dpy->bufptr += sizeof(pex/**/name/**/Req) + n;\
        dpy->request++

/*
 * GetPexResReq is for those requests that have a resource ID
 * (Window, Pixmap, GContext, etc.) as their single argument.
 * "rid" is the name of the resource.
 */

#define GetPexResReq(name, rid, req) \
        if ((dpy->bufptr + sizeof(pexResourceReq)) > dpy->bufmax)\
            _XFlush(dpy);\
        req = (pexResourceReq *) (dpy->last_req = dpy->bufptr);\
        req->length = 2;\
        req->id = (rid);\
        req->reqType = pexi->PEXReqCode;\
        req->opcode = PEX_/**/name;\
        dpy->bufptr += sizeof(pexResourceReq);\
        dpy->request++


/*
 * GetPexEmptyReq is for those requests that have no arguments
 * at all.
 */

#define GetPexEmptyReq(name, req) \
        if ((dpy->bufptr + sizeof(pexReq)) > dpy->bufmax)\
            _XFlush(dpy);\
        req = (pexReq *) (dpy->last_req = dpy->bufptr);\
        req->length = 1;\
        req->reqType = pexi->PEXReqCode;\
        req->opcode = PEX_/**/name;\
        dpy->bufptr += sizeof(pexReq);\
        dpy->request++


#endif

