/* 
 * PColor.c - Handle color requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#include "pexDICE.h"

PexLineColorIndex(pexi, index)
    register pexC *pexi;
    pexTableIndex index;
{
    register pexRenderOutputCommandsReq *req;
    register Display *dpy = pexi->phigsDisplay;
    pexLineColorIndex oc;
    long nbytes;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }
    
    nbytes = sizeof(pexLineColorIndex);
    
    oc.head.elementType = OCLineColorIndex;
    oc.head.length = nbytes / 4;
    oc.color = index;
    
    req->numCommands++;
    
    pexPackData( pexi, (char *)(&oc), nbytes );
    req->length	   += nbytes / 4;

    if ( one_shot )
	PexEndRendComm(pexi);
}

PexTextColorIndex( pexi, index )
    register pexC *pexi;
    pexTableIndex index;
{
    register pexRenderOutputCommandsReq *req;
    register Display *dpy = pexi->phigsDisplay;
    pexTextColorIndex oc;
    long nbytes;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }
    
    oc.head.elementType = OCTextColorIndex;
    oc.head.length = sizeof( pexTextColorIndex ) >> 2;
    oc.index = index;
    
    req->numCommands++;
    
    nbytes = sizeof( pexTextColorIndex );
    pexPackData( pexi, (char *)(&oc), nbytes );
    req->length	   += nbytes / 4;
    
    if ( one_shot )
	PexEndRendComm(pexi);
}

PexSurfaceColorIndex(pexi, index)
    register pexC *pexi;
    pexTableIndex index;
{
    register pexRenderOutputCommandsReq *req;
    register Display *dpy = pexi->phigsDisplay;    
    pexSurfaceColorIndex oc;
    long nbytes;
    int one_shot = 0;
    
    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }
    
    oc.head.elementType = OCSurfaceColorIndex;
    oc.head.length = sizeof( pexSurfaceColorIndex ) >> 2;
    oc.color = index;
    
    req->numCommands++;
    
    nbytes = sizeof( pexSurfaceColorIndex );
    pexPackData( pexi, (char *)(&oc), nbytes );
    req->length += nbytes / 4;
    
    if ( one_shot )
	PexEndRendComm(pexi);
}



/*
 * These calls are not currently supported, but hey they were a breeze to
 * write, so why not throw them in.
 */

PexLineColor (pexi, color)
    register pexC *pexi;
    pexColorSpecifier color;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexLineColor oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCLineColor;
    oc.head.length = sizeof (pexLineColor)>>2;
    oc.color = color;
    
    req->numCommands++;

    pexPackData (pexi, (char *)(&oc), sizeof(pexLineColor));
    req->length	+= sizeof (pexLineColor)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}


PexTextColor ( pexi, color )
    register pexC *pexi;
    pexColorSpecifier color;
{
    register pexRenderOutputCommandsReq *req;
    register Display *dpy = pexi->phigsDisplay;
    pexTextColor oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }
    
    oc.head.elementType = OCTextColorIndex;
    oc.head.length = sizeof( pexTextColorIndex ) >> 2;
    oc.color = color;
    
    req->numCommands++;
    
    pexPackData( pexi, (char *)(&oc), sizeof (pexTextColorIndex));
    req->length	   += sizeof (pexTextColorIndex)>>2;
    
    if ( one_shot )
	PexEndRendComm(pexi);
}


PexSurfaceColor (pexi, color)
    register pexC *pexi;
    pexColorSpecifier color;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexSurfaceColor oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCSurfaceColor;
    oc.head.length = sizeof (pexSurfaceColor)>>2;
    oc.color = color;
    
    req->numCommands++;

    pexPackData (pexi, (char *)(&oc), sizeof(pexSurfaceColor));
    req->length	+= sizeof (pexSurfaceColor)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}
