/* 
 * PDisting.c - Handle facet distinguish requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexCurveApproximation ( pexi, approxMethod, tolerance )
    register pexC *pexi;
    pexEnumTypeIndex approxMethod;
    float tolerance;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexCurveApproximation oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCCurveApprox;
    oc.head.length = sizeof(pexCurveApproximation)>>2;
    oc.approx.approxMethod = approxMethod;
    oc.approx.pad = 0;
    oc.approx.tolerance = tolerance;
    
    pexPackData (pexi, (char *)(&oc), sizeof(pexCurveApproximation));

    req->numCommands++;
    req->length	+= sizeof (pexCurveApproximation)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}


PexSurfaceApproximation ( pexi, approxMethod, sTolerance, tTolerance )
    register pexC *pexi;
    pexEnumTypeIndex approxMethod;
    float sTolerance, tTolerance;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexSurfaceApproximation oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCSurfaceApprox;
    oc.head.length = sizeof(pexSurfaceApproximation)>>2;
    oc.approx.approxMethod = approxMethod;
    oc.approx.pad = 0;
    oc.approx.sTolerance = sTolerance;
    oc.approx.tTolerance = tTolerance;
    
    pexPackData (pexi, (char *)(&oc), sizeof(pexSurfaceApproximation));

    req->numCommands++;
    req->length	+= sizeof (pexSurfaceApproximation)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}
