#ifndef lint
static char rcsid[] =
    "@(#) $Header: xphoon.c,v 1.9 88/08/26 22:29:47 jef Exp $ (LBL)";
#endif

/*
** Copyright (C) 1988 by Jef Poskanzer and Craig Leres.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#define BitmapSize(w,h) ((((w)+7)/8)*(h))
#include <stdio.h>
#include <math.h>
#include "tws.h"

char *argv0;
int blackflag = 0;
int demoflag = 0;
Display *dpy = NULL;

char *malloc();

main(argc, argv)
	int argc;
	char **argv;
{
	char *display = NULL;
	int w, h, cx, cy, r;
	int size;
	char *bits, *xbits;
	int delayminutes = 0;

	argv0 = argv[0];
	getbitmap(&w, &h, &bits, &cx, &cy, &r);

again:
	if (argc > 1 && strcmp(argv[1], "-b") == 0) {
		argv++;
		argc--;
		blackflag = 1;
		goto again;
	}
	if (argc > 1 && strcmp(argv[1], "-d") == 0) {
		argv++;
		argc--;
		demoflag = 1;
		goto again;
	}
	if (argc > 2 && strcmp(argv[1], "-t") == 0) {
		argv++;
		argc--;
		if (sscanf(argv[1], "%d", &delayminutes) != 1)
			goto usage;
		argv++;
		argc--;
		goto again;
	}
	if (argc > 2 && strcmp(argv[1], "-x") == 0) {
		argv++;
		argc--;
		if (sscanf(argv[1], "%d", &cx) != 1)
			goto usage;
		argv++;
		argc--;
		goto again;
	}
	if (argc > 2 && strcmp(argv[1], "-y") == 0) {
		argv++;
		argc--;
		if (sscanf(argv[1], "%d", &cy) != 1)
			goto usage;
		argv++;
		argc--;
		goto again;
	}
	if (argc > 2 && strcmp(argv[1], "-display") == 0) {
		argv++;
		argc--;
		display = argv[1];
		argv++;
		argc--;
		goto again;
	}

	if (argc > 1) {
usage:
		fprintf(stderr,
		    "usage: %s [-b] [-t minutes] [-display display]\n", argv0);
		exit(1);
		
	}

	if ((dpy = XOpenDisplay(display)) == 0) {
		fprintf(stderr, "%s: Can't open display \"%s\"\n",
		    argv0, XDisplayName(display));
		exit(1);
	}

	if (delayminutes <= 0 && ! demoflag) {
		hackbits(dtwstime(), w, h, bits, cx, cy, r);
		setroot(w, h, bits);
		XCloseDisplay(dpy);
		exit(0);
	}

	size = BitmapSize(w, h);
	xbits = (char *)malloc(size);
	for (;;) {
		bcopy((char *)bits, (char *)xbits, size);
		hackbits(dtwstime(), w, h, xbits, cx, cy, r);
		setroot(w, h, xbits);
		if ( demoflag )
		    sleep(1);  /* continuous mode */
		else
		    sleep(delayminutes * 60);
	}
	/* NOTREACHED */
}


setroot(w, h, bits)
	int w, h;
	char *bits;
{
	Pixmap bitmap;
	Pixmap pixmap;
	GC gc;
	XGCValues gcv;
	unsigned long length, after;
	int format;
	Atom prop, type;
	unsigned char *data;

	bitmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), bits, w, h);
	if (bitmap == 0) {
		fprintf(stderr, "%s: Unable to store Bitmap", argv0);
		exit(1);
	}

	gcv.foreground = BlackPixel(dpy,DefaultScreen(dpy));
	gcv.background = WhitePixel(dpy,DefaultScreen(dpy));
	gc = XCreateGC(
	    dpy, DefaultRootWindow(dpy), GCForeground|GCBackground, &gcv);

	pixmap = XCreatePixmap(
	    dpy, DefaultRootWindow(dpy), w, h,
	    DefaultDepth(dpy, DefaultScreen(dpy)));
	if (pixmap == 0) {
		fprintf(stderr, "%s: Unable to create Pixmap", argv0);
		exit(1);
	}

	XCopyPlane(dpy, bitmap, pixmap, gc, 0, 0, w, h, 0, 0, 1L);
	XSetWindowBackgroundPixmap(dpy, DefaultRootWindow(dpy), pixmap);
	XFreeGC(dpy, gc);
	XFreePixmap(dpy, bitmap);
	XFreePixmap(dpy, pixmap);
	XClearWindow(dpy, DefaultRootWindow(dpy));
	XFlush(dpy);

	/* Not sure what this garbage does, but xsetroot has it, so... */
	prop = XInternAtom(dpy, "_XSETROOT_ID", False);
	(void) XGetWindowProperty(
	    dpy, DefaultRootWindow(dpy), prop, 0L, 1L, True, AnyPropertyType,
	    &type, &format, &length, &after, &data);
	if ((type == XA_PIXMAP) && (format == 32) &&
	    (length == 1) && (after == 0))
	    XKillClient(dpy, *((Pixmap *)data));
	else if (type != None)
	    fprintf(stderr, "%s: warning: _XSETROOT_ID property is garbage\n",
		    argv0);
	XFlush(dpy);
}


#ifdef notdef
short leftmask[16] = {
    0xffff, 0xfffe, 0xfffc, 0xfff8, 0xfff0, 0xffe0, 0xffc0, 0xff80,
    0xff00, 0xfe00, 0xfc00, 0xf800, 0xf000, 0xe000, 0xc000, 0x8000,
};
short rightmask[16] = {
    0x0000, 0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f,
    0x00ff, 0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff, 0x3fff, 0x7fff,
};
#endif notdef
static char  leftmask[8] = {0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80};
static char rightmask[8] = {0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f};

static char  shade_0_bits[] = {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
static char  shade_1_bits[] = {0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
static char  shade_2_bits[] = {0xfe,0xff,0xfb,0xff,0xff,0xff,0xff,0xff};
static char  shade_3_bits[] = {0xfe,0xff,0xfb,0xff,0x7f,0xff,0xff,0xff};
static char  shade_4_bits[] = {0xfe,0xff,0xfb,0xff,0x7f,0xff,0xff,0xef};
static char  shade_5_bits[] = {0xfe,0xbf,0xfb,0xff,0x7f,0xff,0xff,0xef};
static char  shade_6_bits[] = {0xfe,0xbf,0xfb,0xdf,0x7f,0xff,0xff,0xef};
static char  shade_7_bits[] = {0xfe,0xbf,0xfb,0xdf,0x7f,0xff,0xfe,0xef};
static char  shade_8_bits[] = {0xfe,0xbf,0xfb,0xdf,0x7f,0xdf,0xfe,0xef};
static char  shade_9_bits[] = {0xfe,0xbf,0xfb,0xdf,0x7d,0xdf,0xfe,0xef};
static char shade_10_bits[] = {0xfe,0xbf,0xfb,0xdf,0x7d,0xdf,0xfa,0xef};
static char shade_11_bits[] = {0xfe,0xbf,0xfb,0xdf,0x7d,0xdf,0xfa,0xaf};
static char shade_12_bits[] = {0xfe,0xbf,0xfa,0xdf,0x7d,0xdf,0xfa,0xaf};
static char shade_13_bits[] = {0xfe,0xaf,0xfa,0xdf,0x7d,0xdf,0xfa,0xaf};
static char shade_14_bits[] = {0xfe,0xaf,0xfa,0xdf,0x75,0xdf,0xfa,0xaf};
static char shade_15_bits[] = {0xfa,0xaf,0xfa,0xdf,0x75,0xdf,0xfa,0xaf};

char *shades[16] = {
    shade_0_bits,  shade_1_bits,  shade_2_bits,  shade_3_bits,
    shade_4_bits,  shade_5_bits,  shade_6_bits,  shade_7_bits,
    shade_8_bits,  shade_9_bits,  shade_10_bits, shade_11_bits,
    shade_12_bits, shade_13_bits, shade_14_bits, shade_15_bits };

#define PI 3.14159265358979323846  /* Assume not near black hole or in
				      Tennessee */

double jtime(), phase();

hackbits(t, w, h, bits, cx, cy, r)
	struct tws *t;
	int w, h;
	char *bits;
	int cx, cy, r;
{
	double jd, angphase, cphase, aom, cdist, cangdia, csund, csuang;
	int i;
	register int x, y;
	int xleft, xright;
	double fxleft, fxright;
	double fy;
	int wxright, bxright, wxleft, bxleft;
	int off;
	double cap, ratio;
	int shadeindex;
	char shade;
	static double demoinc = 0.0;

	jd = jtime( t );
	if ( demoflag ) {
		/* Jump ahead a day each time through. */
		jd += demoinc;
		demoinc += 1.0;
	}

	angphase = phase( jd, &cphase, &aom, &cdist, &cangdia, &csund, &csuang);
	cap = cos( angphase );

	/* Hack to figure approximate earthlighting. */
	if ( cphase < 0.1 ) cphase = 0.1;
	if ( cphase > 0.9 ) cphase = 0.9;
	ratio = (1.0 - cphase) / cphase;  /* ratio varies from 9.0 to 0.111 */
	shadeindex = (int) ( ratio / 9.0 * 15.9999 );

#ifdef DEBUG
printf("angphase %f, cap %f\n", angphase, cap);
#endif

	for (i = 0; i < 2 * r; i++) {
		y = cy - r + i;
		fy = i - r;
		fxright = r * sqrt(1.0 - (fy * fy) / (r * r));
		fxleft = - fxright;
		if (angphase >= 0.0 && angphase < PI)
			fxright *= cap;
		else
			fxleft *= cap;

		xright = fxright + cx;
		xleft = fxleft + cx;

		wxright = xright / 8;
		bxright = xright % 8;

		wxleft = xleft / 8;
		bxleft = xleft % 8;

		off = y * ((w + 7) / 8);

		if ( blackflag )
			shade = 0xff;
		else
			shade = shades[shadeindex][y % 8];
		if (wxleft == wxright)
			bits[wxleft + off] |=
				leftmask[bxleft] & shade & rightmask[bxright];
		else {
			bits[wxleft + off] |= leftmask[bxleft] & shade;
			for (x = wxleft + 1; x < wxright; x++)
				bits[x + off] |= shade;
			bits[wxright + off] |= rightmask[bxright] & shade;
		}
	}
	
}
