# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Command.h>
# include <X11/Shell.h>
# include <X11/Form.h>
# include <stdio.h>

# include "home_globs.h"
# include "confirm_globs.h"
# include "globs.h"

Widget		confirm_form;

# ifdef use_popup
Widget		confirm_popup;

static Arg confirm_popup_args[] = {
	{ XtNx,		0 },
	{ XtNy,		0 }
};

static int confirm_popup_args_n = XtNumber(confirm_popup_args);
# endif /* use_popup */

static char label_text[] = "REALLY QUIT?";

static Arg label_args[] = {
	{ XtNlabel,		(XtArgVal) label_text },
	{ XtNborderWidth,	(XtArgVal) 0 },
};

static int label_args_n = XtNumber(label_args);

Widget
confirm_setup(parent, home_form)
	Widget		parent;
	Widget		home_form;
{
	Widget		yep_button;
	Widget		nope_button;
	Widget		label_widget;
	Arg		args[1];

# ifdef use_popup
	XtSetArg(confirm_popup_args[0], XtNx,
		 DisplayWidth(XtDisplay(parent),
			      XDefaultScreen(XtDisplay(parent)))/2);
	XtSetArg(confirm_popup_args[1], XtNy,
		 DisplayHeight(XtDisplay(parent),
			      XDefaultScreen(XtDisplay(parent)))/2);

	confirm_popup = XtCreatePopupShell("confirm",
					   transientShellWidgetClass, parent,
					   confirm_popup_args,
					   confirm_popup_args_n);

	confirm_form = XtCreateManagedWidget("confirm", formWidgetClass,
					     confirm_popup, NULL, 0);
# else /* use_popup */
	confirm_form = XtCreateWidget("confirm", formWidgetClass,
					     parent, NULL, 0);
# endif /* use_popup */

/*	XtSetArg(label_args[2], XtNfont, query_font); */
	label_widget = XtCreateManagedWidget("confirm", labelWidgetClass,
					     confirm_form, label_args,
					     label_args_n);

	yep_button = XtCreateManagedWidget("yep", commandWidgetClass,
					   confirm_form, yep_button_args,
					   yep_button_args_n);
	XtSetArg(args[0], XtNfromVert, label_widget);
	XtSetValues(yep_button, args, 1);
	XtAddCallback(yep_button, XtNcallback, yep_func, (caddr_t) parent);

	nope_button = XtCreateManagedWidget("nope", commandWidgetClass,
					    confirm_form, nope_button_args,
					    nope_button_args_n);
	XtSetArg(args[0], XtNfromVert, label_widget);
	XtSetValues(nope_button, args, 1);
	XtSetArg(args[0], XtNfromHoriz, yep_button);
	XtSetValues(nope_button, args, 1);
	XtAddCallback(nope_button, XtNcallback, nope_func,
		      (caddr_t) home_form);

# ifdef use_popup
	XtRealizeWidget(confirm_popup);
# endif /* use_popup */

	return(confirm_form);
}

confirm(home_form)
	Widget		home_form;
{
# ifdef use_popup
	XtPopup(confirm_popup, XtGrabExclusive);
# else /* use_popup */
	XtUnmanageChild(home_form);
	XtManageChild(confirm_form);
# endif /* use_popup */
}
