# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Command.h>
# include <X11/Label.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

struct toggle_info {
	void		(*ti_set_proc)();
	Widget		ti_on_button;
	Widget		ti_off_button;
};

static Arg		toggle_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 1 }
};

static void
toggle_on_proc(w, client_data, call_data)
	Widget			w;
	caddr_t			client_data;
	caddr_t			call_data;
{
	struct toggle_info	*ti;

	ti = (struct toggle_info *) client_data;
	(*ti->ti_set_proc)(1);

	XtSetSensitive(ti->ti_on_button, False);
	XtSetSensitive(ti->ti_off_button, True);
}

static void
toggle_off_proc(w, client_data, call_data)
	Widget			w;
	caddr_t			client_data;
	caddr_t			call_data;
{
	struct toggle_info	*ti;

	ti = (struct toggle_info *) client_data;
	(*ti->ti_set_proc)(0);

	XtSetSensitive(ti->ti_on_button, True);
	XtSetSensitive(ti->ti_off_button, False);
}

static struct toggle_info *
ti_setup(set_proc, on_button, off_button)
	void		(*set_proc)();
	Widget		on_button;
	Widget		off_button;
{
	extern char		*calloc();
	struct toggle_info	*ti;

	ti = (struct toggle_info *) calloc(1, sizeof(struct toggle_info));
	if (ti == NULL) {
		perror("malloc");
		return(NULL);
	}

	ti->ti_set_proc = set_proc;
	ti->ti_on_button = on_button;
	ti->ti_off_button = off_button;

	return(ti);
}

toggle_setup(name, ly, set_proc, get_proc)
	char		*name;
	layoptr		ly;
	void		(*set_proc)();
	int		(*get_proc)();
{
	struct toggle_info	*ti;
	Widget			toggle_form;
	Widget			toggle_label;
	Widget			toggle_on_button;
	Widget			toggle_off_button;
	Arg			arg;

	toggle_form = XtCreateManagedWidget("toggleForm", formWidgetClass,
					    ly->ly_parent,
					    (ArgList) toggle_form_args,
					    XtNumber(toggle_form_args));
	if (ly->ly_horiz != (Widget) NULL) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(toggle_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) NULL) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(toggle_form, &arg, 1);
	}

	toggle_label = XtCreateManagedWidget("toggleLabel", labelWidgetClass,
					     toggle_form, (ArgList) NULL, 0);
	XtSetArg(arg, XtNlabel, name);
	XtSetValues(toggle_label, &arg, 1);
	XtSetArg(arg, XtNborderWidth, 0);
	XtSetValues(toggle_label, &arg, 1);

	toggle_on_button = XtCreateManagedWidget("toggleOn", commandWidgetClass,
						  toggle_form,
						  (ArgList) NULL, 0);
	XtSetArg(arg, XtNfromVert, toggle_label);
	XtSetValues(toggle_on_button, &arg, 1);
	XtSetArg(arg, XtNlabel, "on");
	XtSetValues(toggle_on_button, &arg, 1);

	toggle_off_button = XtCreateManagedWidget("toggleOff", commandWidgetClass,
						 toggle_form,
						 (ArgList) NULL, 0);
	XtSetArg(arg, XtNfromVert, toggle_label);
	XtSetValues(toggle_off_button, &arg, 1);
	XtSetArg(arg, XtNfromHoriz, toggle_on_button);
	XtSetValues(toggle_off_button, &arg, 1);
	XtSetArg(arg, XtNlabel, "off");
	XtSetValues(toggle_off_button, &arg, 1);

	ti = ti_setup(set_proc, toggle_on_button, toggle_off_button);
	if (ti == NULL)
		exit(1);

	XtAddCallback(toggle_on_button, XtNcallback, toggle_on_proc,
		      (caddr_t) ti);
	XtAddCallback(toggle_off_button, XtNcallback, toggle_off_proc,
		      (caddr_t) ti);

	if ((*get_proc)())
		XtSetSensitive(toggle_on_button, False);
	else
		XtSetSensitive(toggle_off_button, False);

	ly->ly_horiz = toggle_form;
}
