# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Label.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

static Arg		bell_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 0 },
	{ XtNresizable,		(XtArgVal) TRUE }
};

void
bell_form_setup(name, ly)
	char	*name;
	layoptr	ly;
{
	Widget	bell_form;
	Widget	bell_label;
	Arg	arg;

	bell_form = XtCreateManagedWidget("bellForm", formWidgetClass,
					  ly->ly_parent,
					  (ArgList) bell_form_args,
					  XtNumber(bell_form_args));

	if (ly->ly_horiz != (Widget) NULL) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(bell_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) NULL) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(bell_form, &arg, 1);
	}

	XtSetArg(arg, XtNvertDistance, 0);
	XtSetValues(bell_form, &arg, 1);
	XtSetArg(arg, XtNhorizDistance, 0);
	XtSetValues(bell_form, &arg, 1);

	add_form(bell_form);

	bell_label = XtCreateManagedWidget("bellLabel", labelWidgetClass,
					   bell_form, (ArgList) NULL, 0);

	XtSetArg(arg, XtNlabel, name);
	XtSetValues(bell_label, &arg, 1);
	XtSetArg(arg, XtNresizable, TRUE);
	XtSetValues(bell_label, &arg, 1);
	XtSetArg(arg, XtNborderWidth, 0);
	XtSetValues(bell_label, &arg, 1);

	ly->ly_label = bell_label;
	ly->ly_vert = bell_label;
	ly->ly_parent = bell_form;
}
