/*
**	A program to take a snapshot of the names and sizes of
**	windows currently on the screen for use as an initialization spec.
**	See manual page for further explaination.
**
**	Ken Yap
**	Placed in public domain
**	Feb 1988
*/

/*
 *  Modified by Mark Moraes, University of Toronto, to use the
 *  WM_COMMAND and WM_CLIENT_MACHINE properties, and to insert the
 *  geometry into the command line. Note that for the RCMD hack, you
 *  *MUST* run xplaces on the local machine. Also note that the output
 *  of xplaces needs to be ordered by hand so that the console window
 *  (or whatever command you use to terminate X) is execed at the end
 */
 
#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include 	<X11/Xatom.h>
#include	<X11/Xos.h>

fatal(message)
	char		*message;
{
	fprintf(stderr, "%s\n", message);
	exit(1);
}

main(argc, argv)
	int		argc;
	char		*argv[];
{
	register Display	*d;
	register int		width, height;
	int			nchildren;
	char			*win_name;
	Window			root_win, parent_win, *child_list;
	XWindowAttributes	win_info;
	XSizeHints		hints;
	int num_prop, i;
	Atom actual_type;
	int actual_format;
	long nitems;
	long bytes_after;
	int status, len;
	char *propdata;
	char *argument;
	char cmdline[1024];
	char tmpstr[256];
	int nextarg, donegeometry;

	if ((d = XOpenDisplay(NULL)) == NULL)
		fatal("Can't open display");

	/* get a list of children of the root window */
	if (XQueryTree(d, DefaultRootWindow(d), &root_win, &parent_win,
		&child_list, &nchildren) == 0)
		fatal("Can't query window tree");
	/* scan list */
	for ( ; nchildren-- > 0; child_list++)
	{
		/* what is the name? */
		if (!XFetchName(d, *child_list, &win_name))
			continue;		/* not fatal */

		/* what do we know about it? */
		if (!XGetWindowAttributes(d, *child_list, &win_info))
			continue;

		if (win_info.class != InputOutput)
			continue;		/* only live windows desired */

		if (!XGetNormalHints(d, *child_list, &hints))
			continue;

		/* need size either from user or program */
		if (!(hints.flags & (USSize || PSize)))
			continue;

		/* if no increment then assume 1 */
		if (!(hints.flags & PResizeInc))
			hints.width_inc = hints.height_inc = 1;

		/* if no position then assume +0+0 */
		if (!(hints.flags & (USPosition || PPosition)))
			hints.x = hints.y = 0;

		/* if no min width or height then assume 0 */
		if (!(hints.flags & PMinSize))
			hints.min_width = hints.min_height = 0;

		/* terminal windows sizes are in characters so this
		will compute the geometry correctly */
		if (hints.width_inc > 1 && hints.height_inc > 1)
		{
			width = (hints.width - hints.min_width) / hints.width_inc;
			height = (hints.height - hints.min_height) / hints.height_inc;
		}
		else
		{
			width = win_info.width;
			height = win_info.height;
		}

		if (win_name == NULL)
			continue;		/* ignore anonymous windows */
		status = XGetWindowProperty(d, *child_list,
	 	 XA_WM_COMMAND, 0, (long) 4096, 
		 False, AnyPropertyType, &actual_type, &actual_format, 
		 &nitems, &bytes_after, &propdata);
		if (status==BadWindow) {
			fprintf(stderr, "window id # 0x%lx does not exists!\n", 
			 *child_list);
			continue;
		}
		if (status!=Success) {
			fprintf(stderr, "XGetWindowProperty failed!\n");
			continue;
		}
		if (bytes_after != 0) {
			fprintf(stderr, "Only got the first %d items. %d bytes remain\n", 
			 nitems, bytes_after);
		}
		if (!(argument = propdata))
			continue;
		len= 0;
		nextarg = 0;
		donegeometry = 0;
		*cmdline = '\0';
		do {
			if (nextarg || *argument == '=') {
				nextarg = 0;
				if (donegeometry)
					continue;
				sprintf(tmpstr, "-geometry %dx%d+%d+%d ", 
				 width, height, hints.x, hints.y);
				strcat(cmdline, tmpstr);
				donegeometry++;
			} else if (argument != propdata && 
			 strcmp(argument, "-geometry") == 0) {
				nextarg++;
			} else {
				sprintf(tmpstr, "%s ", argument);
				strcat(cmdline, tmpstr);
			}
			len += strlen(argument) + 1;
			argument = &propdata[len];
		} while (len < nitems);
#ifdef RCMD
		free(propdata);
		status = XGetWindowProperty(d, *child_list,
	 	 XA_WM_CLIENT_MACHINE, 0, (long) 4096, 
		 False, AnyPropertyType, &actual_type, &actual_format, 
		 &nitems, &bytes_after, &propdata);
		if (status==BadWindow) {
			fprintf(stderr, "window id # 0x%lx does not exists!\n", 
			 *child_list);
			continue;
		}
		if (status!=Success) {
			fprintf(stderr, "XGetWindowProperty failed!\n");
			continue;
		}
		if (bytes_after != 0) {
			fprintf(stderr, "Only got the first %d items. %d bytes remain\n", 
			 nitems, bytes_after);
		}
		gethostname(tmpstr, sizeof(tmpstr));
		if (strcmp(propdata, tmpstr) != 0) {
			printf("rcmd %s ", propdata);
		}
		free(propdata);
#endif
		/*
		 *  We need to look at the argv string we just got - if
		 *  it has a -geometry, then replace with true geometry.
		 *  It seems safest to insert it just after argv[0]
		 *  since xterm for instance expects no options after
		 *  a -e. 
		 */
		if (!donegeometry) {
			register char *arg = cmdline;
			
			sprintf(tmpstr, "-geometry %dx%d+%d+%d ", 
			 width, height, hints.x, hints.y);
			while(*arg != ' ' && *arg != '\0')
				arg++;
			*arg++ = '\0';
			/* print argv[0] and the geometry */
			printf("%s %s ", cmdline, tmpstr);
			printf("%s &\n", arg);
		} else {
			printf("%s &\n", cmdline);
		}
		/* 
		 *  Finally, still unsolved, there's the problem of
		 *  state - iconic, etc? Not much use getting the icon
		 *  geometry
		 */
	}
}
