/* $Header: xpic.h,v 1.3 88/08/31 23:47:12 moraes Exp $ */

#include <X11/Intrinsic.h>
#include <X11/Xos.h>

#include <stdio.h>

/*
 *  Some basic functions
 */
#ifndef MAX
#define MAX(x,y)	(((x) > (y)) ? (x) : (y))
#define MIN(x,y)	(((x) < (y)) ? (x) : (y))
#endif
#define ABS(x)		(((x) >= 0) ? (x) : -(x))
#define SGN(x)		(((x) > 0) ? 1 : (((x) < 0) ? -1 : 0))
/*
 *  Modulo function giving non-negative result
 */
#define IMOD(x,y)	(((x) % (y)) >= 0 ? ((x) % (y)) : ((x) % (y)) + (y))

/*
 *  Range checking - between lo & hi, inclusive
 */
#define IN_RANGE(x, lo, hi)	((lo) <= (x) && (x) <= (hi))

/*
 *  Two different strings are often different on the first char.
 */
#define STREQ(s1, s2)	((*s1)==(*s2) && strcmp(s1, s2) == 0)
#define STRLT(s1, s2)	(strcmp(s1, s2) < 0)
#define STRGT(s1, s2)	(strcmp(s1, s2) > 0)

#define BOOL		int

#define YES		1
#define NO		0
#define ABORT	-1		/* Returned by the get_input routine */

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define MAXSTR			64

/* 'snap' rounds x to the nearest number divisible by dx */
#define snap(x, dx)	(((int) (((x) + (dx / 2)) / dx)) * dx)

/*
 *  Stores the graphic elements as a struct which contains a bounding box,
 *  an element type (tokens), a pointer to the data for the element, and
 *  an attribute word.  For such things as boxes the data pointer will be
 *  null.  For polylines and splines, it will consist of a linked list of
 *  points. For a conic (circle, ellipse), it will consist of centre, and
 *  the x and y radii.  For text, it consists of a length, and a string.
 *  For cells, it consists of a name, and a pointer to a graphic struct.
 *  The attributes fit into a long int. They are things like linestyle
 *  (solid, dotted, short dashed, long dashed, dot dashed), arrowtype
 *  (noarrow, arrow at the start, arrow at the end, arrow at both ends),
 *  and whether the box/conic is filled or not. Text fonts, text sizes are
 *  stored in the text struct itself
 */

#include <sys/types.h>


typedef struct {
	int x, y;
} Point;

typedef struct {
	Point ll, ur;
} Box;

typedef struct _gel {
	Box b_box;
	int type;					/* The type of gel - see below */
	int attributes;				/*
								 *  The attributes for the gel -
								 *  linestyle, arrowstyle, fillstyle,
								 *  text alignment
								 */
	int number;					/*
								 *  The id number of the gel - so they
								 *  can be kept in sorted order - this
								 *  will be necessary when doing filled
								 *  shapes - making sure different
								 *  shapes get drawn in the right order
								 */
	int linewidth;				/* Line thickness */
	int int_flags;				/*
								 *  For internal use only - (eg) marking
								 *  during select
								 */
	caddr_t data;				/*
								 *  A gel dependent item - it points to
								 *  nothing for a box, which is
								 *  represented by the bounding box, to
								 *  a struct of type PointList for lines
								 *  and splines, to a TextString for
								 *  text, to a Conic for circles and
								 *  ellipses
								 */
	struct _gel *next;
} Gel;

/* Various types of gels */
#define CELL	0
#define LINE	1
#define SPLINE	2
#define BOX		3
#define CIRCLE	4
#define ELLIPSE	5
#define TEXT	6
/* Pseudo-objects - we use them during edit operations */
#define BLOCK	7
#define ELEMENT	8

/* Using one nybble per attribute should leave enough room for expansion */
#define getlinestyle(x)		(x & 0x000f)
#define SOLID	0x0000
#define DOTTED	0x0001
#define SDASH	0x0002
#define LDASH	0x0003
#define DDASH	0x0004
#define NSTYLES	5

#define getlinearrow(x)		((x & 0x00f0) >> 4)
#define NO_ARROW	0x0000
#define ST_ARROW	0x0010
#define EN_ARROW	0x0020

/* !!
 *  Implementing this implies taking care of object ordering - what gets
 *  drawn on top of what. Not yet done.
 */
#define getfillstyle(x)		((x & 0x0f00) >> 8)
#define EMPTY	0x0000
#define GRAY0	0x0000
#define GRAY1	0x0100
#define GRAY2	0x0200
#define GRAY3	0x0300
#define GRAY4	0x0400
#define GRAY5	0x0500
#define GRAY6	0x0600
#define GRAY7	0x0700
#define GRAY8	0x0800
#define GRAY9	0x0900
#define NFILLSTYLES	10

/* Text alignment is in two  bits */
#define HALIGN	0x3000
#define gettext_halign(x)	((x & HALIGN) >> 12)
#define CENTRE	0x0000
#define LJUST	0x1000
#define RJUST	0x2000

#define VALIGN	0xc000
#define gettext_valign(x)	((x & VALIGN) >> 14)
#define MIDLINE	0x0000
#define TOPLINE	0x4000
#define BOTLINE	0x8000

/* Marks the elements in a gel list which have been selected and discarded */
#define SELECTED 0x0001
/* Marks a hilited gel - makes unhilite safer! */
#define HILITED	 0x0002

typedef struct {
	int nVerts;
	XPoint *v;
} PointList;


typedef struct {
	Point centre;
	int xrad, yrad;
} Conic;

typedef struct {
	int pointsize;		/* At the current screen resolution */
	char *xfontname;	/* to use for XLoadQueryFont() */
	XFontStruct *font;	/* Actual font */
} FontSizes;

typedef struct {
	char *name;
	FontSizes *sizes;
	int nsizes;
	int maxsizes;
	int cursize;
} FontFamily;

typedef struct {
	char *name;
	void (* handler)();
} ButtonInfo;

typedef struct _text {
	int x, y;
	int length;
	char *str;
	FontFamily *font;
	int sizeindex;
	char *fontname;
	int fontsize;
} TextString;

/* A string buffer that reallocates itself - size is the actual alloced size */
typedef struct {
	char *buf;
	int size;
} Buf;

#define BUF_CHUNK 128

/* 
 *  Cells are the actual pictures - they are essentially one Gel linked
 *  list, a corresponding View, and a bit of info about the cell status.
 *  They form a linked list too, because one xpic may have multiple cells.
 */
typedef struct _cell {
	Gel *gelList;				/* All the cell's graphic elements */
	int undo;					/* 
								 *  For an undo operation, the top 'undo'
								 *  elements must be removed from gelList
								 *  and...
								 */
	Gel *undoList;				/*
								 *  .. the elements in 'undoList' must be
								 *  added to gelList
								 */
	char *name;					/* cell name */
	char *filename;				/* File associated with this cell */
	time_t mtime;				/* The last modified time of the cell file */
	int saved;					/* Is this thing saved? */
	int changes;				/* Number of changes since last checkpoint */
	struct _cell *next;
} Cell;

#define SAVED		0x00
#define MODIFIED	0x01
#define NEWFILE		0x10

/* These are or'ed with the event codes to give the event type */
#define START_MODE	0x100
#define END_MODE	0x200
#define DRAG_MODE	0x300
#define ASK_MODE	0x400

/* Event codes */
#define REDRAW		0x01
#define MOTION		0x02
#define LEFT		0x03
#define RIGHT		0x04
#define MIDDLE		0x05

/* Various editing functions - either BLOCK or ELEMENT */
#define COPY		1
#define MOVE		2
#define DELETE		3
#define	PASTE		4
#define GET			5
#define PUT			6
#define ADJUST		7
#define ROTATE		8
#define SCALE		9
#define CHANGE_ATTRIBUTE	10

/* DrawGel can draw a Gel in one of these modes */
#define DRAW		1
#define ERASE		2
#define INVERT		3
#define HILITE		4

int drawingMode;			/* Stores the current drawing mode:START_MODE etc*/
int objectType;				/* stores the current object type - LINE, etc. */
int editType;				/*
							 *  stores the current editing operation -
							 *  Copy, delete, move, etc.
							 */
int editMode;				/*
							 *  Stores the current editing mode - BLOCK,
							 *  ELEMENT
							 */

int line_type;
int line_arrow;

struct {
	char *pattern;
	int len;
} LineTypes[NSTYLES];

#define MAKEPATTERN(style, dashlist) \
	((style).pattern = (dashlist), (style).len = strlen(dashlist))

int fill_type;
Pixmap FillTypes[NFILLSTYLES];

/* Stuff to store text parameters */
int textVertAlign, textHorizAlign;

/*  The next few globals contain info about the current font */
XFontStruct *textFont;			/* Pointer to the current font XFontStruct */
int textSize;					/* The point size of the current font */
int spacePad;					/* The space pad required for the font */
FontFamily *fontType;			/* The name of a font */
Cell *CurrentCell;				/* The current cell being viewed */
Cell *LastCell;
Cell *MainCell;					/* head of the linked list of cells */
Gel *KillBuffer;
Box picBox;
char *nullfile;
char *argfile;
char errstring[128];
char *homeDir;
FILE *inFile, *outFile;
BOOL backupOnWrite;
int mouseResolution;
int GelCounter;
int lineThickness;
char *progname;
