/* $Header: windows.h,v 1.2 88/08/19 00:01:24 moraes Exp $ */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

/*
 *  The basic unit of scale is the separation of the grid points on the
 *  screen. Crosses are spaced every five grid points. I'm assuming the
 *  crosses to be 0.5 inches apart, and determine sizes from that by
 *  calculation. This simplifies drawing and re-scaling, I hope. It also
 *  allows pictures displayed on a high-resolution screen to be displayed
 *  on a screen of different resolution without changing the "snap". The
 *  use of that bizarre unit - the inch - is purely because that's how
 *  most of us still think of paper sizes.
 */

#define DEFAULTSPACING		8		/*
									 *  For high resolution Sun3/260's it
									 *  is better to use 10
									 */
#define MINSPACING			2

/* Letter size LaserWriter(tm) imaging area size, actually */
#define DEFAULTPAGEHEIGHT	105		/* inches * 10 :-) */
#define DEFAULTPAGEWIDTH	80
#define MINPAGEHEIGHT		60		/* Paper can't get smaller than 6x6" */
#define MINPAGEWIDTH		60

/* 
 *  Defaults almost fill the screen of a Sun-3/50 Gives a nice round scale
 *  factor, with 8 pixel spacing of grid points, 40 pixel spacing of the
 *  crosses. Note that fonts are scaled for this grid spacing.
 */

#define DEFAULTPICHEIGHT	DEFAULTPAGEHEIGHT * DEFAULTSPACING;
#define DEFAULTPICWIDTH		DEFAULTPAGEWIDTH * DEFAULTSPACING;


/*
 *  This font MUST be available, or else xpic won't start up. Doesn't
 *  really matter what it is thouh
 */

#define DEFAULT_FONT		"9x15"

/* The page width and height, in tenths of an inch */
int pageWidth, pageHeight;

Widget outerFrame;		/* The main window frame */
Widget picWidget;
Window picWin;			/* The actual drawing window */
/* We shouldn't need these in X11 */
int picWinWidth;
int picWinHeight;
int minPicWidth, minPicHeight;
Widget inputWidget;
Window inputWin;
Display *picDpy;

/*
 *  These are the 'current' GC values - the current element will use
 *  these values
 */
GC gcNormal, gcInvert, gcErase, gcGray;
/* Used for boxes, outlines, drags etc */
GC gcBlock;
/* 
 *  The contents of tmpGcNormal and Invert can be changed at any time by
 *  any routine. They're meant to be fast change GCs. Note that all the
 *  xxx_adj() routines use it, and make the HORRIBLE assumptions that
 *  no-one will change these during an ADJUST (START_MODE to END_MODE
 *  back to START_MODE) operation. Otherwise, we either need lots of GCs
 *  or we need lots of changes to the GCs when rubber banding.
 */
GC tmpGcNormal, tmpGcInvert, tmpGcErase;
XGCValues gcVal;

Pixmap gridTile;
Pixmap blankTile;
int gridSpacing;
BOOL gridOn;

Pixel cursorColor, gridColor, highlight;
/*
 *  verts is the XPoint buffer for the points input by the user for lines
 *  and splines
 */
#define INC_VERTS	128	/* The blocks in which the verts buffer is increased */
XPoint *verts;			/* Used to store lines and splnes temporarily */
int nVerts;
int maxVerts;

/*
 *  Stores the 'flattened' output of the BSpline routines. Flattening is
 *  the process by which the polygon defining the spline is converted into
 *  the lots of little line segments forming the curve. 
 */
XPoint *flatVerts;
int flatSize;
int nFlat;
XPoint *flatVerts2;
int flatSize2;

void CreateWindows();
void RedrawPicWin();
