#ifndef lint
static char *rcsid="$Header: usleep.c,v 1.1 88/08/31 23:45:37 moraes Exp $";
#endif

/* A sleazy usleep() call for stupid Un*xs that don't have one. Among
   other things, it isn't reentrant, and no one else had better be using 
   SIGALRM at the same time - it makes only a token gesture on that front
 */

#include <X11/Xos.h>
#include <signal.h>

static int done = 0;

static void alarm()
{
	done = 1;
}


usleep(n)
{
	struct itimerval value, ovalue;
	int (*func)();
	
	if (n <= 0)
		return;

	value.it_interval.tv_usec = 0;
	value.it_interval.tv_sec = 0;
	value.it_value.tv_usec = n % 1000000;
	value.it_value.tv_sec = n / 1000000;

	func = signal(SIGALRM, alarm);
	setitimer(ITIMER_REAL, &value, &ovalue);
	while (!done)
		sigpause(SIGALRM);

	signal(SIGALRM, func);
	/* This is plain wrong - we should reset it after suitably subtracting
	   the time it that we've already waited for */
	setitimer(ITIMER_REAL, &ovalue, &value);
}

#endif
