/* $Header: obj_ell.c,v 1.2 88/08/19 00:00:56 moraes Exp $ */
/*
 *  The ellipse object routines
 */
#include "xpic.h"
#include "windows.h"
#include "gels.h"
#include "draw.h"
#include "assert.h"

static int x1, y1, x2, y2;			/* Corners of box, ellipse, ends of line */
static int xmin, xmax, ymin, ymax;	/* Bounding box */
static int xc, yc, xr, yr;			/* centre, radius of circles, ellipse */

ellipse_event(evtype, mx, my)
{
	switch(evtype) {
	case MOTION | START_MODE:
	case RIGHT  | START_MODE:
	case MIDDLE | START_MODE:
	case REDRAW | START_MODE:
	case RIGHT  | END_MODE:
		break;
	case MOTION | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, gcInvert);
		x2 = mx;
		y2 = my;
		xc = (x2 + x1) / 2;
		yc = (y2 + y1) / 2;
		xr = ABS(x2 - xc);
		yr = ABS(y2 - yc);
		ellipse(picWin, xc, yc, xr, yr, gcInvert);
		box(picWin, x1, y1, x2, y2, gcBlock);
		break;
	case LEFT | START_MODE:
		x1 = x2 = xc = mx;
		y1 = y2 = yc = my;
		xr = yr = 0;
		drawingMode = END_MODE;
		ellipse(picWin, xc, yc, xr, yr, gcInvert);
		break;
	case LEFT | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, gcInvert);
		x2 = mx;
		y2 = my;
		xc = (x2 + x1) / 2;
		yc = (y2 + y1) / 2;
		xr = ABS(x2 - xc);
		yr = ABS(y2 - yc);
		xmin = MIN(x1, mx);
		xmax = MAX(x1, mx);
		ymin = MIN(y1, my);
		ymax = MAX(y1, my);
		ellipse(picWin, xc, yc, xr, yr, gcNormal);
		AddConicGel(&(CurrentCell->gelList), ELLIPSE, xc, yc, xr, yr,
		 line_type | fill_type, xmin, ymin, xmax, ymax, lineThickness);
		FreeGel(CurrentCell->undoList);
		CurrentCell->undoList = NULL;
		CurrentCell->undo = 1;
		CurrentCell->saved |= MODIFIED;
		drawingMode = START_MODE;
		break;
	case MIDDLE | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, gcInvert);
		drawingMode = START_MODE;
		break;
	case REDRAW | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, gcInvert);
		break;
	default:
#ifdef DEBUG
		sprintf(errstring, "Hey! Unknown ELLIPSE mode %d", drawingMode);
		message(errstring);
#endif
		break;
	}
	ASSERT(allock(), "ellipse_event");
}


ellipse_abort()
{
	ellipse_event((MIDDLE | drawingMode), 0, 0);
}
	

ellipse_adj(evtype, gel, mx, my)
int evtype;
Gel *gel;
int mx, my;
{
	static Gel *ellgel;
	/*
	 *  Will not need to process MOTION|START_MODE, RIGHT|START_MODE,
	 *  REDRAW|START_MODE - these are taken care of in
	 *  the adj_element routine.
	 */
	switch(evtype) {
	case MOTION | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, tmpGcInvert);
		x2 = mx;
		y2 = my;
		xc = (x2 + x1) / 2;
		yc = (y2 + y1) / 2;
		xr = ABS(x2 - xc);
		yr = ABS(y2 - yc);
		ellipse(picWin, xc, yc, xr, yr, tmpGcInvert);
		box(picWin, x1, y1, x2, y2, gcBlock);
		break;
	case LEFT | START_MODE:
		GetBoxCorners(&x1, &y1, &x2, &y2, &gel->b_box, mx, my);
		xc = (x1 + x2) / 2;
		yc = (y1 + y2) / 2;
		xr = ABS(x2 - xc);
		yr = ABS(y2 - yc);
		ellgel = gel;
		drawingMode = END_MODE;
		setwidth(tmpGcNormal, ellgel->linewidth);
		setwidth(tmpGcInvert, ellgel->linewidth);
		SETDASHES(tmpGcNormal, getlinestyle(ellgel->attributes))
		SETDASHES(tmpGcInvert, getlinestyle(ellgel->attributes))
		ellipse(picWin, xc, yc, xr, yr, tmpGcInvert);
		box(picWin, x1, y1, x2, y2, gcBlock);
		break;
	case LEFT | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, tmpGcInvert);
		x2 = mx;
		y2 = my;
		xc = (x2 + x1) / 2;
		yc = (y2 + y1) / 2;
		xr = ABS(x2 - xc);
		yr = ABS(y2 - yc);
		xmin = MIN(x1, mx);
		xmax = MAX(x1, mx);
		ymin = MIN(y1, my);
		ymax = MAX(y1, my);
		ellipse(picWin, xc, yc, xr, yr, tmpGcNormal);
		AddConicGel(&(CurrentCell->gelList), ELLIPSE, xc, yc, xr, yr, 
		 ellgel->attributes, xmin, ymin, xmax, ymax, ellgel->linewidth);
		FreeGel(CurrentCell->undoList);
		CurrentCell->undoList = ellgel;
		ellgel = NULL;
		CurrentCell->undo = 1;
		CurrentCell->saved |= MODIFIED;
		drawingMode = START_MODE;
		break;
	case RIGHT | END_MODE:
	case MIDDLE | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, tmpGcInvert);
		GelDraw(ellgel, DRAW);
		PushUnderUndo(&(CurrentCell->gelList), ellgel, CurrentCell->undo);
		ellgel = NULL;
		if (evtype == (MIDDLE | END_MODE))
			ClearGelFlags(CurrentCell->gelList);
		drawingMode = START_MODE;
		break;
	case MIDDLE | START_MODE:
		ClearGelFlags(CurrentCell->gelList);
		break;
	case REDRAW | END_MODE:
		box(picWin, x1, y1, x2, y2, gcBlock);
		ellipse(picWin, xc, yc, xr, yr, tmpGcInvert);
		break;
	default:
#ifdef DEBUG
		sprintf(errstring, "Hey! Unknown mode %d in ellipse_adj", 
		 evtype);
		message(errstring);
#endif
		break;
	}
	ASSERT(allock(), "ellipse_adj");
}
