/*
 *  hacked to remove the Overhead around buttons - the fancy outline
 *  etc. Included the FillRectangle from XwDrawButton (in Button.c)
 *  directly here, resulting in much faster button drawing, and smaller
 *  buttons - both of which I need. See the button redraw if you don't
 *  believe me - link to the standard Xw PButton (by removing this
 *  PButton.o from the link) and compare. A cleaner way would have been
 *  to make the shadow stuff a Boolean, but that would mean modifying
 *  this to add that resource etc, fixing Button.c, and changing Toggle
 *  which also calls XwDrawButton. Urk! - Mark Moraes, Aug 1988.
 */
static char rcsid[] = "$Header: PButton.c,v 1.1 88/08/18 23:54:44 moraes Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        PButton.c
 **
 **   Project:     X Widgets
 **
 **   Description: Contains code for primitive widget class: PushButton
 **
 **   Author:  Bob Miller
 **            Hewlett Packard Co.
 **            Corvallis Workstation Operation (CWO)
 **
 ** 
 ** Copyright (c) 1988 by Hewlett-Packard Company
 ** Copyright (c) 1988 by the Massachusetts Institute of Technology
 ** 
 ** Permission to use, copy, modify, and distribute this software 
 ** and its documentation for any purpose and without fee is hereby 
 ** granted, provided that the above copyright notice appear in all 
 ** copies and that both that copyright notice and this permission 
 ** notice appear in supporting documentation, and that the names of 
 ** Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 ** pertaining to distribution of the software without specific, written 
 ** prior permission.
 **
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	PButton.c,v $
 * Revision 1.1  88/08/18  23:54:44  moraes
 * X11R2 version - fully working
 * 
 * Revision 2.5  88/04/13  16:38:25  16:38:25  bobmi (Bob Miller)
 * Removed duplicate define of XwStrlen.
 * 
 * Revision 2.4  88/04/13  09:34:18  09:34:18  bobmi (Bob Miller)
 * Added copyright notice.
 * 
 * Revision 2.3  88/04/04  13:33:16  13:33:16  ben (Benjamin Ellsworth)
 * Replaced any reference to IntrincI.h with reference to
 * IntrinsicP.h for 4/88 build.
 * 
 * Revision 2.2  88/03/31  18:26:35  18:26:35  ben (Benjamin Ellsworth)
 * Replaced all references to Atoms.h with StringDefs.h, as per R2 Toolkit
 * 
 * Revision 2.1  88/03/25  16:46:26  16:46:26  bobmi (Bob Miller)
 * Put in real traversal key translations.
 * 
 * Revision 2.0  88/03/21  17:10:24  17:10:24  bobmi ()
 * Updated to Xtk R2 and fixed bugs.
 * 
 * Revision 1.3  88/02/18  12:43:26  12:43:26  bobmi ()
 * Changed name of _XwRealizeButton to _XwRealize.
 * 
 * Revision 1.2  88/02/18  11:31:28  11:31:28  bobmi ()
 * Added traversal Focus In/Out translations/action table.
 * 
 * Revision 1.1  88/02/02  09:13:11  09:13:11  bobmi ()
 * Initial revision
 * 
 * Revision 1.3  87/12/11  15:47:42  15:47:42  bobmi ()
 * *** empty log message ***
 * 
 * Revision 1.2  87/12/08  13:53:47  13:53:47  bobmi ()
 * blah blah
 * 
 * Revision 1.1  87/12/07  09:24:48  09:24:48  rick ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/

/*
 * Include files & Static Routine Definitions
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Misc.h>
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Xw/PButtonP.h>
#include <Xw/PButton.h>
#include <X11/keysymdef.h>   
   

static void Redisplay();
static void RedrawButtonFace();
static Boolean SetValues();
static void ClassInitialize();
static void Initialize();
static void Toggle();
static void Select();
static void Unselect();
static void Resize();


/*************************************<->*************************************
 *
 *
 *   Description:  default translation table for class: PushButton
 *   -----------
 *
 *   Matches events with string descriptors for internal routines.
 *
 *************************************<->***********************************/


static char defaultTranslations[] =
   "<Btn1Down>:             select() \n\
    <Btn1Up>:             unselect() \n\
    <EnterWindow>:          enter() \n\
    <LeaveWindow>:          leave() \n\
    <FocusIn>:              focusIn() \n\
    <FocusOut>:             focusOut() \n\
    <KeyDown>s:             select() \n\
    <KeyDown>0xFF60:   select() \n\
    <KeyUp>0xFF60:     unselect() \n\
    <Key>0xFF52:       traverseUp() \n\
    <Key>0xFF54:       traverseDown() \n\
    <Key>0xFF51:      traverseLeft() \n\
    <Key>0xFF53:       traverseRight() \n\
    <Key>0xFF56:       traverseNext() \n\
    <Key>0xFF55:       traversePrev() \n\
    <Key>0xFF50:       traverseHome()";



/*************************************<->*************************************
 *
 *
 *   Description:  action list for class: PushButton
 *   -----------
 *
 *   Matches string descriptors with internal routines.
 *
 *************************************<->***********************************/

static XtActionsRec actionsList[] =
{
  {"toggle", (XtActionProc) Toggle},
  {"select", (XtActionProc) Select},
  {"unselect", (XtActionProc) Unselect},
  {"enter", (XtActionProc) _XwPrimitiveEnter},
  {"leave", (XtActionProc) _XwPrimitiveLeave},
  {"focusIn", (XtActionProc) _XwPrimitiveFocusIn},
  {"focusOut", (XtActionProc) _XwPrimitiveFocusOut},
  {"traverseLeft", (XtActionProc) _XwTraverseLeft },
  {"traverseRight", (XtActionProc) _XwTraverseRight },
  {"traverseUp", (XtActionProc) _XwTraverseUp },
  {"traverseDown", (XtActionProc) _XwTraverseDown },
  {"traverseNext", (XtActionProc) _XwTraverseNext },
  {"traversePrev", (XtActionProc) _XwTraversePrev },
  {"traverseHome", (XtActionProc) _XwTraverseHome },
};




/*************************************<->*************************************
 *
 *
 *   Description:  global class record for instances of class: PushButton
 *   -----------
 *
 *   Defines default field settings for this class record.
 *
 *************************************<->***********************************/

XwPushButtonClassRec XwpushButtonClassRec = {
  {
/* core_class fields */	
    /* superclass	  */	(WidgetClass) &XwbuttonClassRec,
    /* class_name	  */	"PushButton",
    /* widget_size	  */	sizeof(XwPushButtonRec),
    /* class_initialize   */    ClassInitialize,
    /* class_part_init    */    NULL,				
    /* class_inited       */	FALSE,
    /* initialize	  */	Initialize,
    /* initialize_hook    */    NULL,
    /* realize		  */	_XwRealize,
    /* actions		  */	actionsList,
    /* num_actions	  */	XtNumber(actionsList),
    /* resources	  */	NULL,
    /* num_resources	  */	0,
    /* xrm_class	  */	NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterlv   */    TRUE,
    /* visible_interest	  */	FALSE,
    /* destroy		  */	NULL,
    /* resize		  */	Resize,
    /* expose		  */	Redisplay,
    /* set_values	  */	SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus	  */	NULL,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      defaultTranslations,
    /* query_geometry   */	NULL, 
  }
};
WidgetClass XwpushButtonWidgetClass = (WidgetClass)&XwpushButtonClassRec;


/*************************************<->*************************************
 *
 *  Toggle (w, event)                  PRIVATE
 *
 *   Description:
 *   -----------
 *     When this pushbutton is selected, toggle the activation state
 *     (i.e., draw it as active if it was not active and draw it as
 *     inactive if it was active).  Generate the correct callbacks
 *     in response.
 *
 *     NOTE: this code assumes that instances do not receive selection
 *           events when insensitive.
 *
 *   Inputs:
 *   ------
 *     w           =   widget instance that was selected.
 *     event       =   event record
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XtCallCallbacks()  [libXtk]
 *   Redisplay  [PushButton.c]
 *************************************<->***********************************/

static void Toggle(w,event)
     Widget w;
     XEvent *event;
{
  XwPushButtonWidget pb = (XwPushButtonWidget)w;
  pb->button.set = (pb->button.set) ? FALSE : TRUE;
  RedrawButtonFace(w, event, FALSE);
  XFlush(XtDisplay(w));
  XtCallCallbacks (w, ((pb->button.set) ? XtNselect : XtNrelease), NULL);
}


/*************************************<->*************************************
 *
 *  Select (w, event)                  PRIVATE
 *
 *   Description:
 *   -----------
 *     Mark pushbutton as selected, (i.e., draw it as active)
 *     Generate the correct callbacks.
 *
 *     NOTE: this code assumes that instances do not receive selection
 *           events when insensitive.
 *
 *   Inputs:
 *   ------
 *     w           =   widget instance that was selected.
 *     event       =   event record
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XtCallCallbacks()  [libXtk]
 *   Redisplay()        [PushButton.c]
 *************************************<->***********************************/

static void Select(w,event)
     Widget w;
     XEvent *event;
{
  XwPushButtonWidget pb = (XwPushButtonWidget)w;

  pb->button.set = TRUE;
  RedrawButtonFace(w, event, FALSE);
  XFlush(XtDisplay(w));
  XtCallCallbacks (w, XtNselect, NULL);
}


/*************************************<->*************************************
 *
 *  Unselect (w, event)                  PRIVATE
 *
 *   Description:
 *   -----------
 *     When this pushbutton is unselected draw it as inactive.
 *     Generate the correct callbacks.
 *
 *     NOTE: this code assumes that instances do not receive selection
 *           events when insensitive.
 *
 *   Inputs:
 *   ------
 *     w           =   widget instance that was selected.
 *     event       =   event record
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XtCallCallbacks()   [libXtk]
 *   Redisplay()         [PushButton.c]
 *************************************<->***********************************/

static void Unselect(w,event)
     Widget w;
     XEvent *event;
{
  XwPushButtonWidget pb = (XwPushButtonWidget)w;

  pb->button.set = FALSE;
  RedrawButtonFace(w, event, FALSE);
  XFlush(XtDisplay(w));
  XtCallCallbacks (w, XtNrelease, NULL);
}


/*************************************<->*************************************
 *
 *  Initialize 
 *
 *   Description:
 *   -----------
 *    If the core height and width fields are set to 0, treat that as a flag
 *    and compute the optimum size for this button.  Then using what ever
 *    the core fields are set to, compute the text placement fields.
 *    Make sure that the label location field is properly set for the
 *    Resize call.
 *
 *
 *   Inputs:
 *   ------
 *     request		=	request widget, old data.
 *
 *     new		=	new widget, new data; cumulative effect
 *				of initialize procedures.
 *
 *     args		=	programmer supplied argument list.
 *
 *     p_num_args       =       pointer to the number of arguments in
 *				argument list.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *
 *************************************<->***********************************/
static void Initialize (request, new, args, p_num_args)
 Widget request, new;
 ArgList args;
 Cardinal *p_num_args;
{
     XwPushButtonWidget pb = (XwPushButtonWidget) new;

/******************************************************************** 
  Needed width:
    2 * highlight thickness
    2 * internal width (padding between label and button)
    width of label

   Needed height:
    2 * highlight thickness
    2 * internal height (padding)
    label height
    
************************************************************************/
    if (request->core.width == 0)  pb->core.width =  pb->button.label_width +
	      2 * ( pb->button.internal_width +    /* white space */
		     pb->primitive.highlight_thickness);
    
    if (request->core.height == 0) pb->core.height =  pb->button.label_height + 
          2 * (pb->button.internal_height + pb->primitive.highlight_thickness);
     
    
    Resize(new);

}



/*************************************<->*************************************
 *
 *  ClassInitialize
 *
 *   Description:
 *   -----------
 *    Set fields in primitive class part of our class record so that
 *    the traversal code can invoke our button select procedures.
 *
 *************************************<->***********************************/
static void ClassInitialize()
{
   XwpushButtonClassRec.primitive_class.select_proc = (XtWidgetProc) Select;
   XwpushButtonClassRec.primitive_class.release_proc = (XtWidgetProc) Unselect;
   XwpushButtonClassRec.primitive_class.toggle_proc = (XtWidgetProc) Toggle;
}


/*************************************<->*************************************
 *
 *  Redisplay (w, event)
 *
 *   Description:
 *   -----------
 *     Cause the widget, identified by w, to be redisplayed.
 *
 *
 *   Inputs:
 *   ------
 *     w = widget to be redisplayed;
 *     event = event structure identifying need for redisplay on this
 *             widget.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDrawString()
 *************************************<->***********************************/

static void Redisplay(w, event)
    Widget w;
    XEvent *event;
{
    RedrawButtonFace(w, event, TRUE);
 }

static void RedrawButtonFace(w, event, all)
    Widget w;
    XEvent *event;
    Boolean all;
{
   register XwPushButtonWidget pb = (XwPushButtonWidget) w;
   int x, y, width, height, num_chars, num_pixels_needed, available_space;
   XFontStruct	*fs = pb->button.font;


  /* COMPUTE SPACE AVAILABLE FOR DRAWING LABEL */
   available_space = pb->core.width - 2*(pb->button.internal_width +
				pb->primitive.highlight_thickness);


   num_chars = pb->button.label_len;
   num_pixels_needed = pb->button.label_width;


  /* DECREMENT CHARACTERS TO DISPLAY UNTIL WE HAVE STRING WHICH WILL FIT */
   while ((available_space < num_pixels_needed) && (num_chars > 0))
     {
       num_pixels_needed=XTextWidth(fs, pb->button.label, --num_chars);
     }


 /* COMPUTE & DRAW PUSHBUTTON */
   x= pb->primitive.highlight_thickness;
   y=x;
   width = pb->core.width - 2*x;
   height = pb->core.height - 2*y;


   XFillRectangle (XtDisplay(w), XtWindow (w),
     ((pb->button.set && pb->core.sensitive && pb->core.ancestor_sensitive) ? 
	 ((XwButtonWidget)w)->button.normal_GC :
     ((XwButtonWidget)w)->button.inverse_GC),  x, y, width, height);

 /* COMPUTE x LOCATION FOR STRING & DRAW STRING */

   x = (pb->core.width + 1 - num_pixels_needed) / 2;
   if (num_chars > 0)
    {
      XDrawString(XtDisplay(w), XtWindow(w),
		  (!(pb->core.sensitive && pb->core.ancestor_sensitive) ?
	            pb->button.sensitive_GC :
		   ((pb->button.set) ? pb->button.inverse_GC
		                     : pb->button.normal_GC)),
	             x, pb->button.label_y,
		      pb->button.label, num_chars);

       }

    if (pb->primitive.highlighted)
      {
	 _XwHighlightBorder(w);
	 pb->primitive.display_highlighted = TRUE;
      }
    else
      if (pb->primitive.display_highlighted)
	 {
	    _XwUnhighlightBorder(w);
	    pb->primitive.display_highlighted = FALSE;
	 }
 }



/*************************************<->*************************************
 *
 *  SetValues(current, request, new, last)
 *
 *   Description:
 *   -----------
 *     This is the set values procedure for the pushbutton class.  It is
 *     called last (the set values rtnes for its superclasses are called
 *     first).
 *
 *
 *   Inputs:
 *   ------
 *    current = original widget;
 *    request = copy of current (?);
 *    new = copy of request which reflects changes made to it by
 *          set values procedures of its superclasses;
 *    last = TRUE if this is the last set values procedure to be called.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *
 *************************************<->***********************************/

static Boolean SetValues(current, request, new, last)
    Widget current, request, new;
    Boolean last;
{
    XtWidgetGeometry	reqGeo;
    XwPushButtonWidget curpb = (XwPushButtonWidget) current;
    XwPushButtonWidget newpb = (XwPushButtonWidget) new;
    Boolean  flag = FALSE;    /* our return value */
    
    
    /**********************************************************************
     * Calculate the window size:  The assumption here is that if
     * the width and height are the same in the new and current instance
     * record that those fields were not changed with set values.  Therefore
     * its okay to recompute the necessary width and height.  However, if
     * the new and current do have different width/heights then leave them
     * alone because that's what the user wants.
     *********************************************************************/
    if (curpb->core.width == newpb->core.width)
     {
	newpb->core.width =
	    newpb->button.label_width + 2*(newpb->button.internal_width +
     		    newpb->primitive.highlight_thickness);
	flag = TRUE;
     }

    if (curpb->core.height == newpb->core.height)
     {
	newpb->core.height =
	    newpb->button.label_height + 2*(newpb->button.internal_height +
     		    newpb->primitive.highlight_thickness);
	flag = TRUE;
     }

   return(flag);
}




/*************************************<->*************************************
 *
 *  Resize(w)
 *
 *   Description:
 *   -----------
 *     Recompute location of button text
 *
 *   Inputs:
 *   ------
 *     w  = widget to be resized.
 * 
 *
 *************************************<->***********************************/


static void Resize(w)
    Widget w;
{
    XwPushButtonWidget pb = (XwPushButtonWidget) w;

    pb->button.label_x = (pb->core.width + 1 - pb->button.label_width) / 2;

    pb->button.label_y =
       (pb->core.height - pb->button.label_height) / 2
	+ pb->button.font->max_bounds.ascent;
}


