.TH XPERFMON 1 "19 January 1988" "X Version 11"
.SH NAME
xperfmon - X window system performance monitor
.SH SYNOPSIS
.B xperfmon
[option ...]
.SH DESCRIPTION
.I xperfmon
continuously displays several system statistics as a set of parallel
line graphs.  The name of the host is displayed in the upper left hand
corner.  The information is scaled so that it fills up the entire window.
While 
.I xperfmon
is running, it is possible to perform certain tasks by pressing keys over
the window:
.PP
.B Q/q: Quit
.br
.B R: 
Reset graph and timer
.br
.B s: 
Decrease update interval (slower) by a small amount
.br
.B S: 
Decrease update interval (slower) by a large amount
.br
.B f: 
Increase update interval (faster) by a small amount
.br
.B F: 
Increase update interval (faster) by a large amount
.br
.B ?: 
Help
.PP
.I xperfmon
understands the following options:
.PP
.TP 8
.B =\fIgeometry\fP
The xperfmon window is created with the specified
size and location
determined
by the supplied geometry specification.
See \fIX(1)\fP for a full explanation.
.PP
.TP 8
.B host:display
Run \fIxperfmon\fP on a specified display.  Default is unix:0.
.PP
.TP 8
.B \-rv | -reverse
Reverses black and white.
.PP
.TP 8
.B \-fw | -forward
Forces colors to be as specified (rather than reversed).
.PP
.TP 8
.B \-bw | -border \fIpixels\fP
Specify the border width in pixels.  Default is 3.
.PP
.TP 8
.B \-fn | -font \fIfontname\fP
The hostname and labels will be displayed in the specified font.
The default is
\fI6X10\fP.
.PP
.TP 8
.B \-u | -update \fIseconds\fP
Specify the update interval for the graph in seconds.  Default is 1.
.PP
.TP 8
.B \-st | -stepsize \fIpixels\fP
Specify the stepsize of the graph.  Default is one pixel.
.PP
.TP 8
.B \-n | -not \fIstat stat stat...\fP
A list of statistics not to be displayed.  Specifying -n or -not on the 
commandline supercedes any statistics specified up to that time.  All 
subsequent
words on the command line that are statistics will be omited from the 
display.  See immediately below.
.PP
.TP 8
.B 
.I stat stat stat...
A list of statistics to be displayed.  If none are listed, all are displayed.
If any are listed, only those listed are displayed
unless -n or -not has been specified.  Possible statistics are
.B user, 
.B system, 
.B idle, 
.B free, 
.B disk, 
.B interrupts, 
.B input, 
.B output, 
and 
.B collision.
These refer to 
.B User CPU percentage, 
.B System CPU percentage, 
.B Free memory,
.B Disk transfers,
.B Interrupts,
.B Input packets,
.B Output packets,
and
.B Collision packets.
.SH ENVIRONMENT
DISPLAY - to get the default host and display number.
.SH SEE ALSO
X(1), uwm(1), X(8C), mem(4), select(2)
.SH AUTHORS
The X11 version of 
.I xperfmon
was written by Emanuel Jay Berkenbilt, Project Athena on
1/21/1988.  There is no record of previous authors.
.SH BUGS
.I xperfmon
requires the ability to open and read 
.I /dev/kmem. 
On most systems, this requires
the suid bit set with root ownership or the sgid bit set and membership in 
the same group as 
.I /dev/kmem. 
.PP
Occasionally, the 
.I xperfon 
window will not be updated correctly if its size
changed too many times in rapid succession.  This is a consequence of the 
way that exposure events are handled.
