/*
 * xmessage - an X message display program.
 *
 * $Header: widgets.c,v 1.1 88/10/20 14:44:49 kit Locked $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:    Chris D. Peterson, MIT Project Athena
 * Created:   October 15, 1988
 */

#if ( !defined(lint) && !defined(SABER))
  static char rcs_version[] = "$Athena: widgets.c,v 1.1 88/10/20 14:44:49 kit Locked $";
#endif


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xmu.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Command.h>
#include <X11/AsciiText.h>
#include <X11/Form.h>

#include "globals.h"
#include "xmessage.h"

static Widget CreateText(), MakeButton();
static void ButtonCallback();
char *GetMessageFromFile(), *GetMessageFromLine();

/*	Function Name: CreateWidgets.
 *	Description: Creates all the widgets necessary for xmessage.
 *	Arguments: top - The toplevel widget that is the parent of all these
 *                       widget children.
 *	Returns: none.
 */

void
CreateWidgets(top)
Widget top;
{
  Widget form, text;		/* Form and text widgets. */
  Widget prev_button = NULL;	/* The previous button. (for layout). */
  ButtonEntry * local;		/* local copy of button list. */
  
  form = XtCreateManagedWidget("form", formWidgetClass, top, NULL, 0);
  
  text = CreateText(form);

  for ( local = button_list ; local != NULL ; local= local->next )
    prev_button = MakeButton(local, text, prev_button);
}
  
/*	Function Name: CreateText
 *	Description: Creates the text widget.
 *	Arguments: form - the form widget to put it into.
 *	Returns: text - the text widget.
 */

static Widget
CreateText(form)
Widget form;
{
  Widget text;			/* The text widget. */
  Arg arglist[10];		/* The generic arglist. */
  Cardinal num_args;		/* Number of elements in the argslist. */
  char * string;		/* The string. */
  
  if ( use_stdin ) 
    string = GetMessageFromFile();
  else
    string = GetMessageFromLine();

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtop, XtChainTop);
  num_args++; 
  XtSetArg(arglist[num_args], XtNbottom, XtChainBottom);
  num_args++; 
  XtSetArg(arglist[num_args], XtNleft, XtChainLeft);
  num_args++; 
  XtSetArg(arglist[num_args], XtNright, XtChainRight);
  num_args++; 
  XtSetArg(arglist[num_args], XtNstring, string);
  num_args++; 
  XtSetArg(arglist[num_args], XtNlength, strlen(string));
  num_args++; 
  if (scroll) 
    XtSetArg(arglist[num_args], XtNtextOptions, scrollVertical | wordBreak);
  else
    XtSetArg(arglist[num_args], XtNtextOptions, wordBreak);
  num_args++; 
  XtSetArg(arglist[num_args], XtNwidth, 800);
  num_args++; 
  
  text = XtCreateManagedWidget("text", asciiStringWidgetClass,
			       form, arglist, num_args);
  return(text);
}

/*	Function Name: MakeButton
 *	Description: Creates the buttons for this widget.
 *	Arguments: bstruct - the structure for this button.
 *                 text    - the text widget for layout purposes.
 *                 prev_button - again for layou purposes.
 *	Returns: the widget pointer for this button.
 */

static Widget
MakeButton(bstruct, text, prev_button)
ButtonEntry * bstruct;
Widget text, prev_button;
{
  Widget ret_button;		/* The button widget to return. */
  Arg arglist[10];		/* The generic arglist. */
  Cardinal num_args;		/* Number of elements in the argslit. */

  num_args = 0;
  XtSetArg(arglist[num_args], XtNleft, XtChainLeft);
  num_args++; 
  XtSetArg(arglist[num_args], XtNright, XtChainLeft);
  num_args++; 
  XtSetArg(arglist[num_args], XtNtop, XtChainBottom);
  num_args++; 
  XtSetArg(arglist[num_args], XtNbottom, XtChainBottom);
  num_args++; 
  XtSetArg(arglist[num_args], XtNfromHoriz, prev_button);
  num_args++; 
  XtSetArg(arglist[num_args], XtNfromVert, text);
  num_args++;
  XtSetArg(arglist[num_args], XtNvertDistance, 5);
  num_args++;

  ret_button = XtCreateManagedWidget(bstruct->name, commandWidgetClass,
				     XtParent(text), arglist, num_args);
  XtAddCallback(ret_button, XtNcallback, ButtonCallback, (caddr_t) bstruct);

  return(ret_button);
}

/*	Function Name: ButtonCallback
 *	Description: This is the callback function for the command
 *                   buttons that are created for xmessage.
 *	Arguments: w - the widget we are calling back from. 
 *                 pointer - a pointer to button structure associated 
 *                           with this widget.
 *                 junk - (call data) not used.
 *	Returns: exits.
 */

/* ARGSUSED */

static void
ButtonCallback(w,pointer,junk)
Widget w;
caddr_t pointer,junk;
{
  ButtonEntry * b_entry = (ButtonEntry *) pointer;
  Arg arglist[10];		/* an argument list. */
  Cardinal num_args;		/* the number of arguents in the arglist. */
  char * label;

  if (print_label) {
    num_args = 0;
    XtSetArg(arglist[num_args], XtNlabel, &label);
    num_args++; 
    XtGetValues(w, arglist, num_args);
    printf("%s\n", label);
  }
    
/*
 * If there is only one button then exit with status == 0, otherwise
 * exit with status == (number of the button pressed).
 */

  if ( (b_entry->number == 1) && (b_entry->next == NULL) )
    exit(0);
  else
    exit(b_entry->number);
}

/* 
 * These two functions don't really belong here, but I don't see the need
 * for creating a file just for these two functions, so here they are.
 */

/*	Function Name: GetMessageFromFile
 *	Description: Reads the message from standard input and 
 *                   stores it into a string.
 *	Arguments: none.
 *	Returns: the string that contains all the information from the file.
 */

/*
 * For ease of coding and efficiency of memory usage this will not work
 * well for large files piped to stdin (it will be sloooooow.) but since
 * messages are meant to be short this is not much of a problem.
 */

char *
GetMessageFromFile()
{
  char * ret_string, temp_str[10 * BUFSIZ]; /* is 10,240 big enough?? */
  Boolean first = TRUE;		/* Is this the first line of input? */
  int len;			/* Length of ret_string. */

  while ( gets(temp_str) != NULL) {
    if (first) {
      len = strlen(temp_str) + 1; /* leaves space for the null. */
      if ( (ret_string = malloc(len)) == NULL )
	PrintError(FALSE, "Could not allocate memory in GetMessageFromFile");
      (void) strcpy(ret_string, temp_str);
      first = FALSE;
    }
    else {
      len += strlen(temp_str) + 1; /* leaves space for each <CR>. */
      if ( (ret_string = realloc(ret_string, len + 1)) == NULL )
	PrintError(FALSE, "Could not allocate memory in GetMessageFromFile");
      (void) strcat(ret_string, "\n");
      (void) strcat(ret_string, temp_str);
    }
  }
  return(ret_string);
}
  
/*	Function Name: GetMessageFromLine
 *	Description: This function turns the message into a string.
 *	Arguments: none.
 *	Returns: The string that is the message.
 */

char * 
GetMessageFromLine()
{
  int count;		   /* The total number of characters in the message. */
  int i;		   /* counter. */
  char * ret_string;
  
  for ( count = 0, i = 0 ; i < nmessage ; i++ ) 
    count += strlen(message[i]) + 1;

  if ( (ret_string = malloc( count )) == NULL)
    PrintError(FALSE, "Could not allocate memory in GetMessageFromFile");
  
  ret_string[0] = '\0';

  for ( i = 0 ; i < nmessage ; i++ ) {
    if (i != 0) 
      strcat(ret_string, " ");
    strcat(ret_string, message[i]);
  }

  return( ret_string );
}
