/*
 * xmessage - an X message display program.
 *
 * $Header: main.c,v 1.1 88/10/20 14:44:47 kit Locked $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:    Chris D. Peterson, MIT Project Athena
 * Created:   October 13, 1988
 */

#if ( !defined(lint) && !defined(SABER))
  static char rcs_version[] = "$Athena: main.c,v 1.1 88/10/20 14:44:47 kit Locked $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xmu.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "globals.h"
#include "xmessage.h"

void CreateWidgets();

/*	Function Name: main
 *	Description: main driver for xmessage.
 *	Arguments: argc, argv - standard arguments.
 *	Returns: none. - exits.
 */

void
main(argc, argv)
int argc;
char ** argv;
{
  Widget top, InitWorld();

  program_name = argv[0];	/* Store name of xmessage program. */

  top = InitWorld(&argc, argv);
  CreateWidgets(top);

  XtRealizeWidget(top);
  XtMainLoop();
}

/*	Function Name: PrintError
 *	Description: Prints an error message to the user.
 *	Arguments: window - whether or not to open a window to put error
 *                          message into.
 *                 message - the error message.
 *	Returns: exits.
 */

/*
 * It would be nice if all error messages put up a window on the screen
 * but there are certain classes of messages where this will not work,
 * for instance if you are out of memory.
 */

void 
PrintError(window, message)
Boolean window;
char * message;
{
  if (window) {			/* put this in a window. */
    switch (fork()) {
    case 0:
      execlp(program_name, program_name, "-name", "xmessage_error", 
	     "-nsb", "-message", "Xmessage Error:", message, 
	     "\nXmessage exiting.", NULL);
      PrintError(FALSE, "Could not exec new xmessage process.");
      break;
    case -1:
      PrintError(FALSE, "Could not fork off new xmessage process.");
      break;
    default:
      break;
    }
  }
  else				/* Print to stderr instead. */
    fprintf(stderr, "Xmessage Error: %s\n", message);
    
  exit(42);
}

/*	Function Name: PrintWarning
 *	Description: Prints a warning message to the user.
 *	Arguments: message - message to print to the user.
 *	Returns: none.
 */

void 
PrintWarning(message)
char * message;
{
  switch (fork()) {
  case 0:
    execlp(program_name, program_name, "-nsb", "-name", "xmessage_error",
	   "-message", "Xmessage Warning:", message, NULL);
    PrintError(FALSE, "Could not exec new xmessage process.");
    break;
  case -1:
    PrintError(FALSE, "Could not fork off new xmessage process.");
    break;
  default:
    break;
  }
}


