/*
 * xmessage - an X message display program.
 *
 * $Header: init.c,v 1.1 88/10/20 14:44:45 kit Locked $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:    Chris D. Peterson, MIT Project Athena
 * Created:   October 13, 1988
 */

#if ( !defined(lint) && !defined(SABER))
  static char rcs_version[] = "$Athena: main.c,v 1.3 88/09/14 16:38:35 kit Locked $";
#endif

#include <stdio.h>
#include <sys/ioctl.h>
#include <X11/Xlib.h>
#include <X11/Xmu.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "globals.h"
#include "xmessage.h"

static XtResource resources[] = {
  {"printLabel", "PrintLabel", XtRBoolean, sizeof(Boolean),
     (Cardinal) &(print_label), XtRString, "False"},
  {"scrollText", "ScrollText", XtRBoolean, sizeof(Boolean),
     (Cardinal) &(scroll), XtRString, "True"},
};

static XrmOptionDescRec options[] = {
  {"-printlabel", "printLabel", XrmoptionNoArg, (caddr_t) "True"},
  {"-noscroll", "scrollText", XrmoptionNoArg, (caddr_t) "FALSE"},
  {"-nsb", "scrollText", XrmoptionNoArg, (caddr_t) "FALSE"},
};

static void PrintArgs(), AddButton(), CheckGlobals();

/*	Function Name: main
 *	Description: This is the main driver for Xman.
 *	Arguments: argc, argv - the command line arguments.
 *	Returns: return, what return.
 */

Widget
InitWorld(argc,argv)
char ** argv;
int *argc;
{
  static void ProcessLocalArgs();
  Widget top;

  top= XtInitialize(argv[0],"XMessage", options, XtNumber(options),
		    (unsigned int*) argc, argv);

  ProcessLocalArgs(argc, argv);

  XtGetApplicationResources( (Widget) top, (caddr_t) NULL, resources,
			    XtNumber(resources), NULL, (Cardinal) 0);

  CheckGlobals();

  return(top);
}

/*	Function Name: ProcessLocalArgs
 *	Description: Process the -message and -buttons arguments.
 *	Arguments: none.
 *	Returns: none - may exit if args are bad.
 */

static void
ProcessLocalArgs(argc, argv)
int *argc;
char ** argv;
{
  int i;
  Boolean buttons = FALSE;
  struct sgttyb garbage;

  for (i = 1; i < *argc; i++) {
    if ( (argv[i][0] == '-') ) {
      buttons = FALSE;
      switch (argv[i][1]) {	/* This is the message. */
      case 'm':
	if (argv[i+1][0] == '-') /* means use stdin. */
	  return;		/* Use stdin, same as default behavior. */
	else {
	  message = argv + i + 1; /* Set gloabal variables about message. */
	  nmessage = *argc - (i + 1);
	  use_stdin = FALSE;	/* This is a message, not a file. */
	  return;
	}			
	/* No break needed, and some debuggers complain about it. */
      case 'b':			/* This is the button list. */
	buttons = TRUE;
	break;
      default:
	PrintArgs(argv[i]);
	break;
      }
    }
    else if (buttons == TRUE)
      AddButton(argv[i]);
    else
      PrintArgs(argv[i]);
  }
  
/*
 * If we are using stdin, make sure that it is not connected to the tty, 
 * this is not a useful state of affairs.
 */
  
  if (ioctl( fileno(stdin), TIOCGETP, &garbage) == 0) {
    char warn_buf[BUFSIZ];
    sprintf(warn_buf, "%s %s %s", "Standard Input (stdin) may not come from",
	    "a tty.\n               It must come from a pipe, file or ", 
	    "other device.");
    PrintError(FALSE, warn_buf);
  }
  
/*
 * If we are using stdin, make sure that it is not connected to the tty, 
 * this is not a useful state of affairs.
 */
  
  if (ioctl( fileno(stdin), TIOCGETP, &garbage) == 0) {
    char warn_buf[BUFSIZ];
    sprintf(warn_buf, "%s %s %s", "Standard Input (stdin) may not come from",
	    "a tty.\n               It must come from a pipe, file or ", 
	    "other device.");
    PrintError(FALSE, warn_buf);
  }
}

/*	Function Name: PrintArgs
 *	Description: prints out the useage message.
 *	Arguments: arg - The bad argument.  (I keep thinking 
 *                                           this will be useful...)
 *	Returns: exits...
 */

/* ARGSUSED */

static void
PrintArgs(arg)
char * arg;
{
  char arg_string[BUFSIZ];

  sprintf(arg_string, "%s%s%s%s%s%s%s%s%s%s",
	  "This is what the xmessage window will look like.  Clicking on ",
	  "any of the buttons at the bottom of this window will cause the ",
	  "program to exit.\n\nUsage: xmessage <args> -m message.\n\n",
	  "All standard XToolkit args which allow setting the ",
	  "display, changing the colors and sizes of all sub-windows, ",
	  "etc.\n\nThe following additional arguments are recognised:\n\n",
	  "-printlabel - whether or not to print the button label on exit.\n",
	  "-noscroll (-nsb) - do not put a scroll bar on the text window.\n",
	  "-buttons (-b) button ... - The list of buttons.\n",
	  "-message (-m) message    - The message to display\n");
	  
  fprintf(stderr, arg_string);
  PrintError(TRUE, arg_string);
}

/*	Function Name: AddButton
 *	Description: Adds a new button to the list of buttons.
 *	Arguments: name -  name of button to add.
 *	Returns: none.
 */

static void
AddButton(name)
char * name;
{
  ButtonEntry *entry, *local;

  if ( (entry = (ButtonEntry *) malloc(sizeof(ButtonEntry))) == NULL)
    PrintError(FALSE, "Could not Allocate Memory in AddButton.");

  local = button_list;

  if (local == NULL) {		/* If this is the first then use it. */
    button_list = entry;
    entry->number = 1;
  }
  else {			/* Else add it to the current list. */
    while (local->next != NULL)	/* find end of current list */
      local = local->next;
    
    local->next = entry;
    entry->number = local->number + 1;
  }

  entry->next = NULL;		/* fill it full of good info */
  entry->name = name;
}

/*	Function Name: CheckGlobals
 *	Description: Check to make sure that all the globals variables
 *                   that did not get set, have the proper defaults.
 *	Arguments: none - were working with globals here Slim.
 *	Returns: none.
 */

static void
CheckGlobals()
{
  if (button_list == NULL)
    AddButton("okay");

  if ( (message != NULL) && (use_stdin == TRUE) )
    PrintError(TRUE, 
	       "Confusion in arguments, cannot have message and stdin both.");
}  
