/*-
 * XCreDynCmap.c - X11 library routine to create dynamic colormaps.
 *
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 *
 * Author: Patrick J. Naughton
 * naughton@wind.sun.com
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 */

#include <sys/types.h>
#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

Status
XCreateDynamicColormap(dsp, screen, cmap, red, green, blue)
Display *dsp;
int screen;
Colormap *cmap;
u_char *red, *green, *blue;
{
XVisualInfo vinfo;
XColor xcolors[256];
int pixels[256];
int i, ncolors, planes;
unsigned long pmasks;
Status allocReturn;

    planes = DisplayPlanes(dsp, screen);
    if (XMatchVisualInfo(dsp, screen, planes, PseudoColor, &vinfo)
     || XMatchVisualInfo(dsp, screen, planes, GrayScale, &vinfo)
     || XMatchVisualInfo(dsp, screen, planes, DirectColor, &vinfo)) {
	*cmap = XCreateColormap(dsp, RootWindow(dsp, screen),
	    vinfo.visual, AllocNone);
	ncolors = vinfo.colormap_size;
	allocReturn = XAllocColorCells(dsp, *cmap,
	    False, &pmasks, 0,
	    pixels, ncolors);

/*	This should return Success, but it doesn't... Xlib bug?
	(I'll ignore the return value for now...)

	if (allocReturn != Success)
	    return(allocReturn);

*/
	for (i = 0; i < ncolors; i++) {
	    xcolors[i].pixel = pixels[i];
	    xcolors[i].red = *red++ << 8;
	    xcolors[i].green = *green++ << 8;
	    xcolors[i].blue = *blue++ << 8;
	    xcolors[i].flags = DoRed | DoGreen | DoBlue;
	}
        XStoreColors(dsp, *cmap, xcolors, ncolors);
	return(Success);
    }
    else 
	return(BadMatch);
}
