#!/bin/sh
#
# print a dvi file on the imagen
#
#	The 'bin' symbol will be overwritten with the real name by the
#	install
#
IMAGEN=BIN/imagen1
IPR=BIN/ipr
flags=
res=300
iprflags=
cflag=-c
sflag=no
pflag="-p"
# eat arguments

while [ $# -gt 0 ]
do
	case "$1" in
	-c)
		cflag=;;
	-d|-m)
		flags="$flags $1 $2"
		shift;;
	-r)
		res="$2"
		shift;;
	-P*|-A*)
		iprflags="$iprflags $1";;
	-I)
		iprflags="$iprflags $2"
		shift;;
	-s)
		sflag="yes"
		;;
	-p)
		pflag="-p"
		;;
	+p)
		pflag=""
		;;
	-X|-Y)
		flags="$flags $1 $2"
		shift;
		;;
	-*)
		flags="$flags $1";;
	*)
		break
	esac
	shift
done

flags="$flags -r $res $pflag"

if [ $# != 1 ]; then
	echo "Usage: $0 [-c] [-l] [-s] [-r res] [-I ipr-arg] [-Pprinter] [-Aaccount] [-m mag] [-d drift] filename" 1>&2
	exit 1
fi

dvifile=$1

if [ ! -r $dvifile ]; then
	dvifile=$1.dvi
	if [ ! -r $dvifile ]; then
		echo "$0: cannot find $1 or $1.dvi" 1>&2
		exit 1
	fi
fi

if [ "$cflag" = -c ]; then
	trap 'rm -f /tmp/iptex$$' 0 1 2 3 15
	if $IMAGEN  $flags $dvifile > /tmp/iptex$$; then
	    if [ "$sflag" = yes ] ; then
	        cat /tmp/iptex$$
	    else
		$IPR -D'jobheader on' $iprflags /tmp/iptex$$
	    fi
	else
		echo $0': output not spooled (use -c to force)' 1>&2
	fi
else
	$IMAGEN $flags $dvifile | $IPR -D'jobheader on' $iprflags
fi
