#! /bin/sh
#
# unmakesubdir - make the TeX fonts reside in a flat style system
#
# usage:
#	cd /usr/lib/tex/fonts
#	sh unmakesubdir.sh

if [ ! -f SUBDIR ]; then
	echo "$0: SUBDIR file already gone.
Are you sure you need to do this?
(If so, create a SUBDIR file and try again.)" 1>&2
	exit 1
fi

rm SUBDIR

for dir in *; do
	if [ -d $dir ]; then
		mv -i $dir/*.*pxl .
	fi
done
