BEGIN {
	printf("new graph\n")
	FS = " "
	x=1
# x=0 corresponds to using the index column as the x axis
# index column is never used as y axis, even if x is not 0
	points = 0
	rows = 0
	labelexists = 0
	excludeexists = 0
	typeexists = 0
	symbolexists = 0
	grayexists = 0
	fontexists = 0
	interpolationexists = 0
}
/^[F][S]/ {
FS = $2
points = 1
}
/^[x]/ {
x = $2
points = 1
}

/^[0123456789]|^[-\+\.]/ {
for (i=1; i<=NF; i++) y[(rows * NF) + (i-1)] = $i 
rows++
points = 1
cols = NF
}

{
if (!points) 
{
	if (($1 == "label")||($1 == "Label")||($1 == "LABEL"))
	{
		labelexists = 1
		for (i=1; i<=NF; i++) label[i-1] = $i 
	}
	else if (($1 == "exclude")||($1 == "Exclude")||($1 == "EXCLUDE"))
	{
		excludeexists = 1
		for (i=1; i<=NF; i++) exclude[i-1] = $i 
	}
	else if (($1 == "type")||($1 == "Type")||($1 == "TYPE"))
	{
		typeexists = 1
		for (i=1; i<=NF; i++) type[i-1] = $i 
	}
	else if (($1 == "symbol")||($1 == "Symbol")||($1 == "SYMBOL"))
	{
		symbolexists = 1
		for (i=1; i<=NF; i++) symbol[i-1] = $i
	}
	else if (($1 == "gray")||($1 == "Gray")||($1 == "GRAY"))
	{
		grayexists = 1
		for (i=1; i<=NF; i++) gray[i-1] = $i 
	}
	else if (($1 == "font")||($1 == "Font")||($1 == "FONT"))
	{
		fontexists = 1
		for (i=1; i<=NF; i++) font[i-1] = $i 
	}
	else if (($1 == "interpolation")||($1 == "Interpolation")||($1 == "INTERPOLATION"))
	{
		interpolationexists = 1
		for (i=1; i<=NF; i++) interpolation[i-1] = $i
	}
	else print $0
}
points = 0
}

END {
for (i=1; i<cols; i++) 
{
    if (i != x)
    {
	printf("new curve\n")
	if (labelexists) printf("curve label %s\n", label[i])
	if (excludeexists) printf("%s curve\n", exclude[i])
	if (typeexists) printf("curve type %s\n", type[i])
	if (symbolexists) printf("curve symbol %s\n", symbol[i])
	if (grayexists) printf("curve gray %s\n", gray[i])
	if (fontexists) printf("curve font %s\n", font[i])
	if (interpolationexists) 
	{
		printf("curve interpolation %s\n", interpolation[i])
	}
	printf("new points\n")
	for (j=0; j<rows; j++)
	{
		printf("%f , %f\n",y[j*cols+x], y[j*cols+i])
	}
	printf("\n")
   }
}
}
