/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

/* 
the only difference between ploti.c and plotx.c is that x(), sendx(),
and plotx.h are interchanged with i(), sendi(), and ploti.h.
*/
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"
#include "plotx.h"
#define NULL 0
#define COMPR 0.8
#define MULBLOW 0.5
#define MAXVERTEX 20
#define NCOLORS 14

static int  width = 1;
static int  height = 1;
static int  pixel = BlackPixel;
static int  func = GXcopy;
static int ColorIndex = 0;
Vertex v[2];
Vertex vf[5];
private boolean FirstFill = FALSE;
private char dashmark[] = "-";

/*text*/
static char Dash[] = "-";
static int len = 1;
static char DefFont[] = "6x13p";
static FontInfo *fontinfo;
static int CurStrWidth = 0;
    
static char Pxh3[] =  "6x10";
static char Pxh4[] =  "6x10";
static char Pxh5[] =  "6x10";
static char Pxh6[] =  "6x10";
static char Pxh7[] =  "6x10";
static char Pxh8[] =  "6x10";
static char Pxh9[] =  "6x10";
static char Pxh10[] =  "6x10";
static char Pxh11[] =  "helv12";
static char Pxh12[] =  "helv12";
static char Pxh13[] =  "helv12";
static char Pxh14[] =  "helv12";
static char Pxh15[] =  "helv12";
static char Pxh16[] =  "helv12";
static char Pxh17[] =  "helv12";
static char Pxh18[] =  "helv12";
static char Pxh19[] =  "helv12";
static char Pxh20[] =  "helv12";
static char Pxh21[] =  "helv12";
static char Pxh22[] =  "helv12";
static char Pxh23[] =  "helv12";
static char Pxh24[] =  "helv12";
static char Pxh25[] =  "helv12";
static char Pxh26[] =  "helv12";
static char Pxh27[] =  "helv12";
static char Pxh28[] =  "helv12";
static char Pxh29[] =  "helv12";
static char Pxh30[] =  "helv12";

static char Pxhb3[] =  "helv10b";
static char Pxhb4[] =  "helv10b";
static char Pxhb5[] =  "helv10b";
static char Pxhb6[] =  "helv10b";
static char Pxhb7[] =  "helv10b";
static char Pxhb8[] =  "helv10b";
static char Pxhb9[] =  "helv10b";
static char Pxhb10[] =  "helv10b";
static char Pxhb11[] =  "helv12b";
static char Pxhb12[] =  "helv12b";
static char Pxhb13[] =  "helv12b";
static char Pxhb14[] =  "helv12b";
static char Pxhb15[] =  "helv12b";
static char Pxhb16[] =  "helv12b";
static char Pxhb17[] =  "helv12b";
static char Pxhb18[] =  "helv12b";
static char Pxhb19[] =  "helv12b";
static char Pxhb20[] =  "helv12b";
static char Pxhb21[] =  "helv12b";
static char Pxhb22[] =  "helv12b";
static char Pxhb23[] =  "helv12b";
static char Pxhb24[] =  "helv12b";
static char Pxhb25[] =  "helv12b";
static char Pxhb26[] =  "helv12b";
static char Pxhb27[] =  "helv12b";
static char Pxhb28[] =  "helv12b";
static char Pxhb29[] =  "helv12b";
static char Pxhb30[] =  "helv12b";

static char Pxhi3[] =  "6x10";
static char Pxhi4[] =  "6x10";
static char Pxhi5[] =  "6x10";
static char Pxhi6[] =  "6x10";
static char Pxhi7[] =  "6x10";
static char Pxhi8[] =  "6x10";
static char Pxhi9[] =  "6x10";
static char Pxhi10[] =  "6x10";
static char Pxhi11[] =  "helv12i";
static char Pxhi12[] =  "helv12i";
static char Pxhi13[] =  "helv12i";
static char Pxhi14[] =  "helv12i";
static char Pxhi15[] =  "helv12i";
static char Pxhi16[] =  "helv12i";
static char Pxhi17[] =  "helv12i";
static char Pxhi18[] =  "helv12i";
static char Pxhi19[] =  "helv12i";
static char Pxhi20[] =  "helv12i";
static char Pxhi21[] =  "helv12i";
static char Pxhi22[] =  "helv12i";
static char Pxhi23[] =  "helv12i";
static char Pxhi24[] =  "helv12i";
static char Pxhi25[] =  "helv12i";
static char Pxhi26[] =  "helv12i";
static char Pxhi27[] =  "helv12i";
static char Pxhi28[] =  "helv12i";
static char Pxhi29[] =  "helv12i";
static char Pxhi30[] =  "helv12i";

static char Pxhbi3[] =  "helv10b";
static char Pxhbi4[] =  "helv10b";
static char Pxhbi5[] =  "helv10b";
static char Pxhbi6[] =  "helv10b";
static char Pxhbi7[] =  "helv10b";
static char Pxhbi8[] =  "helv10b";
static char Pxhbi9[] =  "helv10b";
static char Pxhbi10[] =  "helv10b";
static char Pxhbi11[] =  "helv12b";
static char Pxhbi12[] =  "helv12b";
static char Pxhbi13[] =  "helv12b";
static char Pxhbi14[] =  "helv12b";
static char Pxhbi15[] =  "helv12b";
static char Pxhbi16[] =  "helv12b";
static char Pxhbi17[] =  "helv12b";
static char Pxhbi18[] =  "helv12b";
static char Pxhbi19[] =  "helv12b";
static char Pxhbi20[] =  "helv12b";
static char Pxhbi21[] =  "helv12b";
static char Pxhbi22[] =  "helv12b";
static char Pxhbi23[] =  "helv12b";
static char Pxhbi24[] =  "helv12b";
static char Pxhbi25[] =  "helv12b";
static char Pxhbi26[] =  "helv12b";
static char Pxhbi27[] =  "helv12b";
static char Pxhbi28[] =  "helv12b";
static char Pxhbi29[] =  "helv12b";
static char Pxhbi30[] =  "helv12b";

static char Pxt3[] =  "timrom10";
static char Pxt4[] =  "timrom10";
static char Pxt5[] =  "timrom10";
static char Pxt6[] =  "timrom10";
static char Pxt7[] =  "timrom10";
static char Pxt8[] =  "timrom10";
static char Pxt9[] =  "timrom10";
static char Pxt10[] =  "timrom10";
static char Pxt11[] =  "timrom12";
static char Pxt12[] =  "timrom12";
static char Pxt13[] =  "timrom12";
static char Pxt14[] =  "timrom12";
static char Pxt15[] =  "timrom12";
static char Pxt16[] =  "timrom12";
static char Pxt17[] =  "timrom12";
static char Pxt18[] =  "timrom12";
static char Pxt19[] =  "timrom12";
static char Pxt20[] =  "timrom12";
static char Pxt21[] =  "timrom12";
static char Pxt22[] =  "timrom12";
static char Pxt23[] =  "timrom12";
static char Pxt24[] =  "timrom12";
static char Pxt25[] =  "timrom12";
static char Pxt26[] =  "timrom12";
static char Pxt27[] =  "timrom12";
static char Pxt28[] =  "timrom12";
static char Pxt29[] =  "timrom12";
static char Pxt30[] =  "timrom12";

static char Pxtb3[] =  "timrom10b";
static char Pxtb4[] =  "timrom10b";
static char Pxtb5[] =  "timrom10b";
static char Pxtb6[] =  "timrom10b";
static char Pxtb7[] =  "timrom10b";
static char Pxtb8[] =  "timrom10b";
static char Pxtb9[] =  "timrom10b";
static char Pxtb10[] =  "timrom10b";
static char Pxtb11[] =  "timrom12b";
static char Pxtb12[] =  "timrom12b";
static char Pxtb13[] =  "timrom12b";
static char Pxtb14[] =  "timrom12b";
static char Pxtb15[] =  "timrom12b";
static char Pxtb16[] =  "timrom12b";
static char Pxtb17[] =  "timrom12b";
static char Pxtb18[] =  "timrom12b";
static char Pxtb19[] =  "timrom12b";
static char Pxtb20[] =  "timrom12b";
static char Pxtb21[] =  "timrom12b";
static char Pxtb22[] =  "timrom12b";
static char Pxtb23[] =  "timrom12b";
static char Pxtb24[] =  "timrom12b";
static char Pxtb25[] =  "timrom12b";
static char Pxtb26[] =  "timrom12b";
static char Pxtb27[] =  "timrom12b";
static char Pxtb28[] =  "timrom12b";
static char Pxtb29[] =  "timrom12b";
static char Pxtb30[] =  "timrom12b";

static char Pxti3[] =  "timrom10i";
static char Pxti4[] =  "timrom10i";
static char Pxti5[] =  "timrom10i";
static char Pxti6[] =  "timrom10i";
static char Pxti7[] =  "timrom10i";
static char Pxti8[] =  "timrom10i";
static char Pxti9[] =  "timrom10i";
static char Pxti10[] =  "timrom10i";
static char Pxti11[] =  "timrom12i";
static char Pxti12[] =  "timrom12i";
static char Pxti13[] =  "timrom12i";
static char Pxti14[] =  "timrom12i";
static char Pxti15[] =  "timrom12i";
static char Pxti16[] =  "timrom12i";
static char Pxti17[] =  "timrom12i";
static char Pxti18[] =  "timrom12i";
static char Pxti19[] =  "timrom12i";
static char Pxti20[] =  "timrom12i";
static char Pxti21[] =  "timrom12i";
static char Pxti22[] =  "timrom12i";
static char Pxti23[] =  "timrom12i";
static char Pxti24[] =  "timrom12i";
static char Pxti25[] =  "timrom12i";
static char Pxti26[] =  "timrom12i";
static char Pxti27[] =  "timrom12i";
static char Pxti28[] =  "timrom12i";
static char Pxti29[] =  "timrom12i";
static char Pxti30[] =  "timrom12i";

static char Pxtbi3[] =  "timrom10b";
static char Pxtbi4[] =  "timrom10b";
static char Pxtbi5[] =  "timrom10b";
static char Pxtbi6[] =  "timrom10b";
static char Pxtbi7[] =  "timrom10b";
static char Pxtbi8[] =  "timrom10b";
static char Pxtbi9[] =  "timrom10b";
static char Pxtbi10[] =  "timrom10b";
static char Pxtbi11[] =  "timrom12b";
static char Pxtbi12[] =  "timrom12b";
static char Pxtbi13[] =  "timrom12b";
static char Pxtbi14[] =  "timrom12b";
static char Pxtbi15[] =  "timrom12b";
static char Pxtbi16[] =  "timrom12b";
static char Pxtbi17[] =  "timrom12b";
static char Pxtbi18[] =  "timrom12b";
static char Pxtbi19[] =  "timrom12b";
static char Pxtbi20[] =  "timrom12b";
static char Pxtbi21[] =  "timrom12b";
static char Pxtbi22[] =  "timrom12b";
static char Pxtbi23[] =  "timrom12b";
static char Pxtbi24[] =  "timrom12b";
static char Pxtbi25[] =  "timrom12b";
static char Pxtbi26[] =  "timrom12b";
static char Pxtbi27[] =  "timrom12b";
static char Pxtbi28[] =  "timrom12b";
static char Pxtbi29[] =  "timrom12b";
static char Pxtbi30[] =  "timrom12b";

static char Pgrk3[] =  "timrom10b";
static char Pgrk4[] =  "timrom10b";
static char Pgrk5[] =  "timrom10b";
static char Pgrk6[] =  "timrom10b";
static char Pgrk7[] =  "timrom10b";
static char Pgrk8[] =  "timrom10b";
static char Pgrk9[] =  "timrom10b";
static char Pgrk10[] =  "timrom10b";
static char Pgrk11[] =  "timrom12b";
static char Pgrk12[] =  "timrom12b";
static char Pgrk13[] =  "timrom12b";
static char Pgrk14[] =  "timrom12b";
static char Pgrk15[] =  "timrom12b";
static char Pgrk16[] =  "timrom12b";
static char Pgrk17[] =  "timrom12b";
static char Pgrk18[] =  "timrom12b";
static char Pgrk19[] =  "timrom12b";
static char Pgrk20[] =  "timrom12b";
static char Pgrk21[] =  "timrom12b";
static char Pgrk22[] =  "timrom12b";
static char Pgrk23[] =  "timrom12b";
static char Pgrk24[] =  "timrom12b";
static char Pgrk25[] =  "timrom12b";
static char Pgrk26[] =  "timrom12b";
static char Pgrk27[] =  "timrom12b";
static char Pgrk28[] =  "timrom12b";
static char Pgrk29[] =  "timrom12b";
static char Pgrk30[] =  "timrom12b";



public char *xhfont[] = {
Pxh3,Pxh4,Pxh5,Pxh6,Pxh7,Pxh8,Pxh9,Pxh10,Pxh11,Pxh12,Pxh13,Pxh14,
Pxh15,Pxh16,Pxh17,Pxh18,Pxh19,Pxh20,Pxh21,Pxh22,Pxh23,Pxh24,Pxh25,
Pxh26,Pxh27,Pxh28,Pxh29,Pxh30
};

public char *xhbfont[] = {
Pxhb3,Pxhb4,Pxhb5,Pxhb6,Pxhb7,Pxhb8,Pxhb9,Pxhb10,Pxhb11,Pxhb12,
Pxhb13,Pxhb14,Pxhb15,Pxhb16,Pxhb17,Pxhb18,Pxhb19,Pxhb20,Pxhb21,
Pxhb22,Pxhb23,Pxhb24,Pxhb25,Pxhb26,Pxhb27,Pxhb28,Pxhb29,Pxhb30
};

public char *xhifont[] = {
Pxhi3,Pxhi4,Pxhi5,Pxhi6,Pxhi7,Pxhi8,Pxhi9,Pxhi10,Pxhi11,Pxhi12,Pxhi13,Pxhi14,
Pxhi15,Pxhi16,Pxhi17,Pxhi18,Pxhi19,Pxhi20,Pxhi21,Pxhi22,Pxhi23,Pxhi24,Pxhi25,
Pxhi26,Pxhi27,Pxhi28,Pxhi29,Pxhi30
};

public char *xhbifont[] = {
Pxhbi3,Pxhbi4,Pxhbi5,Pxhbi6,Pxhbi7,Pxhbi8,Pxhbi9,Pxhbi10,Pxhbi11,Pxhbi12,
Pxhbi13,Pxhbi14,Pxhbi15,Pxhbi16,Pxhbi17,Pxhbi18,Pxhbi19,Pxhbi20,Pxhbi21,
Pxhbi22,Pxhbi23,Pxhbi24,Pxhbi25,Pxhbi26,Pxhbi27,Pxhbi28,Pxhbi29,Pxhbi30
};

public char *xtfont[] = {
Pxt3,Pxt4,Pxt5,Pxt6,Pxt7,Pxt8,Pxt9,Pxt10,Pxt11,Pxt12,Pxt13,Pxt14,
Pxt15,Pxt16,Pxt17,Pxt18,Pxt19,Pxt20,Pxt21,Pxt22,Pxt23,Pxt24,Pxt25,
Pxt26,Pxt27,Pxt28,Pxt29,Pxt30
};

public char *xtbfont[] = {
Pxtb3,Pxtb4,Pxtb5,Pxtb6,Pxtb7,Pxtb8,Pxtb9,Pxtb10,Pxtb11,Pxtb12,
Pxtb13,Pxtb14,Pxtb15,Pxtb16,Pxtb17,Pxtb18,Pxtb19,Pxtb20,Pxtb21,
Pxtb22,Pxtb23,Pxtb24,Pxtb25,Pxtb26,Pxtb27,Pxtb28,Pxtb29,Pxtb30
};

public char *xtifont[] = {
Pxti3,Pxti4,Pxti5,Pxti6,Pxti7,Pxti8,Pxti9,Pxti10,Pxti11,Pxti12,Pxti13,Pxti14,
Pxti15,Pxti16,Pxti17,Pxti18,Pxti19,Pxti20,Pxti21,Pxti22,Pxti23,Pxti24,Pxti25,
Pxti26,Pxti27,Pxti28,Pxti29,Pxti30
};

public char *xtbifont[] = {
Pxtbi3,Pxtbi4,Pxtbi5,Pxtbi6,Pxtbi7,Pxtbi8,Pxtbi9,Pxtbi10,Pxtbi11,Pxtbi12,
Pxtbi13,Pxtbi14,Pxtbi15,Pxtbi16,Pxtbi17,Pxtbi18,Pxtbi19,Pxtbi20,Pxtbi21,
Pxtbi22,Pxtbi23,Pxtbi24,Pxtbi25,Pxtbi26,Pxtbi27,Pxtbi28,Pxtbi29,Pxtbi30
};

public char *GreekMap[] = {
Pgrk3,Pgrk4,Pgrk5,Pgrk6,Pgrk7,Pgrk8,Pgrk9,Pgrk10,Pgrk11,Pgrk12,
Pgrk13,Pgrk14,Pgrk15,Pgrk16,Pgrk17,Pgrk18,Pgrk19,Pgrk20,Pgrk21,
Pgrk22,Pgrk23,Pgrk24,Pgrk25,Pgrk26,Pgrk27,Pgrk28,Pgrk29,Pgrk30
};


Window w;
/* do not draw new window on redraw */
static Boolean FirstWindow=TRUE;


extern FILE *fout;
static char*     currFont = NULL;
static int       currSize = -1;/* eventually between MINFNTSIZ and MAXFNTSIZ points */
static LineType  currLine = none;
static double	 currThick = -2.0;
static double	 currGray = 0.0;

/* COLOR */
Color colors[NCOLORS];
int pixels[NCOLORS];
Status XGetColorCells();
int status;
int planes;
short int rcol, gcol, bcol;

double transformX(), transformY();


sendi( p )
LocalObjectType *p;
{
	fprintf(stderr,
		"Error: Cannot display IViews graph on this machine\n");
	fprintf(stderr,"Use isplot with the -i switch, instead.\n");
	exit(1);
}

/* this object contains the current transformed from and to points.
 * No longer do transformations in place due to the difficulty of redrawing
*/
private   LocalObjectType dummyObj, *dummyp = &dummyObj;


sendx( p )
LocalObjectType *p;
{
static int  vcount = 1;
static int filled = 0;
Font MyGetFont();
Vertex *GetSymbolV();

   if (FirstWindow)
   {
	FirstWindow = FALSE;
	initX();
   }

   transformcoord(p, dummyp);
	/* convert to top left co-ord and return new coords in dummyp */
   switch( p->name )
   {
   case objCurLine:
   case objline :
	/*
	 *       if ((!FirstFill)&&(p->un.line.line == fill))
	 *		WhiteOutX();
	*/
	if( currLine != p->un.line.line || currThick != p->un.line.thick 
		|| currGray != p->gray)
       	{
		setConstsForCurveX(p);
	  
	}
       	if (( currLine != none )&&(currLine != fill))
        {
		width = ceil(currThick);
		height = ceil(currThick);
		v[0].x = dummyp->from[xpt];
		v[0].y = dummyp->from[ypt];
		v[0].flags = v[0].flags & 0x111e;/* absolute */
    		v[1].x = dummyp->un.line.to[xpt];
		v[1].y = dummyp->un.line.to[ypt];
		v[1].flags = v[1].flags & 0x111e;/* absolute */		
		WidthCorrect(v,width,height);

    		XDrawDashed(w,v,2,width, height, pixel, xpat,func,AllPlanes);
		/* draws repeated patterns of given height and width */
	}
       	else if (currLine == fill)
        {
		/* first shade */
		vf[0].x = dummyp->from[xpt];
		vf[0].y = dummyp->from[ypt];
		vf[0].flags = vf[0].flags & 0x111e;/* absolute */

    		vf[1].x = dummyp->un.line.to[xpt];
		vf[1].y = dummyp->un.line.to[ypt];
		vf[1].flags = vf[1].flags & 0x111e;/* absolute */

		vf[2].x = dummyp->un.line.to[xpt];
		vf[2].y = transformY(translate);
		vf[2].flags = vf[2].flags & 0x111e;/* absolute */

    		vf[3].x = dummyp->from[xpt];
		vf[3].y = transformY(translate);
		vf[3].flags = vf[3].flags & 0x111e;/* absolute */

		vf[4].x = dummyp->from[xpt];
		vf[4].y = dummyp->from[ypt];
		vf[4].flags = vf[4].flags & 0x111e;/* absolute */
    		XDrawFilled(w,vf,5,pixel,func,AllPlanes);


		/* then black line */
		width = ceil(currThick);
		height = ceil(currThick);
		v[0].x = dummyp->from[xpt];
		v[0].y = dummyp->from[ypt];
		v[0].flags = v[0].flags & 0x111e;/* absolute */
    		v[1].x = dummyp->un.line.to[xpt];
		v[1].y = dummyp->un.line.to[ypt];
		v[1].flags = v[1].flags & 0x111e;/* absolute */		
		WidthCorrect(v,width,height);
    		XDrawDashed(w,v,2,width,height,BlackPixel,xpat,
			func,AllPlanes);
		/* draws repeated patterns of given height and width */
	}
   break;
   case objsymbol :
	if( currSymbol != p->un.symbol.symbol || 
		currSize != p->un.symbol.fontsize )
        {
		setConstsForSymbolX(p);
	}
       	if (p->un.symbol.symbol != nonesymbol)
       	{
		Vsym = GetSymbolV(p, dummyp, &filled, &vcount);
		if (filled) 
			XDrawFilled(w,Vsym,vcount,BlackPixel,func,AllPlanes);
		else
			XDraw(w, Vsym, vcount,1,1,BlackPixel,func,AllPlanes);
       	}
   break;
   case objtext :
       	if( currFont != p->un.text.FF || currSize != p->un.text.fontsize )
        {
		setConstsForTextX(p);
	}
	len = strlen(p->un.text.StrPtr);
	MyGetPt(v, p, dummyp);
	if (len)
		XTextMask(w, v[0].x, v[0].y, p->un.text.StrPtr, 
			len, font, BlackPixel);
	CurStrWidth = XQueryWidth(p->un.text.StrPtr,font);
   break;
   case objCurText :
       	if( currFont != p->un.text.FF || currSize != p->un.text.fontsize )
        {
	 	currFont = p->un.text.FF;
	 	currSize = p->un.text.fontsize;
	 	font = MyGetFont(currFont, currSize);	 	 
	}
	len = strlen(p->un.text.StrPtr);
	/*	 MyGetPt(v, p, dummyp);*/
	/* uses v and initial curstrwidth from objtext */

	v[0].x += CurStrWidth;
	if (IView) v[0].y = v[0].y + p->un.text.up;
		/* y's not reversed in I */
	else if (XView) v[0].y = v[0].y - p->un.text.up;
		/*y's reversed in X */
	else fprintf(stderr,"Splot error: Only IView and XView suooprted\n");
	CurStrWidth = XQueryWidth(p->un.text.StrPtr,font);
	if (len)
	 	XTextMask(w, v[0].x, v[0].y, p->un.text.StrPtr, 
			len, font, BlackPixel);
	if (IView) v[0].y = v[0].y - p->un.text.up;
		/* y's not reversed in I */
	else if (XView) v[0].y = v[0].y + p->un.text.up;
		/*y's reversed in X */
	else fprintf(stderr,"Splot error: Only IView and XView suooprted\n");
		/*restore*/
   break;
   case objLineStartFlag :
   case objLineEndFlag :
   case objflag:
   case objflagcurves: 
   case objflagtext: 
   case objflagaxes: 
   case objflagkey: 
   case objTextStartFlag: 
   case objTextEndFlag: 
   case objdummy: 
   break;
   default:
	fprintf( stderr, "Splot.sendx: Internal Error\n" );
   }
   XFlush();
}

setConstsForCurveX(p)
LocalObjectType *p;
{
	currLine = p->un.line.line;
	currThick = p->un.line.thick;
	currGray = p->gray;
	if (XGray == 0)
	{
		if (p->gray <= 0.9) pixel = BlackPixel;
		else pixel = WhitePixel;
	}
	else if (p->gray <= 0.001) pixel = BlackPixel;
	else if (p->gray >= 0.999) pixel = WhitePixel;
	else
	{
		ColorIndex = currGray * (NCOLORS-1);
		pixel = colors[ColorIndex].pixel;
	}
	switch( currLine )
	{
	case solid:
	case fill:
	    	xpat = XMakePattern(SolidPattern, 8, 1);
	break;
	case dashes:
	     	xpat = XMakePattern(DashedPattern, 8, 1);
	break;
	case stipple:
	      	xpat = XMakePattern(StipplePattern, 8, 1);
	break;
	case pat:
	      	xpat = XMakePattern(StipplePattern, 8, 1);
	break;
	case dots:
	      	xpat = XMakePattern(DotPattern, 8, 1);
	break;
	default:
	      	xpat = XMakePattern(SolidPattern, 8, 1);
	      break;
	}
}

setConstsForSymbolX(p)
LocalObjectType *p;
{
	currSymbol = p->un.symbol.symbol;
	currSymbolSize = p->un.symbol.fontsize;
}

setConstsForTextX(p)
LocalObjectType *p;
{
	currFont = p->un.text.FF;
	currSize = p->un.text.fontsize;
	font = MyGetFont(currFont, currSize);	 	 
}


i()
{
	fprintf(stderr,
		"Error: Cannot display IViews graph on this machine\n");
	fprintf(stderr,"Use splot with the -i switch, instead.\n");
	exit(1);
}

x()
{
char instr[256];
char chr = 'r';
	if (!IDrawEdit)  /* no drawedit in X, so always holds in X */
	while (chr == 'r')
	{
   		fprintf(stderr,
			"To redraw, enter r; to stop, enter any char:");
   		fscanf(stdin,"%s",instr);
   		chr = instr[0];
   		if (chr == 'r')
   		{
			FirstFill = FALSE;
			sendobj();
   		}
	}
}


initX ()
{
Display *display;
OpaqueFrame	    f;
int i;

  	if (IView) display = XOpenDisplay(display);
   	else if (XView) display = XOpenDisplay( 0 );
   	else fprintf(stderr,"Splot error: Only IView or XView supported\n");

   	f.bdrwidth = 2;
   	f.border = BlackPixmap;
   	f.background = WhitePixmap;
   	w = XCreate("splot","splot",0,"=650x750+0+0",&f,50,50);
   	if (!XMapWindow( w )) 
   	{
		fprintf(stderr,"Splot error: Could not open window\n");
		exit(1);
   	}
  
   	if (XGray)
   	{
   		/* COLOR */
		status = XGetColorCells(0, NCOLORS, 0, &planes, pixels);
   		for (i=0; i < NCOLORS; i++) 
   		{
			colors[i].pixel = pixels[i];
			rcol = gcol = bcol = i * 18;
			colors[i].red = rcol << 8;
			colors[i].green = gcol << 8;
			colors[i].blue = bcol << 8;
   		}
   		XStoreColors(NCOLORS , colors);
   	}
}

Font MyGetFont(currFont, currSize)
int currSize;/* between MINFNTSIZ and MAXFNTSIZ points */
char *currFont;
/* takes currFont and currSize as arguments and returns a Font */
{
String name;
	if ((currSize < MINFNTSIZ) || (currSize > MAXFNTSIZ))
	{
		fprintf(stderr, 
			"splotx.GetFont: Weird font size, defaulting\n");
		currSize = (MINFNTSIZ + MAXFNTSIZ)/2;
	}

	currSize -= MINFNTSIZ;
		/* index into array of first hmin to hmax fonts in xfont */
	if (currFont == Phelvetica)
		name = xhfont[currSize];
	else if (currFont == PhelveticaBold)
		name = xhbfont[currSize];
	else if (currFont == PhelveticaItalics)
		name = xhifont[currSize];
	else if (currFont == PhelveticaBoldItalics)
		name = xhbifont[currSize];
	else if (currFont == Ptimesroman)
		name = xtfont[currSize];
	else if (currFont == PtimesromanBold)
		name = xtbfont[currSize];
	else if (currFont == PtimesromanItalics)
		name = xtifont[currSize];
	else if (currFont == PtimesromanBoldItalics)
		name = xtbifont[currSize];
	else if (currFont == Greek) 
		name = GreekMap[currSize]; /*map it to some other font */
	else 
	{
		fprintf(stderr, 
			"Splot.GetFont: Strange font name, defaulting\n");
	name = DefFont;
}

	fontinfo = XOpenFont(name);
	if (fontinfo == NULL) 
	{
		fprintf(stderr, 
			"Splot.GetFont: Font not opened, defaulting\n");
		fontinfo = XOpenFont(DefFont);
	}
	return(fontinfo->id);
}

MyGetPt(v , p, dummyp)
LocalObjectType *p, *dummyp;
Vertex v[];
{
int len;
int charht, charwt;

      	len = strlen(p->un.text.StrPtr);
      	charht = fontinfo->height;
      	charwt = fontinfo->width;

	/* change tic marks on Y axis to dashes */
	if (IsItYAxisTicMark(p))
		p->un.text.StrPtr = dashmark;

      	switch( p->un.text.align )
        {
	case left:
		v[0].x = dummyp->from[xpt];
		v[0].y = dummyp->from[ypt] - (charht/2);
	break;
	case center:
		v[0].x = dummyp->from[xpt] - charwt * len / 2;
		v[0].y = dummyp->from[ypt] - (charht/2);
	break;
	case right:
		v[0].x = dummyp->from[xpt] - charwt * len;
		v[0].y = dummyp->from[ypt] - (charht/2);
	break;
	}
}

IsItYAxisTicMark(p)
LocalObjectType *p;
{
	if (
	      (
	       	(p->un.text.angle <= -89.0)&&
	       	(p->un.text.angle >= -91.0)&&
	   	( strncmp(ticmark, p->un.text.StrPtr, 1) == 0)
	      )||
	      (
	       	(p->un.text.angle >= 89.0)&&
	       	(p->un.text.angle <= 91.0)&&
	   	( strncmp(ticmark, p->un.text.StrPtr, 1) == 0)
	      )
	   )
		return(1);
	else
		return(0);
}


transformcoord(p, dummyp)
LocalObjectType *p, *dummyp;
{
   	if (IView)
   	{
    		dummyp->from[ypt] = TY + (p->from[ypt]) * COMPR;
    		dummyp->from[xpt] = TX + (p->from[xpt]) * COMPR;
   	}
   	else if (XView)
   	{
		dummyp->from[ypt] = MAXY - (p->from[ypt]) * COMPR;
		dummyp->from[xpt] = MAXX + (p->from[xpt]) * COMPR;
   	}
   	else fprintf(stderr,"Splot error: Only IView or XView supported\n");

   	switch( p->name )
   	{
     	case objCurLine:
     	case objline :
		if (IView)
		{
			dummyp->un.line.to[ypt] = 
				TY + (p->un.line.to[ypt]) * COMPR;
			dummyp->un.line.to[xpt] = 
				TX + (p->un.line.to[xpt]) * COMPR;
		}
		else if (XView)
		{
			dummyp->un.line.to[ypt] = 
				MAXY - (p->un.line.to[ypt]) * COMPR;
			dummyp->un.line.to[xpt] = 
				MAXX + (p->un.line.to[xpt]) * COMPR;
		}
		else fprintf(stderr,
			"Splot error: Only IView or XView supported\n");
	break;
     	default:
	break;
    	}
}

Vertex *GetSymbolV(p, dummyp, Pfilled, Pvcount)
/*returns pointer to a vertex, Vsym */
LocalObjectType *p, *dummyp;
int *Pfilled, *Pvcount;
{
Vertex *VsymLoc;
int mul, vcnt;
	switch (p->un.symbol.symbol)
	{
	case cross: *Pfilled = 0; *Pvcount = 5; VsymLoc = Vcross;
	break;
	case triangle: *Pfilled = 0; *Pvcount = 5; VsymLoc = Vtriangle;
	break;
	case trianglefilled: *Pfilled = 1; *Pvcount = 5; VsymLoc = Vtriangle;
	break;
	case diamond: *Pfilled = 0; *Pvcount = 6; VsymLoc = Vdiamond;
	break;
	case diamondfilled: *Pfilled = 1; *Pvcount = 6; VsymLoc = Vdiamond;
	break;
	case square: *Pfilled = 0; *Pvcount = 6; VsymLoc = Vsquare;
	break;
	case squarefilled: *Pfilled = 1; *Pvcount = 6; VsymLoc = Vsquare;
	break;
	case rectangle: *Pfilled = 0; *Pvcount = 6; VsymLoc = Vrectangle;
	break;
	case rectanglefilled: *Pfilled = 1; *Pvcount=6; VsymLoc = Vrectangle;
	break;
	case circle: *Pfilled = 0; *Pvcount = 8; VsymLoc = Vcircle;
	break;
	case circlefilled: *Pfilled = 1; *Pvcount = 8; VsymLoc = Vcircle;
	break;
	case bullet: *Pfilled = 1; *Pvcount = 8; VsymLoc = Vcircle;
	break;
	case star: *Pfilled = 0; *Pvcount = 9; VsymLoc = Vstar;
	break;
	case plus: *Pfilled = 0; *Pvcount = 5; VsymLoc = Vplus;
	break;
	default:
	break;
	}
	
	if (p->un.symbol.symbol == circle) mul = p->un.symbol.fontsize/1.5;
	else mul = p->un.symbol.fontsize;
	mul = mul * MULBLOW;
	VsymTmp[0].x = dummyp->from[xpt];
	VsymTmp[0].y = dummyp->from[ypt];
	VsymTmp[0].flags = VsymLoc[0].flags;
	/* fill only center point, other rel points already filled
		so just need to be scaled to symbolsize*/
	vcnt = 1;
	while (vcnt < *Pvcount)
	{
		VsymTmp[vcnt].x = VsymLoc[vcnt].x * mul;
		VsymTmp[vcnt].y = VsymLoc[vcnt].y * mul;
		VsymTmp[vcnt].flags = VsymLoc[vcnt].flags;
		vcnt++;
	}
	return(VsymTmp);
}

WidthCorrect(v,width,height)

Vertex v[];
int width, height;
{
	if (v[0].x > v[1].x) v[0].x -= width;
	else if (v[1].x > v[0].x) v[1].x -= width;
	else
	{
		v[0].x -= width / 2; 
		v[1].x -= width / 2; 
	}

	if (v[0].y > v[1].y) v[0].y -= height;
	else if (v[1].y > v[0].y) v[1].y -= height;
	else
	{
		v[0].y -= height / 2; 
		v[1].y -= height / 2; 
	}
}

WhiteOutX()
{
	vf[0].x = transformX(translate);
	vf[0].y = transformY(translate);
	vf[0].flags = vf[0].flags & 0x111e;/* absolute */

	vf[1].x = transformX(translate + graphsize[xpt] * 72.0 / 2.54);
	vf[1].y = transformY(translate);
	vf[1].flags = vf[1].flags & 0x111e;/* absolute */

	vf[2].x = transformX(translate + graphsize[xpt] * 72.0 / 2.54);
	vf[2].y = transformY(translate + graphsize[ypt] * 72.0 / 2.54);
	vf[2].flags = vf[2].flags & 0x111e;/* absolute */

	vf[3].x = transformX(translate);
	vf[3].y = transformY(translate + graphsize[ypt] * 72.0 / 2.54);
	vf[3].flags = vf[3].flags & 0x111e;/* absolute */

	vf[4].x = transformX(translate);
	vf[4].y = transformY(translate);
	vf[4].flags = vf[4].flags & 0x111e;/* absolute */

	XDrawFilled(w,vf,5,WhitePixel,func,AllPlanes);

	FirstFill = TRUE;
}

double transformY(y)
double y;
{
	if (IView) return(y * COMPR);
	else if (XView) return(MAXY - y * COMPR);
	else fprintf(stderr,"Splot error: Only IView or XView supported\n");
}


double transformX(x)
double x;
{
	if (IView) return(x * COMPR);
	else if (XView) return(MAXX + x * COMPR);
	else fprintf(stderr,"Splot error: Only IView or XView supported\n");
}
