/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

#include <strings.h>	
#include <stdio.h>
#include <math.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"

extern FILE *fout;
extern double getdegrees(), atan(), charheight(),charwidth(),log10(),mylog();

curlin(c)
int c;/* current curve */
{
pointType *ptPtr;/* current point */
	ptPtr = (curves[c])->fstPtr;
	if (ptPtr != nil)
	LinSt(ptPtr->pt[xpt], ptPtr->pt[ypt],
		(curves[c])->gray, (curves[c])->interp, (curves[c])->type, c);
		/* send start curve sequence, include first pt.*/
	while (ptPtr != nil)
	{
		if (ptPtr != (curves[c])->fstPtr)
			/*two pts needed for a line */
		{
			/* line part */
			InitCurLineObj(obj[curobj], c);
			(obj[curobj])->from[xpt] = ptPtr->prvPtr->pt[xpt];
			(obj[curobj])->from[ypt] = ptPtr->prvPtr->pt[ypt];
			(obj[curobj])->un.line.to[xpt] = ptPtr->pt[xpt];
			(obj[curobj])->un.line.to[ypt] = ptPtr->pt[ypt];
			GetNewObjcurobj();
		}
		/* symbol part */
		InitObjSymbol(obj[curobj], c);
		(obj[curobj])->from[xpt] = ptPtr->pt[xpt];
		(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
		GetNewObjcurobj();
		ptPtr = ptPtr->nxtPtr;
	}
	LinEnd((curves[c])->gray,(curves[c])->interp);/*send end */
}

curyhis(c)
int c;/* current curve */
{
pointType *ptPtr;/* current point */
	ptPtr = (curves[c])->fstPtr;
	while (ptPtr != nil)
	{
		LinSt(ptPtr->pt[xpt],limits[ypt][minval], (curves[c])->gray,
			(curves[c])->interp, (curves[c])->type, c);
		/* line part */
		InitCurLineObj(obj[curobj], c);
		(obj[curobj])->un.line.thick = 
			(curves[c])->thick * DefBarThickMul;
		(obj[curobj])->from[xpt] = ptPtr->pt[xpt];/*Xaxis*/
		(obj[curobj])->from[ypt] = limits[ypt][minval];
		(obj[curobj])->un.line.to[xpt] = ptPtr->pt[xpt];
		(obj[curobj])->un.line.to[ypt] = ptPtr->pt[ypt];
		GetNewObjcurobj();
		LinEnd((curves[c])->gray,(curves[c])->interp);
		/* symbol part */
		InitObjSymbol(obj[curobj], c);
		(obj[curobj])->from[xpt] = ptPtr->pt[xpt];
		(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
		GetNewObjcurobj();
		ptPtr = ptPtr->nxtPtr;
	}
}


curxhis(c)
int c;/* current curve */
{
pointType *ptPtr;/* current point */
	ptPtr = (curves[c])->fstPtr;
	while (ptPtr != nil)
	{
		LinSt(limits[xpt][minval],ptPtr->pt[ypt],(curves[c])->gray,
			(curves[c])->interp, (curves[c])->type, c);
		/* line part */
		InitCurLineObj(obj[curobj], c);
		(obj[curobj])->un.line.thick = 
			(curves[c])->thick * DefBarThickMul;
		(obj[curobj])->from[xpt] = limits[xpt][minval];/*Yaxis*/
		(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
		(obj[curobj])->un.line.to[xpt] = ptPtr->pt[xpt];
		(obj[curobj])->un.line.to[ypt] = ptPtr->pt[ypt];
		GetNewObjcurobj();
		LinEnd((curves[c])->gray,(curves[c])->interp);
		/* symbol part */
		InitObjSymbol(obj[curobj], c);
		(obj[curobj])->from[xpt] = ptPtr->pt[xpt];
		(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
		GetNewObjcurobj();
		ptPtr = ptPtr->nxtPtr;
	}
}

curstep(c)
int c;/* current curve */
{
int ver;
pointType *ptPtr;/* current point */
	ptPtr = (curves[c])->fstPtr;
	if (ptPtr != nil)
	LinSt(ptPtr->pt[xpt],ptPtr->pt[ypt],
		(curves[c])->gray,(curves[c])->interp, (curves[c])->type, c);
		/* send start curve sequence, include first pt.*/
	while (ptPtr != nil)
	{
		if (ptPtr != (curves[c])->lstPtr)
			/*do not send segment for last point */
			/*first point symbol. Line to second pt */
		for (ver=0;ver<=1;ver++)
			/* line part */
		{
			/* first horizontal line for ver=0, then ver*/
			InitCurLineObj(obj[curobj], c);
			(obj[curobj])->from[xpt] = ver ?
			  	ptPtr->nxtPtr->pt[xpt] : ptPtr->pt[xpt];
			(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
			(obj[curobj])->un.line.to[xpt] = 
				ptPtr->nxtPtr->pt[xpt];
			(obj[curobj])->un.line.to[ypt] = ver ?
				ptPtr->nxtPtr->pt[ypt] : ptPtr->pt[ypt];
			GetNewObjcurobj();
		}
		/* symbol part */
		InitObjSymbol(obj[curobj], c);
		(obj[curobj])->from[xpt] = ptPtr->pt[xpt];
		(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
		GetNewObjcurobj();
		ptPtr = ptPtr->nxtPtr;
	}
	LinEnd((curves[c])->gray,(curves[c])->interp);/*send end */
}


clip()
{
double x,y;
   if ((XView == 0) && (IView == 0))
   {
	x = translate;
	y = translate;
	fprintf(fout,"%f %f ",x,y);

	x = translate + graphsize[xpt] * 72.0 / 2.54;
	y = translate;
	fprintf(fout,"%f %f ",x,y);

	x = translate + graphsize[xpt] * 72.0 / 2.54;
	y = translate + graphsize[ypt] * 72.0 / 2.54;
	fprintf(fout,"%f %f ",x,y);

	x = translate;
	y = translate + graphsize[ypt] * 72.0 / 2.54;
	fprintf(fout,"%f %f ",x,y);

	fprintf(fout,"newpath moveto lineto lineto lineto closepath clip\n");
   }
}

noclip()
{
double x,y;
   if ((XView == 0) && (IView == 0))
   {
	fprintf(fout,"initclip \n");/*clip set to default */
   }
}


LinSt(fromx, fromy, gray, intrp, line, c)
double fromx, fromy, gray;
InterpType intrp;
int c; /* curve number */
LineType line;
{
	(obj[curobj])->name = objLineStartFlag;
	(obj[curobj])->un.line.interp = intrp;
	(obj[curobj])->un.line.line = line;
	(obj[curobj])->gray = gray;
	(obj[curobj])->un.line.mat.ang = (curves[c])->mat.ang;
	(obj[curobj])->un.line.mat.freq = (curves[c])->mat.freq;
	(obj[curobj])->un.line.mat.indx = (curves[c])->mat.indx;
	(obj[curobj])->un.line.mat.showline = (curves[c])->mat.showline;
	(obj[curobj])->from[xpt] = fromx;
	(obj[curobj])->from[ypt] = fromy;
	(obj[curobj])->scale = TRUE;
	GetNewObjcurobj();
}

LinEnd(gray, intrp)
double gray;
InterpType intrp;
{
	(obj[curobj])->name = objLineEndFlag;
	(obj[curobj])->gray = gray;
	(obj[curobj])->un.line.interp = intrp;
	GetNewObjcurobj();
}


CurveSeqStart()
{
	(obj[curobj])->name = objflagcurves;
	(obj[curobj])->scale = FALSE;
	GetNewObjcurobj();
}

InitCurLineObj(p, c)
int c;
LocalObjectType *p;
{
	p->name = objCurLine;
	p->gray = (curves[c])->gray;
	p->un.line.line = (curves[c])->type;
	p->un.line.interp = (curves[c])->interp;
	p->un.line.thick = (curves[c])->thick;
	p->un.line.mat.ang = (curves[c])->mat.ang;
	p->un.line.mat.freq = (curves[c])->mat.freq;
	p->un.line.mat.indx = (curves[c])->mat.indx;
	p->un.line.mat.showline = (curves[c])->mat.showline;
	p->scale = TRUE;
}

InitObjSymbol(p, c)
int c;
LocalObjectType *p;
{
int symbolsizepar;
	p->name = objsymbol;
	p->un.symbol.symbol = (curves[c])->symbol;
	p->un.symbol.fontsize = gs * FFsize(graph.font);
	symbolsizepar = (curves[c])->symbolsize - defSymbolSize;
	p->un.symbol.fontsize += symbolsizepar;
	if (p->un.symbol.fontsize < 1) p->un.symbol.fontsize = 1;
	p->scale = TRUE;
}

EnterConf(c)
{
pointType *ptPtr;/* current point */

	ptPtr = (curves[c])->fstPtr;
	if ((curves[c])->showConf)
	while (ptPtr != nil)
	{
	    if (ptPtr->conf != 0.0)
	    {
		(obj[curobj])->name = objline;
		(obj[curobj])->gray = (curves[c])->gray;
		(obj[curobj])->un.line.thick = (curves[c])->thick;
		(obj[curobj])->un.line.line = (curves[c])->type;
		(obj[curobj])->un.line.interp = linearinterp;
		(obj[curobj])->scale = TRUE;
		if ((curves[c])->interp == xhistogram)
		{
			(obj[curobj])->from[xpt] = 
				ptPtr->pt[xpt] - ptPtr->conf;
			(obj[curobj])->from[ypt] = ptPtr->pt[ypt];
			(obj[curobj])->un.line.to[xpt] = 
				ptPtr->pt[xpt] + ptPtr->conf;
			(obj[curobj])->un.line.to[ypt] = ptPtr->pt[ypt];
		}
		else
		{
			(obj[curobj])->from[xpt] = ptPtr->pt[xpt];
			(obj[curobj])->from[ypt] = 
				ptPtr->pt[ypt] - ptPtr->conf;
			(obj[curobj])->un.line.to[xpt] = ptPtr->pt[xpt];
			(obj[curobj])->un.line.to[ypt] = 
				ptPtr->pt[ypt] + ptPtr->conf;
		}
		scaleobj(obj[curobj]);
		(obj[curobj])->scale = FALSE;

		GetNewObjcurobj(); 
	    }
		ptPtr = ptPtr->nxtPtr;
	}
}
