/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */


%token NEW
%token GRAPH
%token TITLE
%token SIZE
%token FONT
%token ANGLE
%token ALIGN
%token LEFT
%token RIGHT
%token CENTER
%token BAR
%token REGRESSION
%token STEP
%token XHISTOGRAM
%token YHISTOGRAM
%token SMOOTH
%token SPLINE
%token KEY
%token CURVE 
%token POINTS
%token CONFIDENCE
%token LABEL
%token LABELS
%token TYPE
%token INTERPOLATION
%token GRAY
%token MAT
%token X
%token Y
%token MAXIMUM
%token MINIMUM
%token UNIT
%token INTERVAL
%token SCALE
%token LOGBASE
%token NUMBERSTYLE
%token TEXT
%token INPUT
%token LINE
%token SYMBOL
%token BOTH
%token NONE
%token SOLID
%token DASHES
%token STIPPLE
%token DOTS
%token PAT
%token FILL
%token BOLD
%token CROSS
%token TRIANGLE
%token TRIANGLEFILLED
%token DIAMOND
%token DIAMONDFILLED
%token SQUARE
%token BOX
%token SQUAREFILLED
%token SOLIDBOX
%token RECTANGLE
%token RECTANGLEFILLED
%token CIRCLE
%token CIRCLEFILLED
%token BULLET
%token PLUS
%token STAR
%token LINEAR
%token LOGS
%token UNKNOWNCMD
%token COMMENT
%token EXCLUDE
%token MINORTIC
%token MINORTICS
%token NUMBERS
%token FONTNAME
%token INTEGER
%token FLOATING
%token SCIENTIFIC
%token EXPONENT
%token MIRROR
%token ORIGIN
%token AXES

%{

#include <stdio.h>
#include <strings.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"

static double currSSfreq=30.0, currSSang = 0.0; /* for setscreen */
static int currSSfnIndex = 0;


char pstr[MAXLABEL];/*stores previous correct instring - for error reporting*/
char errorpos[MAXLABEL];/* stores prev correct text word */
double tmpfloat;
int tmpint;
pointType *ptPtr;/*temp pointer for current point in curve */
boolean intext = FALSE;
%}

%% /* rules section */

CommandStream:		Command '\n'
		|	CommandStream Command '\n'
		|	CommandStream '\n'
		|	error '\n'
			{
				fprintf(stderr,
				"***splot::error near line %d\n", lineno);
				fprintf(stderr,
				"previous text: %s, ",errorpos);
/*				fprintf(stderr,"prev: %s, ",pstr);*/
				fprintf(stderr,"current text: %s\n",yytext);
				yyerrok;
			}
		|	'\n'
		;

Command:		NewGraphCommand
		|	GraphTitleCommand
		|	SizeCommand
		|	GraphFontCommand
		|	GraphTextFontCommand
		|	GraphCurveFontCommand
		|	KeyCommand
		|	NewCurveCommand
		|	NewTextCommand
		|	CurveFontCommand
		|	TextFontCommand
		|	TextAngleCommand
		|	TextAlignCommand
		|	CurveLabelCommand
		|	CurveTypeCommand
		|	CurveSymbolCommand
		|	CurveInterpolationCommand
		|	CurveGrayCommand
		|	CurveExcludeLine
		|	CurveConfidence
		|	CurveMatCommand
		|	XLabelCommand
		|	XFontCommand
		|	XMaximumCommand
		|	XMinimumCommand
		|	XUnitCommand
		|	XScaleCommand
		|	XLogBaseCommand
		|	XIntervalCommand
		|	XNumberStyleCommand
		|	YLabelCommand
		|	YFontCommand
		|	YMaximumCommand
		|	YMinimumCommand
		|	YUnitCommand
		|	YScaleCommand
		|	YLogBaseCommand
		|	YIntervalCommand
		|	YNumberStyleCommand
		|	MirrorAxesCommand
		|	ExcludeMirrorNumbersCommand
		|	ExcludeMirrorLabelsCommand
		|	OriginCommand
		|	ExcludeCurve
		|	ExcludeMinorticNumbers
		|	ExcludeMinortics
		|	ExcludeXNos
		|	ExcludeYNos
		|	ExcludeXLine
		|	ExcludeYLine
		|	ExcludeAxes
		|	ExcludeText
		| 	BadCommand
		| 	CommentCommand
		|	NewPointsCommand 

		;

BadCommand:		BadString 
		;

BadString:		UNKNOWNCMD
			{
				unknowncmderror();
			}
		|	UNKNOWNCMD usentence
			{
				unknowncmderror();
			}
		;

usentence:		usentence INPUT
		|	usentence UNKNOWNCMD
		|	INPUT
		|	UNKNOWNCMD
		;

CommentCommand:		COMMENT restofcomment
		|	COMMENT
		;

restofcomment:		restofcomment INPUT
		|	INPUT
		;
		
NewGraphCommand:	NEW GRAPH 
			{
				newgraphproc();
			}
		;

GraphTitleCommand:	GRAPH TITLE gsentence
		|	GRAPH TITLE
		;

gsentence:		gsentence INPUT 
			{strcat(graph.title, yytext);}
		|	INPUT
			{strcat(graph.title, yytext);}
		;
				
SizeCommand:		SIZE restofsize
		;

restofsize:		/* nothing */
			{
				graph.size[xpt] = 6;
				graphsize[xpt] = graph.size[xpt]*2.54;
				graph.size[ypt] = 6;
				graphsize[ypt] = graph.size[ypt]*2.54;
			}
		|	INPUT 
			{
				graph.size[xpt] = atof(yytext);
				graphsize[xpt] = graph.size[xpt]*2.54;
			}
		     	INPUT
			INPUT
			{
				graph.size[ypt] = atof(yytext);
				graphsize[ypt] = graph.size[ypt]*2.54;
			}
		;

GraphFontCommand:	GRAPH FONT FONTNAME
			{
				graph.font = yylval;
			}
		;

GraphTextFontCommand:	GRAPH TEXT FONT FONTNAME
			{
				defTextFont = yylval;
			}
		;

GraphCurveFontCommand:	GRAPH CURVE FONT FONTNAME
			{
				defGraphThick = FFthick(yylval);
			}
		;

KeyCommand:		KEY INPUT
			{
				graph.keypos[xpt] = atof(yytext);
			}
			INPUT
			INPUT
			{
				graph.keypos[ypt] = atof(yytext);
				if ((graph.keypos[xpt] != 0.0)&&
				    (graph.keypos[ypt] != 0.0))
					graph.includekey = TRUE;
			}
			keytype
		;

keytype:		INPUT LINE keyfntnm
			{
				graph.key = ktype;
			}
		|	INPUT SYMBOL keyfntnm
			{
				graph.key = ksymbol;
			}
		|	INPUT BOTH keyfntnm
			{
				graph.key = kboth;
			}
		|	/* nothing */
		;

keyfntnm:		INPUT FONTNAME
			{
				graph.keyfont = yylval;
			}
		| 	/* nothing */
		;

NewTextCommand:		NEW TEXT 
			{
				newtextproc();
			}
			INPUT
			{
				(text[curtext])->pos[xpt] = atof(yytext);
			}
			INPUT
			INPUT
			{
				(text[curtext])->pos[ypt] = atof(yytext);
			}
			textinput
		;

textinput	:	'\n' 
			{intext = TRUE;}
			tsentencebig
			{
				 intext = FALSE;
			}
		|	'\n'
		;

tsentencebig:		tsentenceret tsentencebig
		|	tsentenceret
		;

tsentenceret	:	tsentence '\n'
			{
				strcat((text[curtext])->label,yytext);
			}
		;

tsentence:		tsentence tword 
		|	tword 
		;

tword:			INPUT	
			{
				strcat((text[curtext])->label,yytext);
			}
		;

ExcludeText:		EXCLUDE TEXT
			{
				if (curtext == -1) notexterr();
				else (text[curtext])->include = FALSE;
			}
		;

TextAngleCommand:	TEXT 
			ANGLE  
			INPUT
			{
				if (curtext == -1) notexterr();
				else
				(text[curtext])->angle = atof(yytext);
			}
		;


TextAlignCommand:	TEXT 
			ALIGN  
			{
				if (curtext == -1) notexterr();
			}
			aligntype
		;

aligntype:		LEFT
			{
				(text[curtext])->align = left;
			}
		| CENTER
			{
				(text[curtext])->align = center;
			}
		| RIGHT
			{
				(text[curtext])->align = right;
			}
		;


TextFontCommand:	TEXT 
			FONT  
			FONTNAME	
			{
				if (curtext == -1) notexterr();
				else (text[curtext])->font = yylval;
			}
		;

MirrorAxesCommand:	MIRROR AXES
			{
				MirrorAxes = TRUE;
				MirrorAxisNumbers = TRUE;
				MirrorAxisLabels = TRUE;
			}
		;

ExcludeMirrorNumbersCommand:	EXCLUDE MIRROR NUMBERS
			{
				MirrorAxes = TRUE;
				MirrorAxisNumbers = FALSE;
			}
		;

ExcludeMirrorLabelsCommand:	EXCLUDE MIRROR LABELS
			{
				MirrorAxes = TRUE;
				MirrorAxisLabels = FALSE;
			}
		;

OriginCommand:		ORIGIN INPUT
			{
				NewOrigin = TRUE;
				origin[xpt] = atof(yytext);
			}
			INPUT INPUT
			{
				origin[ypt] = atof(yytext);
			}
		;

ExcludeMinorticNumbers:	EXCLUDE MINORTIC NUMBERS
			{
				MinticNos = FALSE;
			}
		;

ExcludeMinortics:	EXCLUDE MINORTICS
			{
				ShowMinTics = FALSE;
			}
		;

ExcludeXNos:		EXCLUDE X NUMBERS
			{
				ShowXNos = FALSE;
			}
		;

ExcludeYNos:		EXCLUDE Y NUMBERS
			{
				ShowYNos = FALSE;
			}
		;

ExcludeXLine:		EXCLUDE X LINE
			{
/* relic of ancient times. Not present in man page */
				ShowXLine = FALSE;
			}
		;

ExcludeYLine:		EXCLUDE Y LINE
			{
/* relic of ancient times. Not present in man page */
				ShowYLine = FALSE;
			}
		;

ExcludeAxes:		EXCLUDE AXES
			{
				ShowAxes = FALSE;
			}
		;

NewCurveCommand:	NEW CURVE 
			{	
				newcurveproc();
			 }
		    ;

ExcludeCurve:		EXCLUDE CURVE
			{
				if (curcur < 0) nocurverr();
				(curves[curcur])->include = FALSE;
				/*may want to do curcur-1 here*/
			}
		    ;

CurveConfidence:	CURVE CONFIDENCE
			{
				if (curcur < 0) nocurverr();
				(curves[curcur])->showConf = TRUE;
			}
		    ;

CurveFontCommand:	CURVE FONT
			{
				if (curcur < 0) nocurverr();
			}
			FONTNAME
			{
				(curves[curcur])->thick = FFthick(yylval);
			}
		    ;

CurveLabelCommand:	CURVE LABEL csentence
			{
/*				strcpy(pstr,yytext);*/
			}
			| CURVE LABEL 
		    ;

csentence:		csentence INPUT 
	    		{
				if (curcur < 0) nocurverr();
				strcat((curves[curcur])->label, yytext);
			}
		    |	INPUT
			{
				if (curcur < 0) nocurverr();
				strcat((curves[curcur])->label, yytext);
			}
		    ;

CurveTypeCommand:	CURVE TYPE
			{
				if (curcur < 0) nocurverr();
			}
			curvetype
		    ;

curvetype:		NONE
			{(curves[curcur])->type = none;}
		    |	SOLID
			{(curves[curcur])->type = solid;}
		    |	DASHES
			{(curves[curcur])->type = dashes;}
		    |	STIPPLE
			{(curves[curcur])->type = stipple;}
		    |	DOTS
			{(curves[curcur])->type = dots;}
		    |	PAT
			{(curves[curcur])->type = pat;}
		    |	FILL
			{
				handlefillproc();
			}
		    |	BOLD
			{
			    (curves[curcur])->type = solid;
			    (curves[curcur])->thick = 
				(curves[curcur])->thick * boldthickmul;
			}
		;


CurveSymbolCommand:	CURVE SYMBOL
			{
				if (curcur < 0) nocurverr();
			}
			symboltype symbolsize
			;

symbolsize:		SIZE INPUT
			{(curves[curcur])->symbolsize = atoi(yytext);}
		|	/* empty */
		;

symboltype:		NONE	
			{(curves[curcur])->symbol = nonesymbol;}
		|	CROSS
			{(curves[curcur])->symbol = cross;}
		|	TRIANGLE
			{(curves[curcur])->symbol = triangle;}
		|	TRIANGLEFILLED
			{(curves[curcur])->symbol = trianglefilled;}
		|	DIAMOND
			{(curves[curcur])->symbol = diamond;}
		|	DIAMONDFILLED
			{(curves[curcur])->symbol = diamondfilled;}
		|	SQUARE
			{(curves[curcur])->symbol = square;}
		|	BOX
			{(curves[curcur])->symbol = square;}
		|	SQUAREFILLED
			{(curves[curcur])->symbol = squarefilled;}
		|	SOLIDBOX
			{(curves[curcur])->symbol = squarefilled;}
		|	RECTANGLE
			{(curves[curcur])->symbol = rectangle;}
		|	RECTANGLEFILLED
			{(curves[curcur])->symbol = rectanglefilled;}
		|	CIRCLE
			{(curves[curcur])->symbol = circle;}
		|	CIRCLEFILLED
			{(curves[curcur])->symbol = circlefilled;}
		|	BULLET
			{(curves[curcur])->symbol = bullet;}
		|	PLUS
			{(curves[curcur])->symbol = plus;}
		|	STAR
			{(curves[curcur])->symbol = star;}
		;

CurveInterpolationCommand:	CURVE INTERPOLATION
			{
				if (curcur < 0) nocurverr();
			}
			interptype
		;

interptype:		LINEAR
			{
				(curves[curcur])->interp = linearinterp;
			}
		|	XHISTOGRAM
			{
				(curves[curcur])->interp = xhistogram;
				keySpacingMul = keySpacingMul ;/*  * 1.5; */
			}
		|	REGRESSION
			{
				(curves[curcur])->interp = lregression;
			}
		|	STEP
			{
				(curves[curcur])->interp = step;
			}
		|	SMOOTH
			{
				(curves[curcur])->interp = smooth;
			}
		|	SPLINE
			{
				(curves[curcur])->interp = smooth;
			}
		|	YHISTOGRAM
			{
				(curves[curcur])->interp = yhistogram;
				keySpacingMul = keySpacingMul;/* * 1.5; */
			}
		;


CurveGrayCommand:	CURVE GRAY INPUT
			{
				if (curcur < 0) nocurverr();
				(curves[curcur])->mat.grayset = TRUE;
				(curves[curcur])->gray = atof(yytext);
			}
		;

CurveExcludeLine:	CURVE EXCLUDE LINE
			{
				if (curcur < 0) nocurverr();
				(curves[curcur])->mat.showline = FALSE;
			}
		;

CurveMatCommand:	CURVE MAT INPUT
			{
				if (curcur < 0) nocurverr();
				(curves[curcur])->mat.matset = TRUE;
				(curves[curcur])->mat.freq = atof(yytext);
			}
			INPUT INPUT
			{
				(curves[curcur])->mat.ang = atof(yytext);
			}
			INPUT INPUT
			{
				(curves[curcur])->mat.indx = atoi(yytext);
			}
		;

NewPointsCommand: 	NEW POINTS 
			{
				if (curcur < 0) nocurverr();
			}
			'\n' sequence		
			;


sequence:		sequence pair 
		|	pair 
		|	'\n'
		;

pair:			INPUT
			{
				addPointsPair1();
			}
			INPUT
			INPUT
			{
				addPointsPair2();
			}
			confInterval
		;

confInterval: 		INPUT INPUT
			{
				addPointsConf();
			}
			'\n'
		| 	'\n'
		;

XLabelCommand:		X LABEL Xsentence
			| X LABEL
		;

Xsentence:		Xsentence INPUT 
			{strcat(axis[xpt].label, yytext);}
		|	INPUT
			{strcat(axis[xpt].label, yytext);}
		;

XFontCommand:		X FONT FONTNAME
			{
				axis[xpt].font = yylval;
			}
		;

XMaximumCommand:	X MAXIMUM INPUT
			{
				axis[xpt].axismax = atof(yytext);
				limits[xpt][maxval] = axis[xpt].axismax;
			}
		;

XMinimumCommand:	X MINIMUM INPUT
			{
				axis[xpt].axismin = atof(yytext);
				limits[xpt][minval] = axis[xpt].axismin;
			}
		;
XUnitCommand:		X UNIT INPUT
			{
				axis[xpt].unit = atof(yytext);
			}
		;

XScaleCommand: 		X SCALE Xwhichscale
		;

Xwhichscale:		LINEAR
			{axis[xpt].scale.type = linear;}
		|	LOGS
			{
				axis[xpt].scale.type = logstype;
				axis[xpt].scale.base = 10.0; /* def logbase */
			}
		;

XLogBaseCommand:	X LOGBASE INPUT
			{
				axis[xpt].scale.base = atof(yytext);
			}
		;


XIntervalCommand:	X INTERVAL INPUT
			{
				axis[xpt].interval = atof(yytext);
			}
		;

XNumberStyleCommand:	X NUMBERSTYLE nxstyle
		;

nxstyle:		INTEGER
			{
				axis[xpt].numberstyle = integer;
			}
		|	FLOATING xsignif
			{
				axis[xpt].numberstyle = floating;
			}
		|	SCIENTIFIC xsignif
			{
				axis[xpt].numberstyle = scientific;
			}
		|	EXPONENT xsignif
			{
				axis[xpt].numberstyle = exponent;
			}
		;

xsignif:		INPUT
			{
				axis[xpt].signif = atof(yytext);
			}
		| 	/* nothing */
			{
				axis[xpt].signif = 1;
			}
		;

YLabelCommand:		Y LABEL Ysentence
			| Y LABEL
		;

Ysentence:		Ysentence INPUT 
			{strcat(axis[ypt].label, yytext);}
		|	INPUT
			{strcat(axis[ypt].label, yytext);}
		;

YFontCommand:		Y FONT FONTNAME
			{
				axis[ypt].font = yylval;
			}
		;

YMaximumCommand:	Y MAXIMUM INPUT
			{
				axis[ypt].axismax = atof(yytext);
				limits[ypt][maxval] = axis[ypt].axismax;
			}
		;

YMinimumCommand:	Y MINIMUM INPUT
			{
				axis[ypt].axismin = atof(yytext);
				limits[ypt][minval] = axis[ypt].axismin;
			}
		;
YUnitCommand:		Y UNIT INPUT
			{
				axis[ypt].unit = atof(yytext);
			}
		;

YScaleCommand: 		Y SCALE Ywhichscale
		;

Ywhichscale:		LINEAR
			{axis[ypt].scale.type = linear;}
		|	LOGS 
			{
				axis[ypt].scale.type = logstype;
				axis[ypt].scale.base = 10.0; /* def logbase */
			}
		;

YLogBaseCommand:	Y LOGBASE INPUT
			{
				axis[ypt].scale.base = atof(yytext);
			}
		;

YIntervalCommand:	Y INTERVAL INPUT
			{
				axis[ypt].interval = atof(yytext);
			}
		;

YNumberStyleCommand:	Y NUMBERSTYLE nystyle
		;

nystyle:		INTEGER
			{
				axis[ypt].numberstyle = integer;
			}
		|	FLOATING ysignif
			{
				axis[ypt].numberstyle = floating;
			}
		|	SCIENTIFIC ysignif
			{
				axis[ypt].numberstyle = scientific;
			}
		|	EXPONENT ysignif
			{
				axis[ypt].numberstyle = exponent;
			}
		;

ysignif:		INPUT
			{
				axis[ypt].signif = atof(yytext);
			}
		| 	/* nothing */
			{
				axis[ypt].signif = 1;
			}
		;


%% 

#include "lex.yy.c"


addPointsPair1()
{
	ptPtr = (pointType *)GetSp(sizeof(pointType));
	ptPtr->conf = NoConfInterval; /* initialized */
	if ((curves[curcur])->fstPtr == nil)
	{
		/*means first point in curve */
		(curves[curcur])->fstPtr = ptPtr;
		ptPtr->prvPtr = nil;
	}
	else 
	{
		ptPtr->prvPtr = (curves[curcur])->lstPtr;
		(curves[curcur])->lstPtr->nxtPtr = ptPtr;
	}
	(curves[curcur])->lstPtr = ptPtr;
	ptPtr->nxtPtr = nil;
	(curves[curcur])->lastpoint += 1;
	/* incr point count; after 1st pt is 0 */
	ptPtr->pt[xpt]= atof(yytext);
}

addPointsPair2()
{
	ptPtr->pt[ypt] = atof(yytext);
}

addPointsConf()
{
	ptPtr->conf = atof(yytext);
}

unknowncmderror()
{
	fprintf(stderr,	
		"***splot::Warning: unknown command near line %d\n", lineno);
	fprintf(stderr,"previous text: %s, ",errorpos);
	fprintf(stderr,"current text: %s\n",yytext);
}

newgraphproc()
{
	graph.includekey = FALSE;
	strcpy(graph.title,"\0");
	graph.font = defGraphFont;
	graph.keyfont = defGraphKeyFont;
	graph.key = kboth;
	graph.size[xpt] = defGraphXsize * 2.54;
	graph.size[ypt] = defGraphYsize * 2.54;
	setaxisdefs(xpt);
	setaxisdefs(ypt);
	currSSang = 0.0;
	currSSfnIndex = 0;
	currSSfreq = 30;
}

setaxisdefs(z)
int z;
{
	strcpy(axis[z].label,"\0");
	axis[z].scale.type = linear;
	axis[z].interval = 0.0;
	axis[z].axismax = BIG;
	axis[z].axismin = BIG;
	axis[z].numberstyle = floating;
	axis[z].signif = 0;
	axis[z].unit = 1.0;
	axis[z].font = defAxisFont;
}

newcurveproc()
{
	curcur++;/*go to first empty slot*/
	curves[curcur] = (curvetype *) 
		GetSp(sizeof(curvetype));  
	(curves[curcur])->validcurve = TRUE;
	strcpy((curves[curcur])->label,"\0");
	(curves[curcur])->symbol = nonesymbol;
	(curves[curcur])->symbolsize = defSymbolSize;
	(curves[curcur])->interp = linearinterp;
	(curves[curcur])->type = solid;
	(curves[curcur])->fstPtr = nil;
	(curves[curcur])->lstPtr = nil;
	(curves[curcur])->lastpoint = -1;
	(curves[curcur])->include = TRUE;
	(curves[curcur])->showConf = FALSE;
	(curves[curcur])->thick = defGraphThick;
	(curves[curcur])->gray = 0.0;
	(curves[curcur])->mat.grayset = FALSE;
	(curves[curcur])->mat.freq = 0.0;
	(curves[curcur])->mat.ang = 30.0;
	(curves[curcur])->mat.indx = 0;
	(curves[curcur])->mat.matset = FALSE;
	(curves[curcur])->mat.showline = TRUE;
	/* bounding curve appears by default */
}

handlefillproc()
{
	currSSang += 45.0; 
	/* rotate 45 degrees for each new curve */
	if (currSSang > 181.0) 
	{
		currSSang = 45.0;
		currSSfnIndex += 1;
		if (currSSfnIndex == MAXSSFNS)
		{
			currSSfnIndex = 0;
			currSSfreq += 15.0;
			if (currSSfreq > 61.0)
			{
				currSSfreq = 5.0;
			}
		}
	}
	(curves[curcur])->type = fill;
	/* bounding curve true by default */
	if ((!(curves[curcur])->mat.grayset))
		(curves[curcur])->gray = defFillGray;
	if ((!(curves[curcur])->mat.matset))
	{
	    (curves[curcur])->mat.freq = currSSfreq;
	    (curves[curcur])->mat.ang = currSSang;
	    (curves[curcur])->mat.indx= currSSfnIndex;
	}
}

nocurverr()
{
	fprintf(stderr,
		"splot error: no new curve command, near line %d\n", lineno);
}

notexterr()
{
	fprintf(stderr,
	"***splot warning: error on line %d, no text entered yet!\n", lineno);
}

newtextproc()
{
	curtext++;
	text[curtext] = (texttype *) GetSp(sizeof(texttype));
	(text[curtext])->font = defTextFont;
	(text[curtext])->angle = 0;
	(text[curtext])->include = TRUE;
	(text[curtext])->validtext = TRUE;
}
