/* pbmmake.c - create a blank bitmap of a specified size
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    bit color, gray, rowcolor, **bits;
    int argn, rows, cols, row, col;
    char *usage = "usage:  %s [-0]/[-w]/[-1]/[-b]/[-g] <width> <height>\n";

    argn = 1;
    color = 0;
    gray = 0;

    /* Check for flags. */
    if ( argn < argc )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( ( argv[argn][1] == '0' || argv[argn][1] == 'w' ||
		   argv[argn][1] == 'W' ) && argv[argn][2] == '\0' )
		color = 0;
	    else if ( ( argv[argn][1] == '1' || argv[argn][1] == 'b' ||
			argv[argn][1] == 'B' ) && argv[argn][2] == '\0' )
		color = 1;
	    else if ( ( argv[argn][1] == 'g' || argv[argn][1] == 'G' ) &&
		      argv[argn][2] == '\0' )
		gray = 1;
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    argn++;
	    }
	}

    if ( argn == argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    if ( sscanf( argv[argn], "%d", &cols ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    argn++;
    if ( argn == argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    if ( sscanf( argv[argn], "%d", &rows ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    argn++;

    if ( argn != argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    bits = pbm_allocarray( cols, rows );

    if ( gray )
	rowcolor = 0;  /* arbitrarily make the corner white */
    for ( row = 0; row < rows; row++ )
	{
	if ( gray )
	    {
	    color = rowcolor;
	    rowcolor = 1 - rowcolor;
	    }
        for ( col = 0; col < cols; col++ )
	    {
	    bits[row][col] = color;
	    if ( gray )
		color = 1 - color;
	    }
	}

    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }
