/* pbmfliptb.c - read a portable bitmap and flip it top for bottom
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits, b;
    int rows, cols, row, col;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );

    for ( row = 0; row < rows / 2; row++ )
        for ( col = 0; col < cols; col++ )
	    {
	    b = bits[row][col];
	    bits[row][col] = bits[rows-row-1][col];
	    bits[rows-row-1][col] = b;
	    }

    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }
