/* macptopbm.c - read a MacPaint file and produce a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <sys/types.h>
#include "pbm.h"
#include "macp.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    unsigned char Pic[MAX_LINES][BYTES_WIDE];
    bit **bits;
    int scanLine, rows, cols, row, bcol, i;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage: %s [macpfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
	ifd = fopen( argv[1], "r" );
	if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    if ( ReadMacPaintFile( ifd, &scanLine, Pic ) < 0 )
	{
	fprintf( stderr, "%s: can't load.\n", argv[1] );
	exit( 1 );
	}

    if ( ifd != stdin )
	fclose( ifd );

    cols = BYTES_WIDE * 8;
    rows = scanLine;
    bits = pbm_allocarray( cols, rows );

    for ( row = 0; row < rows; row++ )
	for ( bcol = 0; bcol < BYTES_WIDE; bcol++ )
	    for ( i = 0; i < 8; i++ )
		bits[row][bcol * 8 + i] = ( (Pic[row][bcol] >> (7 - i)) & 1);

    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }

/*
** Some of the following routine is:
**
**                Copyright 1987 by Patrick J. Naughton
**                         All Rights Reserved
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation.
*/

int
ReadMacPaintFile( file, scanLineP, Pic )
FILE *file;
int *scanLineP;
unsigned char Pic[MAX_LINES][BYTES_WIDE];
    {
    unsigned int i, j, k;
    unsigned char ch;

    /* Skip over the header. */
    for ( i = 0; i < HEADER_LENGTH; i++ )
	getc( file );

    *scanLineP = 0;
    k = 0;

    while ( *scanLineP < MAX_LINES )
	{
	ch = (unsigned char) getc( file );	/* Count byte */
	i = (unsigned int) ch;
	if ( ch < 0x80 )
	    {	/* Unpack next (I+1) chars as is */
	    for ( j = 0; j <= i; j++ )
		if ( *scanLineP < MAX_LINES )
		    {
		    Pic[*scanLineP][k++] = (unsigned char) getc( file );
		    if ( ! (k %= BYTES_WIDE) )
			*scanLineP += 1;
		    }
	    }
	else
	    {	/* Repeat next char (2's comp I) times */
	    ch = getc( file );
	    for ( j = 0; j <= 256 - i; j++ )
		if ( *scanLineP < MAX_LINES )
		    {
		    Pic[*scanLineP][k++] = (unsigned char) ch;
		    if ( ! (k %= BYTES_WIDE) )
			*scanLineP += 1;
		    }
	    }
	}

    return(0);
    }
