/* brushtopbm.c - read a doodle brush file and write a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits, getbit();
    int rows, cols, padright, row, col;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [brushfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    getinit( ifd, &cols, &rows );

    bits = pbm_allocarray( cols, rows );

    /* Compute padding to round cols up to the next multiple of 16. */
    padright = ( ( cols + 15 ) / 16 ) * 16 - cols;

    for ( row = 0; row < rows; row++ )
	{
	/* Get data. */
        for ( col = 0; col < cols; col++ )
	    bits[row][col] = getbit( ifd );
	/* Discard line padding. */
        for ( col = 0; col < padright; col++ )
	    (void) getbit( ifd );
	}

    if ( ifd != stdin )
	fclose( ifd );
    
    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }


int item, bitsperitem, bitshift;

getinit( file, colp, rowp )
FILE *file;
int *colp, *rowp;
    {
    int i;

    if ( getc( file ) != 1 )
	{
	fprintf( stderr, "Bad magic number 1.\n" );
	exit( 1 );
	}
    if ( getc( file ) != 0 )
	{
	fprintf( stderr, "Bad magic number 2.\n" );
	exit( 1 );
	}
    *colp = getc( file ) << 8;
    *colp += getc( file );
    *rowp = getc( file ) << 8;
    *rowp += getc( file );
    bitsperitem = 8;

    /* Junk rest of header. */
    for ( i = 0; i < 10; i++ )  /* 10 is just a guess at the header size */
	(void) getc( file );
    }

bit
getbit( file )
FILE *file;
    {
    bit b;

    if ( bitsperitem == 8 )
	{
	item = getc( file );
	bitsperitem = 0;
	bitshift = 7;
	}
    bitsperitem++;
    b = 1 - ( ( item >> bitshift) & 1 );
    bitshift--;
    return b;
    }
