/*
 * grXInt.h --
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * Internal definitions for grX[1..5].c.
 *
 * sccsid "@(#)grXInt.h	3.11 MAGIC (Berkeley) 3/12/85"
 *
 * NOTE:  In order for the these defs to work correctly, this file
 * (grXInt.h) must be included after all the Magic .h files and before
 * the X .h files.
 *
 */

/**** Modifications by Dave Durfee and Markus G. Wloka
***** Copyright (C) 1987 Brown University		
****/

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/

/* (dad) BRUNIX  - want to allow X to use normal malloc stuff */
#undef malloc
#undef free
#undef calloc

/* (dad) BRUNIX - added stuff so you can use on b&w and 4bit also */
#define ANY_DISPLAY
#define MGW_GRID_LINES

/* (papa) - enable X11 stuff */
#define X11

/* Constants
 */
#define MAX_CURSORS	32	/* Maximum number of programmable cursors */
#define CHARPAD 	1	/* 1 pixel for intercharacter spacing */
#define BRUSHHEIGHT	1	/* line height */
#define BRUSHWIDTH	1	/* line width */

#define true		1
#define false		0

#undef TRUE

/* Macros for conversion between X and Magic coordinates
 */
#define grMagicToX(y) ( DisHeight - ( y ) )
#define grXToMagic(y) ( DisHeight - ( y ) )

/* Redefine data types so that Magic's names don't conflict with X's names.
 */
typedef Window MagicWindow; /* Name for Magic's def of a window. */
#define Window XWindow	    /* Name for X's def or a window. */
			    /* From now on, referring to "Window" will
			     * use X's definitioin.
			     */

/* Current settings for X function parameters */
typedef struct {
    long /*BitMap*/	clipmask;
    long /*Cursor*/	cursor;
    long /*Font*/	font;
    int 		fontSize;
    char /*Pattern*/	pattern[2];
    int 		pixel;
    int 		planes;
    long /*PixMap*/	tile;
    long /*Window*/	window;
    int maskmod;
} GR_CURRENT;

extern GR_CURRENT grCurrent;
extern int  grPixels[];
extern char grStipples[] [8];
extern int  grCurrent_stipple;
extern int  DisHeight;
extern int  DisWidth;

extern bool grxGetCursorPos();
extern bool grxDrawGrid();
extern Void GrXEnableTablet();
extern Void GrXDisableTablet();
extern Void GrXSetCMap();
extern Void grxPutText();
extern Void grxDefineCursor();
extern Void GrXSetCursor();
extern Void GrXTextSize();
extern Void GrXDrawGlyph();
extern Void GrXBitBlt();
extern Void NullBitBlt();
extern int  GrXReadPixel();
extern Void grxDrawLine();
extern Void grxSetLineStyle();
extern Void grxSetCharSize();
extern Void grxSetWMandC();
extern Void grxFillRect();


