/* grX3.c -
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * This file contains additional functions to manipulate an X window system
 * color display.  Included here are device-dependent routines to draw and
 * erase text and draw a grid.
 *
 */

/**** Modifications by Dave Durfee and Markus G. Wloka
***** Copyright (C) 1987 Brown University
****/

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/

#ifndef lint
static char sccsid[] = "@(#)grX3.c	4.4 MAGIC (Berkeley) 8/15/85";
#endif	not lint

#include <stdio.h>
#include "magic.h"
#include "geometry.h"
#include "graphics.h"
#include "windows.h"
#include "graphicsInt.h"
#include "textio.h"
#include "signals.h"
#include "grXInt.h"
#include <X11/Xlib.h>
#include <X11/X10.h>
#include "grX11.h"

/* locals */

static XFontStruct *grSmallFont, *grMediumFont, *grLargeFont, *grXLargeFont;
#define DEFAULT_FONT "9x15"
#define GR_PGMNAME "magic"


/*---------------------------------------------------------
 * grxDrawGrid:
 *	grxDrawGrid adds a grid to the grid layer, using the current
 *	write mask and color.
 *
 * Results:
 *	TRUE is returned normally.  However, if the grid gets too small
 *	to be useful, then nothing is drawn and FALSE is returned.
 *
 * Side Effects:    None.
 *---------------------------------------------------------
 */

    XSegment vlist[GR_NUM_GRIDS];

bool
grxDrawGrid (r, outline, clip)
    Rect *r;			/* A rectangle that forms the template
				 * for the grid.  Note:  in order to maintain
				 * precision for the grid, the rectangle
				 * coordinates are specified in units of
				 * screen coordinates multiplied by 4096.
				 */
    int outline;		/* the outline style */
    Rect *clip; 		/* a clipping rectangle */
{
    int xsize, ysize;
    int x, y, x1, y1;
    int xstart, ystart;

    xsize = r->r_xtop - r->r_xbot;
    ysize = r->r_ytop - r->r_ybot;
    if (GRID_TOO_SMALL(xsize, ysize, GR_NUM_GRIDS)) return false;
    xstart = r->r_xbot % xsize;
    while (xstart < clip->r_xbot<<12) {
	xstart += xsize;
    }
    ystart = r->r_ybot % ysize;
    while (ystart < clip->r_ybot<<12) {
	ystart += ysize;
    }

/* mgw make real lines, which is a lot faster */

/** mgw  vertical lines **/
{
    int n ;
    int x2 , y2 ;

    n = 0 ;
    y1 = grMagicToX( clip->r_ybot );
    y2 = grMagicToX( clip->r_ytop ) ;

    for ( x = xstart ; x < (clip->r_xtop+1)<<12; x += xsize)
    {
	x1 = x >> 12;
	vlist[n].x1 = x1 ;
	vlist[n].y1 = y1 ;
	vlist[n].x2 = x1 ;
	vlist[n].y2 = y2 ;
	n++;
	if (n >= GR_NUM_GRIDS)
	   break ;
    }

    /* set graphics context */
    XSetLineAttributes(display, defGC, 0, LineSolid, CapButt, JoinMiter);
    XSetFillStyle(display, defGC, FillSolid);	/* ???? */
    XDrawSegments(display, grCurrent.window, defGC, vlist, n);
    n = 0;

/** mgw  horizontal lines */

    x1 = clip->r_xbot ;
    x2 = clip->r_xtop ;

    for (y = ystart; y < (clip->r_ytop+1)<<12; y += ysize)
    {
	y1 = grMagicToX( y >> 12 );
	vlist[n].x1= x1 ;
	vlist[n].y1 = y1 ;
	vlist[n].x2 = x2 ;
	vlist[n].y2 = y1 ;
	n++;
	if (n >= GR_NUM_GRIDS)
	   break ;
    }
    XDrawSegments(display, grCurrent.window, defGC, vlist, n);
}
    return true;
}


/*---------------------------------------------------------
 * grxLoadFont
 *	This local routine loads the X fonts used by Magic.
 *
 * Results:	None.
 *
 * Side Effects:    None.
 *---------------------------------------------------------
 */

char *smallfont = NULL;
char *mediumfont = NULL;
char *largefont = NULL;
char *xlargefont = NULL;

Void
grxLoadFont()
{
    smallfont = XGetDefault(display, GR_PGMNAME, "small");
    if (!smallfont) smallfont = XGetDefault(display, GR_PGMNAME, "Small");
    mediumfont = XGetDefault(display, GR_PGMNAME, "medium");
    if (!mediumfont) mediumfont = XGetDefault(display, GR_PGMNAME, "Medium");
    largefont = XGetDefault(display, GR_PGMNAME, "large");
    if (!largefont) largefont = XGetDefault(display, GR_PGMNAME, "Large");
    xlargefont = XGetDefault(display, GR_PGMNAME, "xlarge");
    if (!xlargefont) xlargefont = XGetDefault(display, GR_PGMNAME, "Xlarge");

    if (smallfont) {
	if( ( grSmallFont = XLoadQueryFont(display, smallfont ) ) == NULL ) {
		TxError( "%s %s\n", "grxLoadFont: Unable to load",smallfont);
		grSmallFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    } else {
	if( ( grSmallFont = XLoadQueryFont(display, "6x10" ) ) == NULL ) {
		TxError( "%s\n", "grxLoadFont: Unable to load 6x10" );
		grSmallFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    }

    if (mediumfont) {
	if( ( grMediumFont = XLoadQueryFont(display, mediumfont ) ) == NULL ) {
		TxError( "%s %s\n", "grxLoadFont: Unable to load",mediumfont);
		grMediumFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    } else {
	if( ( grMediumFont = XLoadQueryFont(display, "6x13" ) ) == NULL ) {
		TxError( "%s\n", "grxLoadFont: Unable to load 6x13" );
		grMediumFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    }

    if (largefont) {
	if( ( grLargeFont = XLoadQueryFont(display, largefont ) ) == NULL ) {
		TxError( "%s %s\n", "grxLoadFont: Unable to load",largefont);
		grLargeFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    } else {
	if( ( grLargeFont = XLoadQueryFont(display, "8x13" ) ) == NULL ) {
		TxError( "%s\n", "grxLoadFont: Unable to load 8x13" );
		grLargeFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    }

    if (xlargefont) {
	if( ( grXLargeFont = XLoadQueryFont(display, xlargefont ) ) == NULL ) {
		TxError( "%s %s\n", "grxLoadFont: Unable to load",xlargefont);
		grXLargeFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    } else {
	if( ( grXLargeFont = XLoadQueryFont(display, "9x15" ) ) == NULL ) {
		TxError( "%s\n", "grxLoadFont: Unable to load 9x15" );
		grXLargeFont = XLoadQueryFont(display, DEFAULT_FONT);
	};
    }
}


/*---------------------------------------------------------
 * grxSetCharSize:
 *	This local routine sets the character size in the display,
 *	if necessary.
 *
 * Results:	None.
 *
 * Side Effects:    None.
 *---------------------------------------------------------
 */

Void
grxSetCharSize (size)
    int size;		/* Width of characters, in pixels (6 or 8). */
{
    grCurrent.fontSize = size;
    switch (size)
    {
	case GR_TEXT_DEFAULT:
	case GR_TEXT_SMALL:
	    grCurrent.font = grSmallFont->fid;
	    break;
	case GR_TEXT_MEDIUM:
	    grCurrent.font = grMediumFont->fid;
	    break;
	case GR_TEXT_LARGE:
	    grCurrent.font = grLargeFont->fid;
	    break;
	case GR_TEXT_XLARGE:
	    grCurrent.font = grXLargeFont->fid;
	    break;
	default:
	    TxError("%s%d\n", "grxSetCharSize: Unknown character size ",
		size );
	    break;
    }
}


/*
 * ----------------------------------------------------------------------------
 * grxGetCharSize:
 *	Compute the size of a character and related parameters.
 *	This is only used by the routines xPutText and XTextSize.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	All parameters are modified, except the first.
 * ----------------------------------------------------------------------------
 */
Void
grxGetCharSize (charSize, width, above, below)
    int charSize;	/* the character size (small, medium, etc.) */
    int *width; 	/* Filled in with the width of a character, in pixels */
    int *above; 	/* Filled in with the number of pixels above the
			 * baseline of a character.
			 */
    int *below; 	/* Filled in with the number of pixels below the
			 * baseline (decenders).
			 */
{
    
    switch (charSize)
    {
	case GR_TEXT_DEFAULT:
	case GR_TEXT_SMALL:
	    *width = grSmallFont->max_bounds.width;
	    *above = grSmallFont->ascent;
	    *below = grSmallFont->descent;
	    break;
	case GR_TEXT_MEDIUM:
	    *width = grMediumFont->max_bounds.width;
	    *above = grMediumFont->ascent;
	    *below = grMediumFont->descent;
	    break;
	case GR_TEXT_LARGE:
	    *width = grLargeFont->max_bounds.width;
	    *above = grLargeFont->ascent;
	    *below = grLargeFont->descent;
	    break;
	case GR_TEXT_XLARGE:
	    *width = grXLargeFont->max_bounds.width;
	    *above = grXLargeFont->ascent;
	    *below = grXLargeFont->descent;
	    break;
	default:
	    TxError("%s%d\n", "grxGetCharSize: Unknown character size ",
		charSize );
	    break;
    }
}


/*
 * ----------------------------------------------------------------------------
 * GrXTextSize --
 *
 *	Determine the size of a text string.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	A rectangle is filled in that is the size of the text in pixels.
 *	The origin (0, 0) of this rectangle is located on the baseline
 *	at the far left side of the string.
 * ----------------------------------------------------------------------------
 */

Void
GrXTextSize(text, size, r)
    char *text;
    int size;
    Rect *r;
{
    int direct, ascent, descent;
    XCharStruct overall;

    switch (size)
    {
	case GR_TEXT_DEFAULT:
	case GR_TEXT_SMALL:
	    XTextExtents(grSmallFont,text, strlen(text), 
		&direct, &ascent, &descent, &overall);
	    break;
	case GR_TEXT_MEDIUM:
	    XTextExtents(grMediumFont,text, strlen(text), 
		&direct, &ascent, &descent, &overall);
	    break;
	case GR_TEXT_LARGE:
	    XTextExtents(grLargeFont,text, strlen(text), 
		&direct, &ascent, &descent, &overall);
	    break;
	case GR_TEXT_XLARGE:
	    XTextExtents(grXLargeFont,text, strlen(text), 
		&direct, &ascent, &descent, &overall);
	    break;
	default:
	    TxError("%s%d\n", "GrXTextSize: Unknown character size ",
		size );
	    break;
    }
    r->r_xbot = 0;
    r->r_ybot = -overall.descent;
    r->r_xtop = overall.rbearing - overall.lbearing;
    r->r_ytop = overall.ascent;
}


/*
 * ----------------------------------------------------------------------------
 * GrXReadPixel --
 *
 *	Read one pixel from the screen.
 *
 * Results:
 *	An integer containing the pixel's color.
 *
 * Side effects:
 *	none.
 *
 * Note: Can't read a pixel number from the screen in X.  Return the
 *	color 0, the background color.
 *
 * ----------------------------------------------------------------------------
 */

int
GrXReadPixel (w, x, y)
    MagicWindow *w;
    int x,y;		/* the location of a pixel in screen coords */
{
    XImage *image;
    unsigned long value;
    int pixmap_format;
    int offset;
    XWindowAttributes att;

    if (x < 0 || grMagicToX(y) < 0) {
	TxError( "%s\n",
	"To select a color to edit or copy, point INSIDE a Magic window");
	return(0);
    }

    XGetWindowAttributes(display, grCurrent.window, &att);

    if ( x >= att.width || grMagicToX(y) >= att.height) {
	TxError( "%s\n",
	"To select a color to edit or copy, point INSIDE a Magic window");
	return(0);
    }

    pixmap_format = (DisplayPlanes(display, screen) > 1 ? ZPixmap : XYPixmap);

    /* The kludge is needed on RTs with X11.Rel1. Don't know with rel. 2/3.
       Your mileage my vary. */
#define KLUDGE
#ifdef KLUDGE
    if (x>15) offset = 16; else offset = 0;
    image = XGetImage(display, grCurrent.window, x-offset, grMagicToX(y), 32, 1,
		AllPlanes, pixmap_format);
    value = XGetPixel(image, offset, 0);

    value = value >> 24;
#else
    /* this should work on the megapel but it doesn't */
    image = XGetImage(display, grCurrent.window, x, grMagicToX(y), 1, 1,
		AllPlanes, pixmap_format);
    value = XGetPixel(image, 0, 0);
    value = value >> 24;
#endif

    return (value & ~grCurrent.maskmod);
}


/*
 * ----------------------------------------------------------------------------
 * GrXBitBlt --
 *
 *	Copy information from one part of the screen to the other.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	changes the screen.
 * ----------------------------------------------------------------------------
 */

Void
GrXBitBlt(r, p)
    Rect *r;
    Point *p;
{
    XCopyArea( display,
	       grCurrent.window,
	       grCurrent.window,
	       defGC,
	       r->r_xbot, grMagicToX(r->r_ybot),
	       r->r_xtop - r->r_xbot + 1, r->r_ytop - r->r_ybot + 1,
	       p->p_x, grMagicToX(p->p_y));
}


#define GR_DISP_NONE	0
#define GR_DISP_ALL	1
#define GR_DISP_PARTIAL 2

/*---------------------------------------------------------
 * grxPutText:
 *	(modified on SunPutText)
 *
 *	This routine puts a chunk of text on the screen in the current
 *	color, size, etc.  The caller must ensure that it fits on
 *	the screen -- no clipping is done except to the obscuring rectangle
 *	list and the clip rectangle.
 *
 * Results:
 *	none.
 *
 * Side Effects:
 *	The text is drawn on the screen.
 *
 *---------------------------------------------------------
 */

Void
grxPutText (text, pos, clip, obscure)
    char *text; 		/* The text to be drawn. */
    Point *pos; 		/* A point located at the leftmost point of
				 * the baseline for this string.
				 */
    Rect *clip; 		/* A rectangle to clip against */
    LinkedRect *obscure;	/* A list of obscuring rectangles */

{
    Rect location;
    Rect overlap;
    Rect widthHeight;
    LinkedRect *ob;
    int width, height;
    void grGeoSub();

    GrXTextSize( text, grCurrent.fontSize, &widthHeight );
    width = widthHeight.r_xtop;
    height = widthHeight.r_ytop;

    location.r_xbot = pos->p_x + widthHeight.r_xbot;
    location.r_xtop = pos->p_x + width;
    location.r_ybot = pos->p_y + widthHeight.r_ybot;
    location.r_ytop = pos->p_y + height;
    /* erase parts of the bitmap that are obscured */
    for (ob = obscure; ob != NULL; ob = ob->r_next)
    {
	if (GEO_TOUCH(&ob->r_r, &location))
	{
	    overlap = location;
	    GeoClip(&overlap, &ob->r_r);
	    grGeoSub(&location, &overlap);
	}
    }

    overlap = location;
    GeoClip(&overlap, clip);

    /* copy the text to the color screen */
    if ((overlap.r_xbot < overlap.r_xtop)&&(overlap.r_ybot <= overlap.r_ytop))
    {
	XRectangle xr;
	GC textGC;
	XGCValues xgcv;
	unsigned long xgcvm = 0;

	/* local gc */
	textGC = XCreateGC(display, grCurrent.window,xgcvm,&xgcv);

	xr.x = overlap.r_xbot;
	xr.y = grMagicToX(overlap.r_ytop);
	xr.width = overlap.r_xtop - overlap.r_xbot;
	xr.height = overlap.r_ytop - overlap.r_ybot;
	XSetClipRectangles(display,textGC,0, 0, &xr, 1, Unsorted);

        /* set graphics context */
	XSetForeground(display, textGC, grCurrent.pixel);
	XSetPlaneMask(display, textGC, grCurrent.planes);
	XSetFont(display, textGC, grCurrent.font);
	XDrawString(display, grCurrent.window,
		textGC,
		pos->p_x, grMagicToX( pos->p_y ),
		text, strlen(text));
	XFreeGC(display, textGC);
    }
}


/* grGeoSub:
 *	return the tallest sub-rectangle of r not obscured by area
 *	area must be within r.
 */

void
grGeoSub(r, area)
register Rect *r;		/* Rectangle to be subtracted from. */
register Rect *area;		/* Area to be subtracted. */

{
    if (r->r_xbot == area->r_xbot) r->r_xbot = area->r_xtop;
    else
    if (r->r_xtop == area->r_xtop) r->r_xtop = area->r_xbot;
    else
    if (r->r_ybot <= area->r_ybot) r->r_ybot = area->r_ytop;
    else
    if (r->r_ytop == area->r_ytop) r->r_ytop = area->r_ybot;
    else
    r->r_xtop = area->r_xbot;
}
