/* grX2.c -
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * Written in 1985 by Doug Pan and Prof. Mark Linton at Stanford.  Used in the
 * Berkeley release of Magic with their permission.
 *
 * This file contains additional functions to manipulate an X
 * color display.  Included here are rectangle drawing and color map
 * loading.
 *
 */

/**** Modifications by Dave Durfee and Markus G. Wloka
***** Copyright (C) 1987 Brown University		
****/

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/

#ifndef lint
static char sccsid[] = "%W% MAGIC (Berkeley) %G%";
#endif	not lint

#include <stdio.h>
#include "magic.h"
#include "textio.h"
#include "geometry.h"
#include "graphics.h"
#include "windows.h"
#include "graphicsInt.h"
#include "grXInt.h"
#include <X11/Xlib.h>
#include <X11/X10.h>
#include "grX11.h"

static Pixmap grXStippleTiles[GR_NUM_STIPPLES]; /* Tiles with stipple pat. */
static Pixmap grXStippleInvTiles[GR_NUM_STIPPLES];
				/* Tiles with inverted stipple pat. */
static int grXStippleTileValid[GR_NUM_STIPPLES]; /* Starts out all zeros. */
static int allbits;
extern bool firstCall;

extern char grStipples[GR_NUM_STIPPLES][8];


CleanupStippleTiles()
{
    int i;

    grCurrent_stipple = 0;
    for (i=0;i<GR_NUM_STIPPLES;i++)
    {
	grXStippleTiles[i] = NULL;
	grXStippleInvTiles[i] = NULL;
	grXStippleTileValid[i] = 0;
    }
}


/*---------------------------------------------------------
 * GrXSetCMap:
 *	XSetCMap outputs new values to the X color map.
 *
 * Results:	None.
 *
 * Side Effects:
 *	The values in the color map are set from the array indicated
 *	by pmap.
 *
 * Errors:		None.
 *
 * Note:
 *	In X, we can only allocate 253 color cells.  Since the
 *	Magic colors 128 - 255 are the same, they all share the
 *	same X pixel id and tile id.  Hence, only 129 colors are
 *	allocated.
 *---------------------------------------------------------
 */	

/********     mgw   massively rewrote this routine
*********     Display can have 1 , 4 , 6 , 7, 8 bit planes.
*********     REMEMBER: if masks are used, the pixels returned by
*********     XGetColorCells must start at 0 or 128 AND be contiguous.
********/

Void
GrXSetCMap (pmap)
    char *pmap; 		/* A pointer to 256*3 bytes containing the
				 * new values for the color map.  The first
				 * three values are red, green, and blue
				 * intensities for color 0, and so on.
				 */
{
    static unsigned int NCOLORS ;
    int bits;
    XColor colors[ 256 ];	/* Unique colors used by Magic */
    static unsigned long pixels[ 256];		/* Pixel id's */
    char *p;			/* Pointer into the Magic color map. */
    int i , j ; 		/* Indices */
    unsigned long planes[1];	/* Plane mask returned by Xlib */

    bits = DisplayPlanes(display,screen);

    if( firstCall )
    {
	cmap = XCreateColormap(display,grCurrent.window,visual,AllocNone);

	if (bits < 4)
	{
	    NCOLORS = 2;
	    allbits = 1;
	}
	else if (bits < 6)
	{
	    NCOLORS = 16;
	    allbits = 15;
	}
	else if (bits < 7)
	{
	    NCOLORS = 64;
	    allbits = 63;
	}
	else
	{
	    NCOLORS = 128;
	    allbits = 127;
	}

/*  mgw  for 8bit displays, use upper 128 colors */
	if(bits >= 8)
	{
	    unsigned int NC ;
	    int start ;
	    NC = 256 ;
	    if (XAllocColorCells(display,cmap,True,planes,0,pixels,NC) == 0) {
		TxError("GrXSetCMap could not allocate %d color cells\n",NC);
		return false;
	    }

	    for(i=0 ; i<128 ; i++) {
	       colors[i].pixel = i;
	    }

	    /* get default lower region 128 colors */
	    XQueryColors(display, DefaultColormap(display, 
		DefaultScreen(display)), colors, 128);

	    /* copy upper region of colormap to lower region */
	    start = 128;		/* or 0 ???? */
 	    for (i=0;i<128;i++)
	      pixels[i] = pixels[start + i];
	}
	else	/* bits < 8 */
	{
	  if (XAllocColorCells(display,cmap,True,planes,0,pixels,NCOLORS) == 0)
	  {
fprintf(stderr, "GrXSetCMap  I could not grab") ;
fprintf(stderr," %d colors\n", NCOLORS );
fprintf(stderr,"You are wasting colors, remove some windows\n" ) ;
		GrXClose() ;
		return false ;
	  }
	for(i = 0 ; i < NCOLORS ; i++ )
	    if( i != (pixels[i] % 128))
	    {
		fprintf(stderr, "GrXSetCMap  Magic bug\n" ) ;
		fprintf(stderr," X did not give me   pixels[i] = i\n" ) ;
		GrXClose() ;
		return false ;
	    }
	}
    }

    /* Define colors
     */
    p = pmap;

    if (bits >= 8) {
	    if (!firstCall) {
		/* Note: on some servers it is MUCH faster to use a new
		   colormap instead of reloading the old one. Grrrr. :-)
		   Also, I don't free the old colormap, otherwise the
		   screen will flash */
		cmap = XCreateColormap(display,grCurrent.window,visual,AllocAll);
	    }
	    for(i=0 ; i<128 ; i++) {
	       colors[i].pixel = i;
	    }

	    /* get default lower region 128 colors */
	    XQueryColors(display, DefaultColormap(display, 
		DefaultScreen(display)), colors, 128);

	    for( i = 128; i < 256; i++)
	    {
		colors[ i ].pixel = i ;
		colors[ i ].red = *p++ << 8;
		colors[ i ].green = *p++ << 8;
		colors[ i ].blue = *p++ << 8;
		colors[ i ].flags = DoRed+DoGreen+DoBlue;
	    }
	    XStoreColors(display,cmap,&colors[0], 256 );
    } else {
	    for( i = 0; i < NCOLORS; i++)
	    {
		colors[ i ].pixel = pixels[i] ;
		colors[ i ].red = *p++ << 8;
		colors[ i ].green = *p++ << 8;
		colors[ i ].blue = *p++ << 8;
		colors[ i ].flags = DoRed+DoGreen+DoBlue;
	    }
	    XStoreColors(display,cmap,&colors[0],NCOLORS );
    }

    {
    XSetWindowAttributes atts;
    atts.colormap = cmap;
    XChangeWindowAttributes(display,grCurrent.window,CWColormap,&atts);
    XInstallColormap(display,cmap);
    }
/*********
	       Pixmaps are only allocated once.
*********/
    if( firstCall )
    {				     /* Assign to grPixels[] and grTiles[]   */
	for( i = 0; i < NCOLORS ; i++ )
	{
	    grPixels[ i ] = pixels[ i ] ;
	    grTiles[ i ] = MakeTile( grPixels [ i ] );
	    if( grTiles[ i ] == NULL )
	    {
		TxError( "%s\n", "grX2.GrXSetCMap: Failed to obtain tiles.");
		GrXClose() ;
		return false;
	    }
	}
	for( j = 1; j < 256 / NCOLORS; j++ )
	for( i = 0; i < NCOLORS ; i++ )
	{
	    grPixels[ j * NCOLORS + i ] = grPixels[ i ] ;
	    grTiles [ j * NCOLORS + i ] = grTiles [ i ] ;
	}
    } /* if firstcall */
    firstCall = false;
}

Void
GrXSetBW()
{
    static unsigned int NCOLORS ;
    static unsigned long pixels[ 256];		/* Pixel id's */
    int i , j ; 		/* Indices */

    NCOLORS = 2;
    allbits = 1;

    pixels[0] = BlackPixel(display,DefaultScreen(display));
    pixels[1] = WhitePixel(display,DefaultScreen(display));

    if( firstCall )
    {				     /* Assign to grPixels[] and grTiles[]   */
	for( i = 0; i < NCOLORS ; i++ )
	{
	    grPixels[ i ] = pixels[ i ] ;
	    grTiles[ i ] = MakeTile( grPixels [ i ] );
	    if( grTiles[ i ] == NULL )
	    {
		TxError( "%s\n", "GrXSetBW: Failed to obtain tiles.");
		GrXClose() ;
		return false;
	    }
	}
	for( j = 1; j < 256 / NCOLORS; j++ )
	for( i = 0; i < NCOLORS ; i++ )
	{
	    grPixels[ j * NCOLORS + i ] = grPixels[ i ] ;
	    grTiles [ j * NCOLORS + i ] = grTiles [ i ] ;
	}
    } /* if firstcall */
    firstCall = false;
}



/*---------------------------------------------------------
 * grxDrawLine:
 *	This routine draws a line.
 *
 * Results:	None.
 *
 * Side Effects:
 *	Draw a line for (x1, y1) to (x2, y2) inclusive.
 *	X window coordinates start from the UPPER left corner,
 *	so the Magic y-coordinates need to be inverted using the
 *	macro grMagicToX().
 *---------------------------------------------------------
 */

Void
grxDrawLine (x1, y1, x2, y2)
    int x1, y1; 		/* Screen coordinates of first point. */
    int x2, y2; 		/* Screen coordinates of second point. */
{
    XDrawLine(display,
		grCurrent.window,
		defGC,
		x1, grMagicToX(y1), x2, grMagicToX(y2));
}


/*---------------------------------------------------------
 * grXMakeStippleTile:
 *	Turn Magic's stipple pattern into an X tile.
 *
 * Results:	None.
 *
 * Side Effects:
 *	Fills in an entry in grXStippleTileValid[] and
 *	in grXStippleTiles.
 *---------------------------------------------------------
 */

void
grXMakeStippleTile(stipnum)
    int stipnum;		/* Stipple number. */
{
    short data[16];
    int y;
    int row;

    for (y = 0; y < 8; y++)
    {
	row = grStippleTable[stipnum][y];
	if (allbits != 1) row = ~row;
	data[y] = (row & 0xFF) | ((row & 0xFF) << 8);
    }
    for (y = 8; y < 16; y++)
    {
	data[y] = data[y - 8];
    }
#ifndef ANY_DISPLAY /* who says there has to be color 127 */
    grXStippleTiles[stipnum] =
	MakePixmap1(display, data, 16, 16, 127, 0);
    grXStippleInvTiles[stipnum] =
	MakePixmap1(display, data, 16, 16, 0, 127);
    grXStippleTileValid[stipnum] = 1;
#else
    grXStippleTiles[stipnum] =
	MakePixmap1(display, data, 16, 16, allbits, 0);
    grXStippleInvTiles[stipnum] =
	MakePixmap1(display, data, 16, 16, 0, allbits);
    grXStippleTileValid[stipnum] = 1;
#endif
    /* XFreePixmap(display, stipbits); ????????? */
}

/*
 * XMakePixmap (like X10) -- uses default depth
 */

Pixmap
MakePixmap(dpy,data,width,height, fore, back)
Display *dpy;
short *data;
unsigned int width, height;
unsigned long fore, back;
{
	XImage ximage;
	GC pgc;
	XGCValues gcv;
	Pixmap pid;

	pid = XCreatePixmap(dpy, RootWindow(dpy, DefaultScreen(dpy)),
		width, height, DefaultDepth(dpy, DefaultScreen(dpy)));
	gcv.foreground = fore;
	gcv.background = back;
	pgc = XCreateGC(dpy, pid, GCForeground | GCBackground, &gcv);
	ximage.height = height;
	ximage.width = width;
	ximage.xoffset = 0;
	ximage.format = XYBitmap;
	ximage.data = (char *) data;
	ximage.byte_order = LSBFirst;
	ximage.bitmap_unit = 16;
	ximage.bitmap_bit_order = LSBFirst;
	ximage.bitmap_pad = 16;
	ximage.bytes_per_line = (width+15)/16 * 2;
	ximage.depth = 1;

	XPutImage(dpy, pid, pgc, &ximage, 0, 0, 0, 0, width, height);
	XFreeGC(dpy, pgc);
	return(pid);
}

/*
 * XMakePixmap1 (like X10) -- uses depth 1
 */

Pixmap
MakePixmap1(dpy,data,width,height, fore, back)
Display *dpy;
short *data;
unsigned int width, height;
unsigned long fore, back;
{
	XImage ximage;
	GC pgc;
	XGCValues gcv;
	Pixmap pid;

	pid = XCreatePixmap(dpy, RootWindow(dpy, DefaultScreen(dpy)),
		width, height, 1);
	gcv.foreground = fore;
	gcv.background = back;
	pgc = XCreateGC(dpy, pid, GCForeground | GCBackground, &gcv);
	ximage.height = height;
	ximage.width = width;
	ximage.xoffset = 0;
	ximage.format = XYBitmap;
	ximage.data = (char *) data;
	ximage.byte_order = LSBFirst;
	ximage.bitmap_unit = 16;
	ximage.bitmap_bit_order = LSBFirst;
	ximage.bitmap_pad = 16;
	ximage.bytes_per_line = (width+15)/16 * 2;
	ximage.depth = 1;

	XPutImage(dpy, pid, pgc, &ximage, 0, 0, 0, 0, width, height);
	XFreeGC(dpy, pgc);
	return(pid);
}

Pixmap
MakePixmap2(dpy,data,width,height, fore)
Display *dpy;
short *data;
unsigned int width, height;
unsigned long fore;
{
	XImage ximage;
	GC pgc;
	XGCValues gcv;
	Pixmap pid;

	pid = XCreatePixmap(dpy, RootWindow(dpy, DefaultScreen(dpy)),
		width, height, 1);
	gcv.foreground = fore;
	pgc = XCreateGC(dpy, pid, GCForeground, &gcv);
	ximage.height = height;
	ximage.width = width;
	ximage.xoffset = 0;
	ximage.format = XYBitmap;
	ximage.data = (char *) data;
	ximage.byte_order = LSBFirst;
	ximage.bitmap_unit = 8;
	ximage.bitmap_bit_order = LSBFirst;
	ximage.bitmap_pad = 8;
	ximage.bytes_per_line = (width+7)>>3;
	ximage.depth = 1;

	XPutImage(dpy, pid, pgc, &ximage, 0, 0, 0, 0, width, height);
	XFreeGC(dpy, pgc);
	return(pid);
}

/*
 * XMakeTile (like X10)
 */

Pixmap
MakeTile(pixel)
unsigned long pixel;
{
	GC pgc;
	XGCValues gcv;
	Pixmap pid;

	pid = XCreatePixmap(display, RootWindow(display, DefaultScreen(display)),
#ifdef ONEPLANETILE
		16, 16, 1);
#else
		16, 16, DefaultDepth(display, DefaultScreen(display)));
#endif
	gcv.foreground = pixel;
	gcv.fill_style = FillSolid;
	pgc = XCreateGC(display, pid, GCForeground | GCFillStyle, &gcv);

	XFillRectangle(display, pid, pgc, 0, 0, 16, 16);
	XFreeGC(display, pgc);
	return(pid);
}


/*---------------------------------------------------------
 * grxFillRect:
 *	This routine draws a solid rectangle.
 *
 * Results:	None.
 *
 * Side Effects:
 *	A solid rectangle is drawn in the current color and
 *	using the current write mask.  This is an internal
 *	routine used by grFastBox.
 *---------------------------------------------------------
 */

Void
grxFillRect (r)
    register Rect *r;	/* Address of a rectangle in screen
			 * coordinates.
			 */
{
   if( grCurrent_stipple == 0 ) {
	/* Just draw a filled rectangle */
	XSetFillStyle(display, defGC, FillTiled);
	XSetTile(display, defGC, grCurrent.tile);
	XFillRectangle( display,
	    grCurrent.window,
	    defGC,
	    r->r_xbot, grMagicToX( r->r_ytop ),
	    r->r_xtop - r->r_xbot + 1, r->r_ytop - r->r_ybot + 1
	);
    } else {
	int setones, setzeros;
        /* Create our stipple tile if we don't have one already. */
	if (grXStippleTileValid[grCurrent_stipple] == 0)
	    grXMakeStippleTile(grCurrent_stipple);
	setones = (grCurrent.planes & grCurrent.pixel);     /* Bits to set. */
	setzeros = (grCurrent.planes & (~grCurrent.pixel)); /* Bits to clr. */
	/* First, fill in the 1's */
	if (setones != 0)
	{
        XSetFunction(display, defGC, GXor);
        XSetPlaneMask(display, defGC, setones);
	XSetFillStyle(display, defGC, FillStippled);
	XSetStipple(display, defGC, grXStippleTiles[grCurrent_stipple]);
	XFillRectangle( display,
	    grCurrent.window,
	    defGC,
	    r->r_xbot, grMagicToX( r->r_ytop ),
	    r->r_xtop - r->r_xbot + 1, r->r_ytop - r->r_ybot + 1
);
	}
	/* Now, fill in the 0's */
	if (setzeros != 0)
	{
        XSetFunction(display, defGC, GXand);
        XSetPlaneMask(display, defGC, setzeros);
	XSetFillStyle(display, defGC, FillStippled);
	XSetStipple(display, defGC, grXStippleInvTiles[grCurrent_stipple]);
	XFillRectangle( display,
	    grCurrent.window,
	    defGC,
	    r->r_xbot, grMagicToX( r->r_ytop ),
	    r->r_xtop - r->r_xbot + 1, r->r_ytop - r->r_ybot + 1
);
	}
        XSetPlaneMask(display, defGC, grCurrent.planes);	/* restore */
	XSetFunction(display, defGC, GXcopy);			/* restore */
    }
}


