/* grX1.c -
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * This file contains primitive functions to manipulate an X window system
 * on a microVax color display.  Included here are initialization and closing
 * functions, and several utility routines used by the other X
 * modules.
 *
 */

/**** Modifications by Dave Durfee and Markus G. Wloka
***** Copyright (C) 1987 Brown University		
****/

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/


#include <stdio.h>
#include <sgtty.h>
#ifndef DONT_CHECK_FOR_ERROR
#include <errno.h>
#endif
#include "magic.h"
#include "geometry.h"
#include "graphics.h"
#include "windows.h"
#include "graphicsInt.h"
#include "textio.h"
#include "txcommands.h"
#include "signals.h"
#include "utils.h"
#include "grXInt.h"
#include <X11/Xlib.h>
#include <X11/X.h>
#include <signal.h>

#ifndef lint
static char sccsid[] = "@(#)grX1.c	4.5 MAGIC (Berkeley) 8/22/85";
#endif	not lint

GR_CURRENT grCurrent;
int grPixels[ 256 ];
Pixmap grTiles[ 256 ];
global bool grInited = false;		/* This insures that
					 * no graphics routine is
					 * called before ginit().
					 */
#ifdef HARDCODE_STIPPLE /* (dad) BRUNIX I got rid of hardcoded values */
char grStipples[ 16 ] [ 8 ];	 	/* Storage for stipple masks */
#else
char grStipples[GR_NUM_STIPPLES][ 8 ];	/* Storage for stipple masks */
#endif

int grCurrent_stipple;
/*****
******	      Changed variable name DisplayWidth (Height) to Diswidth
******	      because the compiler would confuse it with DisplayWidth().
*****/
int DisWidth, DisHeight;

int pipeRead, xEventSize = sizeof(XEvent);
int Xhelper;

int screen;
Display *display;
Visual *visual;
Colormap cmap;
GC defGC;

/* locals */
bool firstCall = true;		/* used for colormap setup */

/* This is kind of a long story, and very kludgy, but the following
 * things need to be defined as externals because of the way lint
 * libraries are made by taking this module and changing all procedures
 * names "Xxxx" to "Grxxx".  The change is only done at the declaration
 * of the procedure, so we need these declarations to handle uses
 * of those names, which don't get modified.  Check out the Makefile
 * for details on this.
 */

extern Void GrXClose(), GrXFlush(), GrXInit();


/*---------------------------------------------------------
 * grxSetWMandC:
 *	This is a local routine that resets the value of the current
 *	write mask and color, if necessary.
 *
 * Results:	None.
 *
 * Side Effects:    None.
 *
 * Errors:		None.
 *---------------------------------------------------------
 */

Void
grxSetWMandC (mask, c)
    int mask;			/* New value for write mask */
    int c;			/* New value for current color */
{
    grCurrent.planes = mask | grCurrent.maskmod;
    XSetPlaneMask(display, defGC, grCurrent.planes);	/* NEW !! */

    grCurrent.pixel = grPixels[ c ];	/* | grCurrent.maskmod; */
    XSetForeground(display, defGC, grCurrent.pixel);

    grCurrent.tile = grTiles[ c ];
}


/*---------------------------------------------------------
 * grxSetLineStyle:
 *	This local routine sets the current line style.
 *
 * Results:	None.
 *
 * Side Effects:
 *	A new line style is output to the display.
 *
 * Note: Almost all of Magic's linestyles are 0x00 or 0xff.
 *	That's why we keep the two patterns around.
 *---------------------------------------------------------
 */

Void
grxSetLineStyle (style)
    int style;			/* New stipple pattern for lines. */
{

    style &= 0xFF;
    switch( style ) {
    case 0x00:
    case 0xff:
	       XSetLineAttributes(display, defGC, 0, LineSolid, CapNotLast, JoinMiter);
	       break;
    default:
	       grCurrent.pattern[0] = grCurrent.pattern[1] = style;
	       XSetDashes(display, defGC, 0, grCurrent.pattern, 2);
	       XSetLineAttributes(display, defGC, 0, LineonOffDash, CapNotLast, JoinMiter);
    }
}


/*---------------------------------------------------------
 * Using stipples under the X window system:
 *
 * The stipple patterns are stored as bitmaps which are used
 * as the cmask argument in drawing rectangles with the
 * XTileFill() routine.  The bitmap resource numbers are
 * kept in the grBitmap[] array.  The index to the array
 * corresponds to the stipple numbers in Magic.
 *
 * The current version of Xlib does not support clipmasks
 * in the XTileFill routine.  Instead, we modify the dstyle
 * file to show different materials.
 *
 * Stippling is done currently by drawing multiple dashed lines.
 * This is noticeably slower than without stippling.
 *
 * Even if Xlib finally does support clipmasks, we might still
 * have a problem:  The size of the clipmask has to match that
 * of the tile being drawn.  Defining a new clipmask for each
 * rectangle drawn seems an awefully high price to me.
 *---------------------------------------------------------
 */

/*---------------------------------------------------------
 * grxSetSPattern:
 *	xSetSPattern associates a stipple pattern with a given
 *	stipple number.  This is a local routine called from
 *	grStyle.c .
 *
 * Results:	None.
 *
 * Side Effects:    None.
 *---------------------------------------------------------
 */

Void
grxSetSPattern (stipple, pattern)
    int stipple;			/* The stipple number, 1-15. */
    int pattern[8];			/* 8 8-bit patterns integers */
{
    int i;

    for( i = 0; i < 8; i++ ) {
	grStipples[ stipple ] [ i ] =
	    pattern[ i ] & 0xff;
    };
}


/*---------------------------------------------------------
 * grxSetStipple:
 *	This routine sets the Xs current stipple number.
 *
 * Results: None.
 *
 * Side Effects:
 *	The current clipmask in the X is set to stipple,
 *	if it wasn't that already.
 *---------------------------------------------------------
 */

Void
grxSetStipple (stipple)
    int stipple;			/* The stipple number to be used. */
{
    grCurrent_stipple = stipple ;
}


/*---------------------------------------------------------
 * GrXInit:
 *	GrXInit initializes the graphics display and clears its screen.
 *	Files must have been previously opened with GrSetDisplay();
 *
 * Results: TRUE if successful.
 *---------------------------------------------------------
 */
bool
GrXInit ()
{
    char readdata[10];
    int *intdata;
    XGCValues xgcv;
    unsigned long xgcvm = 0;	/* ignore XGCvalues: use defaults */

    if (!grInited) {
	/* No warp: use Xdefaults */

	read(pipeRead, readdata, 4);
	intdata = (int*) readdata;
	grCurrent.window = (Window) *intdata;
	read(pipeRead, readdata, 4);
	intdata = (int*) readdata;
	GrScreenRect.r_xtop = DisWidth = *intdata;
	read(pipeRead, readdata, 4);
	intdata = (int*) readdata;
	GrScreenRect.r_ytop = DisHeight = *intdata;

	if( grCurrent.window == NULL ) {
	    fprintf( stderr, "XInit: Unable to create new window\n" );
	    return( false );
	};

	defGC = XCreateGC(display,grCurrent.window,xgcvm,&xgcv);
	grInited = true;
    };
    grxLoadFont();
    return true;
}


/*** mgw   open display with error checking
***/
mgwXOpenDisplay()
{
	if((display = XOpenDisplay(NULL)) == NULL)
	{
		fprintf(stderr, "GrXInit XOpenDisplay returned NULL\n") ;
		fprintf(stderr, "You forgot   setenv DISPLAY machine:0\n") ;
		exit(1) ;
	}
	/* the next line is for DEBUGGING ONLY */
	/* XSynchronize(display, 1); */
	screen = DefaultScreen(display);
	visual = DefaultVisual(display,screen);
	printf("%s planes %d size %d %d\n" , XDisplayName(NULL) ,
					     DisplayPlanes(display,screen) ,
					     DisplayWidth(display,screen), 
					     DisplayHeight(display,screen) ) ;
}


/*---------------------------------------------------------
 * GrXClose:
 *	Return cursor to original position. (Doesn't seem to work)
 *	X resources are released automatically upon exit.
 *
 * Results:	None.
 *
 * Side Effects:
 *---------------------------------------------------------
 */

Void
GrXClose ()
{
    close(pipeRead);
    kill(Xhelper, SIGKILL);
    do {} while (wait(0) != Xhelper);
    XFreeGC(display,defGC);
    XCloseDisplay(display);
    firstCall = true;
    grInited = false;
    CleanupStippleTiles();
}


/*---------------------------------------------------------
 * GrXFlush:
 *	Flush output to display.
 *
 *	Flushing is done automatically the next time input is read,
 *	so this procedure should not be used very often.
 *
 * Results:	None.
 *
 * Side Effects:    None.
 *---------------------------------------------------------
 */

Void
GrXFlush ()
{
    XFlush(display);
}


/*
 * ---------------------------------------------------------------------------
 *
 * grXStdin --
 *
 *	Handle the stdin device for the X driver.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Adds events to the data queue.
 *
 * ---------------------------------------------------------------------------
 */

Void
grXStdin ()
{
    XEvent data;
    TxInputEvent *event;

    read(pipeRead, &data, xEventSize);
    switch( data.type ) {
    case ButtonPress:
    case ButtonRelease:
      {
	XButtonEvent *ButtonEvent;

	event = TxNewEvent();
	ButtonEvent = (XButtonEvent *) &data;

	switch( ButtonEvent->button & 0xff ) {
	case Button1:
		event->txe_button = TX_LEFT_BUTTON; break;
	case Button2:
		event->txe_button = TX_MIDDLE_BUTTON; break;
	case Button3:
		event->txe_button = TX_RIGHT_BUTTON; break;
	};
	switch( data.type ) {
	  case ButtonRelease:
	    event->txe_buttonAction = TX_BUTTON_UP;
		break;
	  case ButtonPress:
	    event->txe_buttonAction = TX_BUTTON_DOWN;
		break;
	};
	event->txe_p.p_x = ButtonEvent->x;
	event->txe_p.p_y = grXToMagic(ButtonEvent->y);
	event->txe_wid = WIND_UNKNOWN_WINDOW;
	TxAddEvent( event );
	break;
      };

    case KeyPress:
      {
	/* Need to filter out non-ascii characters ( Shift, Lock, Ctrl )
	 * which are counted as Keys in X.
	 */
	XKeyPressedEvent *KeyPressedEvent;
	char inChar;

	KeyPressedEvent = (XKeyPressedEvent *) &data;
        read(pipeRead, &inChar, 1);
	if( inChar >= 0 && inChar <= 127 ) {
	    event = TxNewEvent();
	    event->txe_button = TX_CHARACTER;
	    if( inChar == 012 || inChar == '\015' ) {
		event->txe_ch = '\n';
	    } else {
		event->txe_ch = inChar;
	    };
	    event->txe_p.p_x = KeyPressedEvent->x;
	    event->txe_p.p_y = grXToMagic( KeyPressedEvent->y );
	    /* Cursoroff not implemented.
	     * Might need to define a blank cursor
	     */
	    /* Signal to user that mouse input is no
	     * longer expected.  Cursor will get
	     * turned back on by GrEnableTablet()
	     * in txCommands.TxDispatch()
	     */
	    TxAddEvent( event );
	};
	break;
      };

    case Expose:
      {
	XExposeEvent *ExposeEvent;
	int newWidth, newHeight;
	XWindowAttributes atts[1];

	ExposeEvent = (XExposeEvent*) &data;

	/* on the last of each group of events repaint the window */
	if (ExposeEvent->count)
	    break;

	/* remove any other pending Expose events from the queue to
	 * avoid multiple repaints.
         */
	while (XCheckTypedEvent(display,Expose,ExposeEvent)) ;

	/* find out how big the window is now */
	if (XGetWindowAttributes(display,grCurrent.window,atts) == 0)
	    break;
	newWidth = atts->width;
	newHeight = atts->height;

	if (newWidth == DisWidth && newHeight == DisHeight) {
	    issueCommand(ExposeEvent->x, ExposeEvent->y, ":redraw");
	} else if (newWidth < DisWidth && newHeight < DisHeight) {
		issueCommand(20, newHeight - 20, ":grow");
	} else { /* growing */
		issueCommand(20, DisHeight - 20, ":grow");
	};
	GrScreenRect.r_xtop = DisWidth = newWidth;
	GrScreenRect.r_ytop = DisHeight = newHeight;
	break;
      };
    }; /* switch */
}

issueCommand (x, y, command)
    int x,y;
    char *command;
{
    int commandLength;
    commandLength = strlen(command);
    while (commandLength--) {
	makeTxEvent(x, y, *command++);
    };
    makeTxEvent(x,y, '\n');
}

makeTxEvent (x, y, eventChar)
    int x,y;
    char eventChar;
{
    TxInputEvent *event;
    event = TxNewEvent();
    event->txe_button = TX_CHARACTER;
    event->txe_ch = eventChar;
    event->txe_p.p_x = x;
    event->txe_p.p_y = y;
    TxAddEvent(event);
}


/*---------------------------------------------------------
 * xSetDisplay:
 *	This routine sets the appropriate parameters so that
 *	Magic will work with the X display.
 *
 *	Under Xlib, all input events (mouse and keyboard) are
 *	sent to one queue which has to be polled to discover
 *	whether there is any input or not.  To fit the Magic
 *	interrupt-driven input model, a helper process is
 *	spawned which reads and blocks on the event queue,
 *	sending SIGIO's to Magic when it detects input.  The
 *	input read in the helper process is then sent to Magic
 *	via a communication pipe.
 *
 * Results:  success / fail
 *
 * Side Effects:	Sets up the pipe.
 *---------------------------------------------------------
 */

bool
xSetDisplay (dispType, outFileName, mouseFileName)
    char *dispType;		/* arguments not used by X */
    char *outFileName;
    char *mouseFileName;
{
    int fildes[2];

/******
*******       Moved Xopendisplay to run before grXinit.  Now possible:
*******       no fixed display size, it asks the display for its size and
*******       how many bit planes it has.
******/
    mgwXOpenDisplay() ;   /* mgw make sure I can read device sizes */
    mgw_set_params() ;	  /* mgw  make sure display is opened before */

    /* Set up helper process */
    pipe(fildes);
    pipeRead = fildes[0];
    TxAddInputDevice((1 << pipeRead), grXStdin, (ClientData) NULL);
    Xhelper = fork();

    if (Xhelper == 0) {    /* Child process */
	char *fullname;
	char *mgw_Xhelper = "~cad/bin/X11helper" ; /* marco location of Xhelper */
	char argv[2][100];
	FILE* f;
	int error;

	f = PaOpen( mgw_Xhelper , "r", (char *) NULL,
		    (char *) NULL, (char *) NULL, &fullname);
	if (f == NULL) {
	    TxError("Couldn't find helper process %s\n", mgw_Xhelper ) ;
	    error = 0;
	    write(fildes[1], &error, 4);
	    return false;
	} else {
	    fclose(f);
	    sprintf(argv[0], "%s", fullname);
	    sprintf(argv[1], "%d %d %d", DisWidth, DisHeight,
		    fildes[1]);
#ifndef DONT_CHECK_FOR_ERROR
	    execlp(argv[0], argv[0], argv[1], 0);
#else
	    if (execlp(argv[0], argv[0], argv[1], 0) == -1) {
		Perror("execing Xhelper failed");
	    }
#endif
	};
    };
    if(!GrXInit()){
	return false;
    };
    return true;
}

extern Void GrXSetBW();

/** for neatness   set all these display parameters
**/
mgw_set_params()
{
    int bits = DisplayPlanes(display,screen);

    /* Set up the procedure values in the indirection table. */

    GrLockPtr = grSimpleLock;
    GrUnlockPtr = grSimpleUnlock;
    GrInitPtr = GrXInit;
    GrClosePtr = GrXClose;
    GrSetCMapPtr = (bits < 4) ? GrXSetBW : GrXSetCMap; 	   

    GrEnableTabletPtr = GrXEnableTablet;
    GrDisableTabletPtr = GrXDisableTablet;
    GrSetCursorPtr = GrXSetCursor;
    GrTextSizePtr = GrXTextSize;
    GrDrawGlyphPtr = GrXDrawGlyph;
    GrReadPixelPtr = GrXReadPixel;
    GrFlushPtr = GrXFlush;

    /* local indirections */
    grSetSPatternPtr = grxSetSPattern;
    grPutTextPtr = grxPutText;
    grDefineCursorPtr = grxDefineCursor;
    GrBitBltPtr = GrXBitBlt;
    grDrawGridPtr = grxDrawGrid;
    grDrawLinePtr = grxDrawLine;
    grSetWMandCPtr = grxSetWMandC;
    grFillRectPtr = grxFillRect;
    grSetStipplePtr = grxSetStipple;
    grSetLineStylePtr = grxSetLineStyle;
    grSetCharSizePtr = grxSetCharSize;

    grMaxStipples = 64;      /* allow lots more stipple patterns */

    /* Make X and magic have the same coordinate convention:
     * make the origin to be at the upper lower left corner.
     */

    grCursorType = "bw";
    grCurrent.maskmod = 0;

    if (bits < 4) {
	    grDStyleType = "bw";
	    grCMapType = NULL;
	    GrXSetBW();
    } else if (bits < 6) {
	    grDStyleType = "4bit";
	    grCMapType = "4bit";
    } else if (bits < 8) {
	    grDStyleType = "6bit";
	    grCMapType = "6bit";
    } else {
	    grDStyleType = "7bit";
	    grCMapType = "7bit";
	    grCurrent.maskmod = 0x80;
    }

    DisWidth = DisplayWidth(display,screen) - 4;
    DisHeight = DisplayHeight(display,screen) - 100;
    GrScreenRect.r_xtop = DisWidth;
    GrScreenRect.r_ytop = DisHeight;
}


/*  mgw  debugging function
*/
report(s)
char *s ;
{
	/*
	printf("--> %s\n" , s ) ;
	*/
}

