/* X11helper.c -- helper process for magic on X windows which signals the
 *		parent (magic) whenever there is input available.
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 */

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <signal.h>

Display *display;
int screen;
unsigned int displayWidth;	/* width of magic window */
unsigned int displayHeight;	/* height of magic window */
unsigned int displayXCoor;	/* upper left x coord */
unsigned int displayYCoor;	/* upper left y coord */
unsigned int borderwidth = 2;

/* support for Xdefaults */
#define GR_PGMNAME "magic"
#define STRING "Magic"

XWMHints xwmh = {
  (InputHint|StateHint),	/* flags */
  False,			/* input */
  NormalState,			/* initial state */
  0,				/* icon pixmap */
  0,				/* icon window */
  0,0, 				/* icon location */
  0,				/* icon mask */
  0,				/* Window group */
};

int pipeFileDesc;	/* pipe file descriptor to magic process */
int parentID;		/* process id of parent */
int sizeOfEvent;	/* number of bytes in an X event */
Window window;		/* magic window identifier */

main (argc, argv)
    int argc;
    char **argv;
{
    char *writedata;

    sscanf(argv[1], "%d %d %d", &displayWidth, &displayHeight, &pipeFileDesc);
    openWindow();
    writedata = (char*) &window;
    write(pipeFileDesc, writedata, 4);
    writedata = (char*) &displayWidth;
    write(pipeFileDesc, writedata, 4);
    writedata = (char*) &displayHeight;
    write(pipeFileDesc, writedata, 4);
    parentID = getppid();
    simulateInterrupts();
}

openWindow ()
{
    XSizeHints xsh;		/* Size hints for window manager */
    XWindowAttributes atts;
    XEvent event;
    int flags;
    char *geometry = NULL;	/* size and location */

    if ((display = XOpenDisplay(NULL)) == NULL)
    {
	fprintf(stderr, "Xhelper: XOpenDisplay returned NULL\n") ;
	fprintf(stderr, "You forgot   setenv DISPLAY machine:0\n") ;
	exit(1) ;
    }
    screen = DefaultScreen(display);


    /* set program initials */
    xsh.flags = (PPosition|PSize);
    displayXCoor = 0;
    displayYCoor = 0;
    borderwidth = 2;

    /* Get default values from .Xdefaults file. */
    geometry = XGetDefault(display,GR_PGMNAME,"geometry");
    if (!geometry) geometry = XGetDefault(display,GR_PGMNAME,"Geometry");
    if (geometry) flags = XParseGeometry(geometry, 
		&displayXCoor, &displayYCoor, &displayWidth, &displayHeight);
    if (XValue & flags) {
	if (XNegative & flags) {
		fprintf(stderr,"Invalid X coordinate: %n\n", displayXCoor);
		displayXCoor = 0;
	} else {
		xsh.flags |= USPosition;
		xsh.flags &= ~PPosition;
	}

    }
    if (YValue & flags) {
	if (YNegative & flags) {
		fprintf(stderr,"Invalid Y coordinate: %n\n", displayYCoor);
		displayYCoor = 0;
	} else {
		xsh.flags |= USPosition;
		xsh.flags &= ~PPosition;
	}
    }

    if ((WidthValue|HeightValue) & flags) {
	xsh.flags |= USSize;
	xsh.flags &= ~PSize;
    }

    DecimalOption("borderWidth",&borderwidth);
    DecimalOption("borderwidth",&borderwidth);

    /* warp cursor to default/requested spot */
    if (XWarpPointer(display, None, RootWindow(display, screen), 
		0, 0, 0, 0, displayXCoor, displayYCoor) == BadWindow)
    {
	    fprintf( stderr, "X11helper: Unable to warp the pointer\n" );
    }

    /* provide window with initial position and size */
    xsh.height = displayHeight;
    xsh.width = displayWidth;
    xsh.x = displayXCoor;
    xsh.y = displayYCoor;

    window = XCreateSimpleWindow(display,
		RootWindow(display,screen),
		xsh.x, xsh.y, xsh.width, xsh.height, borderwidth,
		BlackPixel(display,screen), WhitePixel(display,screen));

    /* set the standard properties for window managers */
    XSetStandardProperties(display,window,STRING,STRING,None,NULL,0,&xsh);
    XSetWMHints(display,window,&xwmh);

    if (window == NULL) {
	fprintf(stderr, "X11helper: Unable to open window.\n");
    } else {
	XSelectInput(display, window,
	    (unsigned long) KeyPressMask|ButtonPressMask|ButtonReleaseMask|
	    ExposureMask|EnterWindowMask|LeaveWindowMask);

	XMapWindow(display,window);
	XFlush(display);

	/* wait for first expose event */
	for(;;) {
		XNextEvent(display, &event);
		if (event.type == Expose) break;
	}

	/* see what really happened */
	while (XGetWindowAttributes(display,window,&atts) == 0) ;
	displayWidth = atts.width;
	displayHeight = atts.height;
    };
}

#define STRSIZE 10
char inChar[STRSIZE];

simulateInterrupts ()
{
    XEvent event;
    int i;
    char *st;

    sizeOfEvent = sizeof(event);

    for(;;) {
	XNextEvent(display, &event);

	if (event.type == KeyPress) {
		i = XLookupString(&event, inChar, sizeof(inChar), NULL, NULL);
		if (inChar[0] == 3) {
		    kill(parentID, SIGINT);
		} else {
		    for (st = inChar; i > 0; i--) {
			write(pipeFileDesc, &event, sizeOfEvent);
			write(pipeFileDesc, st++, 1);
	            	kill(parentID, SIGIO);
		    }
		}
	} else {
	    	write(pipeFileDesc, &event, sizeOfEvent);
	    	kill(parentID, SIGIO);
	};
    };
}

DecimalOption(OptionName, Target)
  int *Target;
  char *OptionName;
{
  char *TargetString;
  int TempTarget;
  
  TargetString = XGetDefault(display,GR_PGMNAME,OptionName);
  if (TargetString != NULL) 
    {
      if (sscanf(TargetString,"%d",&TempTarget))
	*Target = TempTarget;
      else
	fprintf(stderr,"Invalid magic option: %s: %s\n",OptionName,TargetString );
    }
}
