/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This component manages the exec panel.
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <sgtty.h>
#include <sys/signal.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Atoms.h>
#include <X11/Shell.h>
#include <X11/Command.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/bmenu.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/xgsherr.h"
#include "../include/defunct.h"

/*
 * Global vars.
 */
#define	EXECMENU	if((gconfptr->gc_flags&G_NOMULTI)==0)exec_menu()
#define	EXECMENU_DEL	if((gconfptr->gc_flags&G_NOMULTI)==0)exec_menu_del()
#define	gerr(a)		{err(a);reset_cmd(True);reset_names();}
extern Widget toplevel;
extern GshState	gshstate;	/* state struct for gsh		*/
extern GshConf *gconfptr;		/* conf. struct for gsh		*/
extern char	cmdstr[BSIZE+1];	/* built up cmd. string */
extern char	**environ;	/* environment list			*/
extern int	ttyx, ttyy;	/* Base window position */
extern Widget	build_menu();
extern char *malloc();
static int	ttydisp = NTTYDISC;
static int	ttyflush = 0;
static int	ttylword = (LCRTBS|LCRTERA|LCRTKIL|LCTLECH|LDECCTQ);
PidList *menu_pidp;
static XtTranslations labtrn;
static void exec_menu_add(), exec_menu_del();

/*
 * Pop up ctrl menu for widget.
 */
static void ctrl_call(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{

	if (menu_pidp != NULL)
		return;
	menu_pidp = (PidList *) p1;
}

/*
 * Callback from procmenu popdown to nullify menu_pidp
 */
static void menu_popdown(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	menu_pidp = NULL;
}

/*
 * This function runs the commnd in the command string.
 */
go_cmd()
{
	register GshState *gs = &gshstate;
	register GshConf *gc = gconfptr;
	register PidList *pidp, opidp;
	CmdConf *cmdp;
	int xpos, ypos;
	TTYWindow *tyw;
	int newpid;
	char runstr[BSIZE];
	int omask;
	static Arg setpos[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
	};
	static Arg popuplist[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
		{XtNgeometry,	(XtArgVal) NULL},
		{XtNallowShellResize,	(XtArgVal) True},
		{XtNsaveUnder,	(XtArgVal) False},
	};
	static XtCallbackRec jctlcall[] = {
		{ctrl_call,	NULL},
		{NULL,		NULL},
	};
	static Arg labellist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) NULL},
		{XtNtranslations, (XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) jctlcall},
	};

	if (sel_cmd(-1, &(gc->gc_level[gs->gs_curtoplevel].l_cmd[gs->gs_curcmd])) < 0)
		return;
	strcpy(runstr, cmdstr);
	if ((gs->gs_curpid != NULL) && (gc->gc_flags & G_NOMULTI)) {
		gerr(ER_NOMULTI);
		return;
	}
	if (gs->gs_logfile != NULL && gs->gs_curpid != NULL)
		gs->gs_slog.sl_mjobs++;
	cmdp = &(gc->gc_level[gs->gs_curtoplevel].l_cmd[gs->gs_curcmd]);
	if ((pidp = (PidList *)malloc(sizeof(PidList))) == NULL) {
		gerr(ER_NOMEM);
		return;
	}
	pidp->flags = cmdp->c_flags;
	pidp->next = NULL;
	pidp->ttywin = NULL;
	omask = sigblock(sigmask(SIGCHLD));
	if (cmdp->c_flags & C_TTY) {
		char *sp[10];
		int sp1;
		char geom[30];
		struct sgttyb ttyb;

		bzero((caddr_t) sp, 10*sizeof(char *));
		sp1 = 0;
		if (cmdp->c_flags & C_TTYVIFCONF) {
			sp[0] = "-config";
			sp[1] = cmdp->c_vifconf;
			sp1 = 2;
		}
		if (cmdp->c_flags & C_TTYJUMPSCROLL)
			sp[sp1++] = "-j";
		if (cmdp->c_flags & C_UTMP)
			sp[sp1++] = "-setutmp";
		if (cmdp->c_flags & C_WINLINGER)
			sp[sp1] = "-defunct";
		execwin_pos(&xpos, &ypos);
		if (gc->gc_flags & G_TTYMOUSEPOS) {
			sprintf(geom,"%dx%d", cmdp->c_ttycol, cmdp->c_ttyrow);
			XWarpPointer(gs->gs_disp, None,
				gs->gs_rootwin,
				0, 0, 0, 0, xpos, ypos);
			XFlush(gs->gs_disp);
		} else {
			sprintf(geom,"%dx%d+%d+%d",
				cmdp->c_ttycol, cmdp->c_ttyrow,
				xpos, ypos);
		}
		XDefineCursor(gs->gs_disp, gs->gs_rootwin,
			gs->gs_fullhrcursor);
		XFlush(gs->gs_disp);
		if ((tyw = CreateTTYWindow(omask, "-geometry",geom,"-display",
			DisplayString(gs->gs_disp), "-name", cmdp->c_label,
			"-font", FONT,
			sp[0],sp[1],sp[2],sp[3],sp[4],sp[5],sp[6],
			sp[7],sp[8],sp[9],0))==NULL) {
			gerr(ER_NOTTYW);
			XDefineCursor(gs->gs_disp, gs->gs_rootwin,
				gs->gs_defcursor);
			XFlush(gs->gs_disp);
			free((caddr_t) pidp);
			sigsetmask(omask);
			return;
		}
		XDefineCursor(gs->gs_disp, gs->gs_rootwin,
			gs->gs_hrcursor);
		XFlush(gs->gs_disp);
		ioctl(tyw->file, TIOCSETD, &ttydisp);
		ioctl(tyw->file, TIOCGETP, &ttyb);
		ttyb.sg_flags |= (CRMOD|ECHO);
		ttyb.sg_ispeed = ttyb.sg_ospeed = B9600;
		ioctl(tyw->file, TIOCSETN, &ttyb);
		ioctl(tyw->file, TIOCLSET, &ttylword);
		ioctl(tyw->file, TIOCFLUSH, &ttyflush);
		/* Warp mouse into TTY window */
		if ((cmdp->c_flags & C_WARPMOUSE) &&
			((gc->gc_flags & G_TTYMOUSEPOS) == 0))
			XWarpPointer(gs->gs_disp, None,
				gs->gs_rootwin,
				0, 0, 0, 0, xpos+30, ypos+30);
		XDefineCursor(gs->gs_disp, gs->gs_rootwin,
			gs->gs_defcursor);
		/* Grab button 3 for proc ctrl menu */
		XGrabButton(gs->gs_disp, Button3, 0, tyw->w, True,
			ButtonPressMask, GrabModeSync, GrabModeAsync,
			None, gs->gs_defcursor);
		XFlush(gs->gs_disp);
		pidp->ttywin = tyw;
	} else if (cmdp->c_flags & C_ICONW) {
#ifdef SAFE
		char *pp;

		/* SUPER KLUDGE, but how else do i find out if XtMalloc
			will fail ?? */
		if ((pp = malloc(SOMEMEM)) == NULL) {
			gerr(ER_NOMEM);
			free((caddr_t) pidp);
			sigsetmask(omask);
			return;
		} else
			free(pp);
#endif
		pidp->widget = XtCreatePopupShell("iconw", transientShellWidgetClass,
			gs->gs_toplw, popuplist, XtNumber(popuplist));
		labellist[0].value = (XtArgVal) init_colour(gc->gc_iconfgr);
		labellist[1].value = (XtArgVal) init_colour(gc->gc_iconbgr);
		labellist[2].value = (XtArgVal) cmdp->c_label;
		labellist[3].value = (XtArgVal) labtrn;
		jctlcall[0].closure = (caddr_t) pidp;
		pidp->subwidget = XtCreateManagedWidget("jctl", commandWidgetClass,
			pidp->widget, labellist, XtNumber(labellist));
		XtRealizeWidget(pidp->widget);
		execwin_pos(&xpos, &ypos);
		setpos[0].value = (XtArgVal) xpos;
		setpos[1].value = (XtArgVal) ypos;
		XtSetValues(pidp->widget, setpos, 2);
		XtPopup(pidp->widget, XtGrabNone);
	}
	/* get the process going */
	if ((newpid = vfork()) < 0) gerr(ER_NOFORK);
	if (newpid == 0) {
		int newpgrp;

		sigsetmask(omask);
		newpgrp = getpid();
		if (cmdp->c_flags & C_TTY) {
			ioctl(tyw->file, TIOCSPGRP, &newpgrp);
			dup2(tyw->file, 0);
			dup2(tyw->file, 1);
			dup2(tyw->file, 2);
			close(tyw->file);
		} else {
			int fdt;

			if ((fdt = open("/dev/null", O_RDWR, 0666)) < 0)
				gerr(ER_NONULL);
			dup2(fdt, 0);
			dup2(fdt, 1);
			dup2(fdt, 2);
			close(fdt);
		}
		setpgrp(0, newpgrp);
		execle("/bin/csh","csh","-f","-c",runstr,0,environ);
		gerr(ER_NOCSH);
	} else {
		if (cmdp->c_flags & C_TTY)
			close(tyw->file);
		pidp->pid = newpid;
		sprintf(pidp->name, "%s (%d)",
		   cmdp->c_label, newpid);
		pidp->next = gs->gs_pidlist.next;
		gs->gs_pidlist.next = pidp;
		exec_menu_add(pidp);
		set_newjob(pidp);
		sigsetmask(omask);
		reset_cmd(True);
	}
}

/*
 * This function deals with input from the process control menu.
 */
void exec_input(ipos)
	int ipos;
{
	register PidList *curpid;
	register int i;
	register GshState *gs = &gshstate;
	int omask;

	omask = sigblock(sigmask(SIGCHLD));
	/* Get the PidList member referenced by searching the list for w */
	curpid = gs->gs_pidlist.next;
	while (curpid != NULL) {
		if (curpid == menu_pidp)
			break;
		curpid = curpid->next;
	}
	menu_pidp = NULL;
	if (curpid == NULL) {
		sigsetmask(omask);
		return;
	}
	switch (ipos) {
	case 0:
		killpg(curpid->pid, SIGSTOP);
		if ((curpid->flags & C_TTY) && (curpid->ttywin != NULL))
			kill(curpid->ttywin->pid, SIGSTOP);
		curpid->flags |= C_STOPPED;
		break;
	case 1:
		killpg(curpid->pid, SIGCONT);
		if ((curpid->flags & C_TTY) && (curpid->ttywin != NULL))
			kill(curpid->ttywin->pid, SIGCONT);
		curpid->flags &= ~C_STOPPED;
		break;
	case 2:
		if (curpid->flags & C_DONTKILL) {
			err("Can't Kill this Window");
			break;
		}
		curpid->flags &= ~C_STOPPED;
		killpg(curpid->pid, SIGKILL);
		if ((curpid->flags & C_TTY) && (curpid->ttywin != NULL)) {
			/* Make sure the vif is not stopped */
			kill(curpid->ttywin->pid, SIGCONT);
			kill(curpid->ttywin->pid, SIGUSR1);
		}
		if (curpid->flags & C_DEFUNCT) {
			PidList *opidp;

			if ((curpid->flags & C_TTY) && (curpid->ttywin != NULL)) {
				free((char *)curpid->ttywin);
				curpid->ttywin = NULL;
			} else if (curpid->flags & C_ICONW) {
				XtDestroyWidget(curpid->widget);
			}
			opidp = &(gs->gs_pidlist);
			while (opidp->next != curpid &&
			       opidp->next != NULL)
				opidp = opidp->next;
			if (opidp->next == NULL) ferr(FER_LIST);
			opidp->next = curpid->next;
			exec_menu_del(curpid);
			free((char *)curpid);
			set_newjob(gs->gs_pidlist.next);
		} else {
			curpid->flags |= C_KILLED;
		}
		break;
	default:
		break;
	};
	sigsetmask(omask);
}

/*
 * Create the process control menu.
 */
init_exec()
{
	register GshState *gs = &gshstate;
	register GshConf *gc = gconfptr;
	static char *procctrl[] = {
		"Pause", "Continue", "Kill",
	};
	static char labtrans[] =
	"<Btn3Down>: enablenotify() notify() disablenotify() MenuPopup(Control) \n\
	<EnterWindow>:	highlight() \n\
	<LeaveWindow>:	unset(NoRedisplay) disablenotify() unhighlight()";

	/* create the process control popup menu */
	gs->gs_procmenuw = build_menu("Control", procctrl,
		3, exec_input, gc->gc_procmenufgr, gc->gc_procmenubgr,
		100, BM_SPRUNG);
	XtAddCallback(gs->gs_procmenuw, XtNpopdownCallback, menu_popdown, NULL);
	gs->gs_curpid = NULL;
	gs->gs_pidlist.next = NULL;
	menu_pidp = NULL;
	labtrn = XtParseTranslationTable(labtrans);
}

/*
 * This function handles SIGCHLD signals to update proc. list
 */
childsig()
{
	register PidList *pidp, *opidp;
	register GshState *gs = &gshstate;
	int pid;
	int i;
	union wait stat;
	struct rusage ruse;
	static Pixel fg, bg;
	static Arg getval[] = {
		{XtNforeground,	(XtArgVal) &fg},
		{XtNbackground,	(XtArgVal) &bg},
	};
	static Arg setlabel[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};

	pid = wait3(&stat, WNOHANG, &ruse);
	while (pid != -1 && pid != 0) {
		pidp = gs->gs_pidlist.next;
		opidp = &(gs->gs_pidlist);
		while (pidp != NULL) {
			if (pidp->pid == pid) {
				if (pidp->flags & C_DIRB) {
					opidp->next = pidp->next;
					free((caddr_t) pidp);
				} else if ((pidp->flags & C_WINLINGER) == 0 ||
				     pidp->flags & C_KILLED) {
					if (pidp->flags & C_LOGIN) {
						for (i = 0; i < (LOGINSLEEP*100000); i++)
							;
					}
					if ((pidp->flags & C_KILLED) == 0) {
						killpg(pidp->pid, SIGKILL);
						if ((pidp->flags & C_TTY) &&
						    (pidp->ttywin != NULL)) {
							/* Make sure not stopped */
							kill(pidp->ttywin->pid,
							     SIGCONT);
							kill(pidp->ttywin->pid,
							     SIGUSR1);
						}
					}
					if ((pidp->flags & C_TTY) &&
					    (pidp->ttywin != NULL)) {
						free((char *)pidp->ttywin);
						pidp->ttywin = NULL;
					} else if (pidp->flags & C_ICONW) {
						XtDestroyWidget(pidp->widget);
					}
					opidp->next = pidp->next;
					exec_menu_del(pidp);
					if (pidp == gs->gs_curpid) {
					    set_newjob(gs->gs_pidlist.next);
					}
					free((char *)pidp);
				} else {
					pidp->flags |= C_DEFUNCT;
					if (pidp->flags & C_ICONW) {
						XtGetValues(pidp->subwidget,
							getval, XtNumber(getval));
						setlabel[0].value = (XtArgVal)
							DEFUNCTMSG;
						setlabel[1].value = (XtArgVal)
							bg;
						setlabel[2].value = (XtArgVal)
							fg;
						XtSetValues(pidp->subwidget,
							setlabel, XtNumber(setlabel));
					}
				}
				pidp = NULL;
			} else if ((pidp->flags & C_TTY) &&
				  !(pidp->flags & C_KILLED) &&
				   (pidp->ttywin != NULL) &&
				   (pidp->ttywin->pid == pid)) {
				killpg(pidp->pid, SIGKILL);
				free((caddr_t) pidp->ttywin);
				pidp->ttywin = NULL;
				pidp->flags |= C_KILLED;
				pidp->flags &= ~C_TTY;
				pidp = NULL;
			} else {
				opidp = pidp;
				pidp = pidp->next;
			}
		}
		pid = wait3(&stat, WNOHANG, &ruse);
	}
}

/*
 * This function creates a new job menu
 */
exec_menu()
{
}

/*
 * This function deletes a menu item
 */
static void exec_menu_del(pidp)
	PidList *pidp;
{

	/* Delete a button from the Job menu */
}

/* Add a menu button */
static void exec_menu_add(pidp)
	PidList *pidp;
{
}

/*
 * Sets a new job as the current one. Called from job menu input and
 * whenever the current job changes.
 */
set_newjob(curpid)
	register PidList *curpid;
{
	register GshState *gs = &gshstate;

	gs->gs_curpid = curpid;
	if (curpid != NULL) {
		if ((curpid->flags & C_TTY) && (curpid->ttywin != NULL)) {
			XRaiseWindow(gs->gs_disp, curpid->ttywin->w);
			XFlush(gs->gs_disp);
		} else if (curpid->flags & C_ICONW) {
			XRaiseWindow(gs->gs_disp, XtWindow(curpid->widget));
			XFlush(gs->gs_disp);
		}
		if (curpid->flags & C_STOPPED) {
			killpg(curpid->pid, SIGCONT);
			if ((curpid->flags & C_TTY) && (curpid->ttywin != NULL))
				kill(curpid->ttywin->pid, SIGCONT);
			curpid->flags &= ~C_STOPPED;
		}
	}
}

/*
 * This function calculates an origin for a process' window and
 * returns the position in the args.
 */
execwin_pos(x, y)
	int *x, *y;
{
	register PosList *p, *p2;
	register int xp, yp;
	register PidList *pidp = gshstate.gs_pidlist.next;
	GshState *gs = &gshstate;
	PosList head;
	Window win;
	XWindowAttributes winfo;
	int ttywidth, ttyheight;

	*x = ttyx;
	*y = ttyy;
	/* Iff no other window, then just TTYX, TTYY */
	if (pidp == NULL) {
		return;
	}
	head.next = NULL;
	/* Get pos of each window and generate ordered list of them */
	while (pidp != NULL) {
		if ((pidp->flags & C_TTY) && (pidp->ttywin != NULL))
			win = pidp->ttywin->w;
		else if (pidp->flags & C_ICONW)
			win = XtWindow(pidp->widget);
		else
			win = (Window) NULL;
		if (win != ((Window)NULL)) {
			XGetWindowAttributes(gs->gs_disp, win, &winfo);
			if ((p2 = (PosList *)malloc(sizeof(PosList))) == NULL) {
				p = head.next;
				while (p != NULL) {
					p2 = p;
					p = p->next;
					free((caddr_t) p2);
				}
				err(ER_NOMEM);
				return;
			}
			p2->x = winfo.x;
			p2->y = winfo.y;
			p2->next = NULL;
			p = &head;
			/* Order list => x */
			while (p->next != NULL && p->next->x < p2->x)
				p = p->next;
			p2->next = p->next;
			p->next = p2;
		}
		pidp = pidp->next;
	}
	p = head.next;
	xp = *x;
	yp = *y;
	ttywidth = gs->gs_dispwidth/2;
	ttyheight = gs->gs_dispheight/2;
	/* Find first unused pos TTYX+n*WINDX for n=0,1,2,... */
	while (p!=NULL && xp==p->x && xp<(gs->gs_dispwidth-ttywidth-WINDX) && 
		yp < (gs->gs_dispheight-ttyheight-WINDY)) {
		p = p->next;
		xp += WINDX;
		yp += WINDY;
	}
	*x = xp;
	*y = yp;
	p = head.next;
	/* free up the list */
	while (p != NULL) {
		p2 = p;
		p = p->next;
		free((char *)p2);
	}
}

