/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This component manages the command panels.
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Atoms.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>
#include <X11/Viewport.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Icon.h>
#include <X11/ICommand.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/xgsherr.h"
#include "../icons/newname.icn"

/*
 * Global vars.
 */
extern Widget toplevel;
extern GshState	gshstate;	/* state struct for gsh		*/
extern GshConf *gconfptr;
extern Widget viewbox_w;
extern Widget name_vieww;
extern Widget name_w;
extern Widget newicon_w;
extern Widget noname_labelw;
extern NameConf *curnamep;
extern void namectrl_input();
extern void cmd_popdown();
extern void help_call();
extern char *malloc();
extern void name_input();
NameList *creat_namelist();
int	ttyx, ttyy;				/* base tty win pos */
char	cmdstr[BSIZE+1];			/* cmd. string for /bin/sh	*/
static char	*csptr;				/* working ptr into cmdstr	*/
static char	*csptr2;			/* " above			*/
static int	cmdpos;				/* cmd # selected		*/
char	outstr[OUTSTRL+1];
char	blkstr[OUTSTRL+1];
static Pixel namefgr, namebgr, viewfgr, viewbgr, viewboxfgr, viewboxbgr;
static int getfilternames();
static int getnamevals();
int get_name();
static int getfilenames();

#define MAXLINELEN	(MYMAXPATHLEN+MAXNAMLEN+10)

/*
 * Input to command panel control buttons
 */
static void cmdbut_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	int i;

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
	i = (int) p1;
	switch(i) {
	case 0:
		/* pop down cmd panel */
		cmd_popdown();
		break;
	case 1:
		/* Cancel command under construction */
		reset_names();
		reset_cmd(True);
		break;
	case 2:
		/* Start command execution */
		go_cmd();
		break;
	case 3:
		break;
	};
}

/*
 * This function deals with input to a command panel.
 */
static void cmd_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	int ipos;

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
	if (gs->gs_nocmdinput) {
		return;
	}
	ipos = (int) p1;
	if (gs->gs_logfile != NULL) {
		gs->gs_slog.sl_cmds++;
		gs->gs_slog.sl_hist[gs->gs_curtoplevel][ipos]++;
	}
	sel_cmd(ipos,
	    &(gconfptr->gc_level[gs->gs_curtoplevel].l_cmd[ipos]));
}

/*
 * This function contructs the next part of the cmdstring based on
 * a command panel input.
 */
#define	cerr(a)	{err(a);reset_cmd(True);reset_names();return(-1);}

sel_cmd(cmd, cmdptr)
	int cmd;
	CmdConf *cmdptr;
{
	register GshState *gs = &gshstate;
	register int i, j;
	register char *ifp;
	register NameList *lp;
	char *ifp2;

	if (cmdpos > 1) {
		if (cmd >= 0) {
			cerr(ER_CMDSELECTED);
		}
		/* Fill in name strings for go_cmd() */
		j = 0;
		csptr = cmdstr;
		if (cmdptr->c_flags & C_NAME1) {
			if ((ifp = index(csptr2, '^')) == NULL)
				cerr(ER_NONAMEPOS);
			j = ifp-csptr2;
			if (j > MAXCMDLINE) cerr(ER_CMDLONG);
			bcopy(csptr2, csptr, j);
			csptr += j;
			/* If a name string is there... */
			lp = gs->gs_name1.l_selnext;
			while (lp != NULL) {
				i = strlen(lp->l_name);
				j += i;
				if (j >= MAXCMDLINE) cerr(ER_CMDLONG);
				bcopy(lp->l_name, csptr, i);
				csptr += i;
				lp = lp->l_selnext;
				if (lp != NULL) {
					*csptr++ = ' ';
					j++;
				}
			}
			ifp++;		/* skip over ^ */
			/* If there is a second name field */
			if ((ifp2 = index(ifp, '^')) != NULL) {
				i = ifp2-ifp;
				j += i;
				if (j > MAXCMDLINE) cerr(ER_CMDLONG);
				bcopy(ifp, csptr, i);
				csptr += i;
				/* If there is a second name string */
				if (cmdptr->c_flags & C_NAME2) {
					lp = gs->gs_name2.l_selnext;
					while (lp != NULL) {
						i = strlen(lp->l_name);
						j += i;
						if (j >= MAXCMDLINE) cerr(ER_CMDLONG);
						bcopy(lp->l_name, csptr, i);
						csptr += i;
						lp = lp->l_selnext;
						if (lp != NULL) {
							*csptr++ = ' ';
							j++;
						}
					}
				}
				ifp = ifp2+1;
			}
		} else {
			ifp = csptr2;
		}
		i = strlen(ifp);
		j += i;
		if (j > MAXCMDLINE) cerr(ER_CMDLONG);
		bcopy(ifp, csptr, i);
		*(csptr+i) = '\0';
		gs->gs_name1.l_selnext = gs->gs_name2.l_selnext = NULL;
		reset_names();
	} else {
		if (cmd == -1) cerr(ER_NOCMDGO);
		gs->gs_curcmd = cmd;
		/* Desensitize the command panel */
		if (XtIsSensitive(gs->gs_cmdbbw[gs->gs_curtoplevel]))
			XtSetSensitive(gs->gs_cmdbbw[gs->gs_curtoplevel], False);
	}
	if (cmd == -1) {
		csptr2 = "";
	} else {
		csptr2 = cmdptr->c_string;
	}
	disp_cmd();
	cmdpos++;
	/* If name args are required, call get_name() to get them */
	if (cmd != -1) {
		if (cmdptr->c_flags & C_NAME1) {
			if (index(cmdptr->c_string, '^') == NULL)
				cerr(ER_NONAMEPOS);
			get_name(&(cmdptr->c_name1), &(gs->gs_name1));
		} else if (cmdptr->c_flags & C_AUTOGO)
			go_cmd();
	}
	return(0);
}

/*
 * Display the command line.
 */
disp_cmd()
{
	register GshState *gs = &gshstate;
	register char *p;
	register NameList *lp;
	char *p2;
	CmdConf *cmdptr;
	int j;

	if ((gconfptr->gc_flags & G_COMMANDSTR) == 0)
		return;
	strcpy(outstr, "% ");
	if (cmdstr[0] != '\0') {
		outcat(cmdstr);
	} else if (*csptr2 != '\0') {
		cmdptr = &(gconfptr->gc_level[gs->gs_curtoplevel].l_cmd[
			gs->gs_curcmd]);
		if ((cmdptr->c_flags & C_NAME1) && (p = index(csptr2, '^')) != NULL) {
			*p = '\0';
			outcat(csptr2);
			*p = '^';
			lp = gs->gs_name1.l_selnext;
			while (lp != NULL) {
				outcat(lp->l_name);
				outcat(" ");
				lp = lp->l_selnext;
			}
			/* If not on name 2 yet */
			if (curnamep != (&(cmdptr->c_name2))) {
				if (gs->gs_name1.l_selnext != NULL) {
					if (cmdptr->c_name1.n_flags &
					   (N_0ORMORE|N_1ORMORE|N_MORETHAN1))
						outcat("<name1>");
				} else {
					outcat("<name1>");
				}
			}
			if ((cmdptr->c_flags & C_NAME2) &&
			    ((p2 = rindex(csptr2, '^')) > p)) {
				*p2 = '\0';
				outcat(p+1);
				*p2 = '^';
				lp = gs->gs_name2.l_selnext;
				while (lp != NULL) {
					outcat(lp->l_name);
					outcat(" ");
					lp = lp->l_selnext;
				}
				if (gs->gs_name2.l_selnext != NULL) {
					if (cmdptr->c_name2.n_flags &
					   (N_0ORMORE|N_1ORMORE|N_MORETHAN1))
						outcat("<name2>");
				} else {
					outcat("<name2>");
				}
				outcat(p2+1);
			} else {
				outcat(p+1);
			}
		} else {
			outcat(csptr2);
		}
	}
	outcat(blkstr);
	draw_cmdstr();
}

/*
 * Draw out the current cmd. string
 */
draw_cmdstr()
{
	register GshState *gs = &gshstate;
	static Arg setlab[] = {
		{XtNlabel,	(XtArgVal) outstr},
	};

	if ((gconfptr->gc_flags & G_COMMANDSTR) == 0)
		return;
	XtSetValues(gs->gs_cmdstrw, setlab, XtNumber(setlab));
	/* Force redraw of cmdstrw (Kludge..) */
	(*(gs->gs_cmdstrw->core.widget_class->core_class.expose))
		(gs->gs_cmdstrw, (XEvent *) NULL, (Region) NULL);
}

/*
 * Initialize the cmd panels.
 */
init_cmds()
{
	register int j;
	register LevelConf *lp;
	register CmdConf *cp;
	register int i;
	register GshState *gs = &gshstate;
	GshConf *gc = gconfptr;
	Widget vw;
	Widget formw, titw, fbw;
	XtTranslations viewtrn, bboxtrn, cmdtrn;
	char geom[20];
	static char helpname[NAMSIZ+1];
	static int wid, high;
	static Arg getsiz[] = {
		{XtNwidth,	(XtArgVal) &wid},
		{XtNheight,	(XtArgVal) &high},
	};
	static char viewtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static char bboxtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static char cmdtrans[] =
	"<Btn1Down>:	set() enablenotify() \n\
	<Btn1Up>: notify() disablenotify() unset(NoRedisplay) unhighlight() \n\
	<Btn2Down>:	enablenotify() \n\
	<Btn2Up>:	notify(Help) disablenotify() \n\
	<EnterWindow>:	highlight() \n\
	<LeaveWindow>:	unset(NoRedisplay) disablenotify() unhighlight()";
	static XtCallbackRec viewcall[] = {
		{help_call,	NULL},
		{NULL,		NULL},
	};
	static XtCallbackRec bboxcall[] = {
		{help_call,	NULL},
		{NULL,		NULL},
	};
	static XtCallbackRec cmdcall[] = {
		{cmd_input,	NULL},
		{NULL,		NULL},
	};
	static Arg popuplist[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
		{XtNgeometry,	(XtArgVal) NULL},
		{XtNallowShellResize,	(XtArgVal) False},
		{XtNsaveUnder,	(XtArgVal) False},
	};
	static Arg viewlist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNallowVert,		(XtArgVal) True},
		{XtNallowHoriz,		(XtArgVal) True},
	};
	static Arg viewsiz[] = {
		{XtNwidth,		(XtArgVal) NULL},
	};
	static Arg formsiz[] = {
		{XtNheight,		(XtArgVal) NULL},
	};
	static Arg bboxlist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) bboxcall},
	};
	static Arg iconlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNbitmapData,		(XtArgVal) NULL},
		{XtNiconWidth,	(XtArgVal) NULL},
		{XtNiconHeight,	(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg cmdlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
		{XtNjustify,		(XtArgVal) XtJustifyLeft},
	};
	Widget cw1, cw2, cw3;
	int l1;
	char *pp;

	/* Init global vars */
	name_w = NULL;
	namefgr = init_colour(gc->gc_namebutfgr);
	viewfgr = init_colour(gc->gc_viewfgr);
	viewboxfgr = init_colour(gc->gc_viewboxfgr);
	namebgr = init_colour(gc->gc_namebutbgr);
	viewbgr = init_colour(gc->gc_viewbgr);
	viewboxbgr = init_colour(gc->gc_viewboxbgr);
	gs->gs_namehead.l_next = NULL;
	gs->gs_endlp = &(gs->gs_namehead);
	gs->gs_endname = &(gs->gs_namehead);
	i = 0;
	lp = gc->gc_level;
	viewtrn = XtParseTranslationTable(viewtrans);
	bboxtrn = XtParseTranslationTable(bboxtrans);
	cmdtrn = XtParseTranslationTable(cmdtrans);
	/* Loop thru levels creating popup cmd panels */
	while (i < NTOPLEVEL && (lp->l_flags & L_VALID)) {
		/* Create the popup shell */
		sprintf(geom, "%dx%d", CMDWIDTH, gs->gs_dispheight/2);
		popuplist[2].value = (XtArgVal) geom;
		gs->gs_cmdw[i] = XtCreatePopupShell("cmd", transientShellWidgetClass,
			toplevel, popuplist, XtNumber(popuplist));
		title_creat(gs->gs_cmdw[i], lp->l_fgr, lp->l_bgr, 0,
			lp->l_label, cmdbut_input, &(gs->gs_helphead),
			(gc->gc_flags & G_ICONCTRL), NULL, NULL, 0, 0,
			&formw, &cw1, &cw2, &cw3, &fbw, &titw);
		/* and the viewport widget inside it */
		viewlist[0].value = (XtArgVal) init_colour(lp->l_fgr);
		viewlist[1].value = (XtArgVal) init_colour(lp->l_bgr);
		viewlist[2].value = (XtArgVal) cw1;
		vw = XtCreateManagedWidget("view", viewportWidgetClass,
			formw, viewlist, XtNumber(viewlist));
		/* and the button box in the viewport */
		bboxlist[0].value = (XtArgVal) init_colour(lp->l_bboxfgr);
		bboxlist[1].value = (XtArgVal) init_colour(lp->l_bboxbgr);
		bboxlist[2].value = (XtArgVal) bboxtrn;
		gs->gs_cmdbbw[i] = XtCreateManagedWidget("bbox", boxWidgetClass,
			vw, bboxlist, XtNumber(bboxlist));
		cp = lp->l_cmd;
		j = 0;
		/* Loop thru commands creating the buttons */
		while (j < NCMD && (cp->c_flags & C_VALID)) {
			cmdcall[0].closure = (caddr_t) j;
			/* Icon or label ?? */
			if (cp->c_flags & C_ICON) {
				iconlist[0].value = (XtArgVal) init_colour(cp->c_fgr);
				iconlist[1].value = (XtArgVal) init_colour(cp->c_bgr);
				iconlist[2].value = (XtArgVal) cmdtrn;
				iconlist[3].value = (XtArgVal) cp->c_bits;
				iconlist[4].value = (XtArgVal) cp->c_width;
				iconlist[5].value = (XtArgVal) cp->c_height;
				gs->gs_cmdbw[i][j] = XtCreateManagedWidget("cmdb",
					icommandWidgetClass, gs->gs_cmdbbw[i],
					iconlist, XtNumber(iconlist));
			} else {
				cmdlist[0].value = (XtArgVal) init_colour(cp->c_fgr);
				cmdlist[1].value = (XtArgVal) init_colour(cp->c_bgr);
				cmdlist[2].value = (XtArgVal) cmdtrn;
				cmdlist[3].value = (XtArgVal) (pp = XtMalloc(MAXLABEL+1));
				l1 = strlen(cp->c_label);
				bcopy(cp->c_label, pp, l1);
				bcopy(blkstr, pp+l1, MAXLABEL-l1);
				*(pp+MAXLABEL) = '\0';
				gs->gs_cmdbw[i][j] = XtCreateManagedWidget("cmdb",
					commandWidgetClass, gs->gs_cmdbbw[i],
					cmdlist, XtNumber(cmdlist));
			}
			/* add the help for the button */
			strncpy(helpname, lp->l_label, NAMSIZ);
			helpname[NAMSIZ] = '\0';
			strncat(helpname, ".", NAMSIZ);
			helpname[NAMSIZ] = '\0';
			strncat(helpname, cp->c_label, NAMSIZ);
			helpname[NAMSIZ] = '\0';
			add_help(helpname, &(gs->gs_helphead), gs->gs_cmdbw[i][j]);
			j++;
			cp++;
		}
		gs->gs_cmdnum[i] = j;
		gs->gs_defcmdw[i] = gs->gs_cmdbw[i][0];
		i++;
		lp++;
	}
	reset_cmd(False);
}

reset_cmd(flag)
	Boolean flag;
{
	register GshState *gs = &gshstate;

	cmdpos = 1;
	csptr2 = "";
	csptr = &cmdstr[0];
	cmdstr[0] = '\0';
	gs->gs_name1.l_selnext = gs->gs_name2.l_selnext = NULL;
	gs->gs_endlp = &(gs->gs_namehead);
	if (flag) {
		if (!XtIsSensitive(gs->gs_cmdbbw[gs->gs_curtoplevel]))
			XtSetSensitive(gs->gs_cmdbbw[gs->gs_curtoplevel], True);
		disp_cmd();
	}
}

/*
 * Copy function to filter paths out of cmdstr for display.
 */
outcat(inp)
	char *inp;
{
	register char *p1, *p2;
	register int k;
	char *p3, *p4;
	int done;

	k = OUTSTRL-strlen(outstr);
	if (k == 0) return;
	if (k < 0) ferr(FER_OUTSTR);
	if (index(inp, '/') == NULL)
		strncat(outstr, inp, k);
	else {
		p1 = outstr;
		while (*p1 != '\0')
			p1++;
		p2 = inp;
		done = 0;
		do {
			while (*p2 == ' ')
				p2++;
			if ((p4 = index(p2, ' ')) == NULL)
				p4 = ((char *)0x7fffffff);
			/* No way of knowing if absolute path is name arg */
			if (*p2 == '.' && *(p2+1) == '/' && *(p2+2) != '\0') {
				p2 += 2;
			} else {
				while ((p3 = index(p2, '/')) != NULL && p3 < p4) {
					p2 = p3+1;
				}
			}
			if ((p3 = index(p2, '|')) != NULL) {
				while (k > 0 && p2 <= p3) {
					*p1++ = *p2++;
					k--;
				}
				if (k > 0) {
					*p1++ = ' ';
					k--;
				}
				*p1 = '\0';
				if (k == 0)
					done = 1;
			} else {
				if (k > 0)
					strncpy(p1, p2, k);
				outstr[OUTSTRL] = '\0';
				done = 1;
			}
		} while (!done);
	}
}

/*
 * This function runs a namefilter and collects the output of
 * it in a name arg string for setnameget.
 */
static int getfilternames(np, listp, num)
	NameConf *np;
	NameList **listp;
	int *num;
{
	register NameList *lp;
	register char *p, *p2;
	int pipfd[2], fpid;
	int j, len;
	NameList *olp;
	static char lbuf[MAXLINELEN+1];

	/* Init ptrs */
	lp = *listp;
	j = *num;
	if (pipe(pipfd) < 0)
		ferr(FER_NONAMEFILTERPIPE);
	/* Vfork child to run filter while parent reads pipe */
	if ((fpid = vfork()) == 0) {
		dup2(pipfd[1], 1);
		close(pipfd[1]);
		close(pipfd[0]);
		system(np->n_namefilter);
		_exit();
	} else {
		FILE *inf;
		close(pipfd[1]);
		if ((inf = fdopen(pipfd[0], "r")) == NULL)
			ferr(FER_NAMEFILTEREAD);
		p = lbuf;
		/* Read lines from filter until eof */
		while (fgets(p, MAXLINELEN, inf) != NULL) {
			olp = lp;
			/* Alloc NameList element, as required */
			if (lp->l_next == NULL) {
				if ((lp = creat_namelist()) == NULL) {
					err(ER_NOMEM);
					close(pipfd[0]);
					return(0);
				}
			} else
				lp = lp->l_next;
			/* Handle prefix as required */
			if (np->n_flags & N_PREFIX) {
				if ((p2 = index(p, ' ')) != NULL)
					len = p2-p;
				else
					len = 0;
				if (len > MAXPREFIX) {
					lp->l_prelabel[0] = lp->l_prelabel[1] = '.';
					bcopy(p+(len-MAXPREFIX+2),
						&(lp->l_prelabel[2]),
						MAXPREFIX-2);
					lp->l_prelabel[MAXPREFIX] = '\0';
				} else {
					if (len > 0) {
						bcopy(p, lp->l_prelabel, len);
					}
					bcopy(blkstr, lp->l_prelabel+len,
						MAXPREFIX-len);
					lp->l_prelabel[MAXPREFIX] = '\0';
				}
				/* Skip over blanks and set p */
				while (*p2 == ' ')
					p2++;
				p = p2;
			}
			/* Now set name and label */
			if ((p2 = index(p, ' ')) != NULL)
				*p2 = '\0';
			else if ((p2 = index(p, '\n')) != NULL)
				*p2 = '\0';
			len = strlen(p);
			if (len > MYMAXPATHLEN)
				len = MYMAXPATHLEN;
			if (len <= 0)
				cerr(ER_BADNAMEFILTER);
			/* Iff it doesn't pass regex, forget it */
			if (re_exec(p) == 0) {
				lp = olp;
				p = lbuf;
				continue;
			}
			bcopy(p, lp->l_name, len+1);
			if (len > MAXLABEL) {
				bcopy(p, lp->l_label, MAXLABEL-2);
				lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
				lp->l_label[MAXLABEL] = '\0';
			} else {
				bcopy(p, lp->l_label, len);
				bcopy(blkstr, lp->l_label+len, MAXLABEL-len);
				lp->l_label[MAXLABEL] = '\0';
			}
			j++;
			p = lbuf;
		}
		*num = j;
		*listp = lp;
		close(pipfd[0]);
	}
}

/*
 * Get name args off the arg list
 */
static int getnamevals(np, listp, num)
	NameConf *np;
	NameList **listp;
	int *num;
{
	register char **namep;
	register NameList *lp;
	register int j;
	NameList *olp;
	int len;

	j = *num;
	lp = *listp;
	namep = np->n_namevals;
	/* Generate the list from namevals */
	while (*namep != NULL) {
		olp = lp;
		/* Alloc NameList element, as required */
		if (lp->l_next == NULL) {
			if ((lp = creat_namelist()) == NULL) {
				err(ER_NOMEM);
				return(0);
			}
		} else
			lp = lp->l_next;
		/* Handle prefix as required */
		if (np->n_flags & N_PREFIX) {
			len = strlen(*namep);
			if (len > MAXPREFIX) {
				lp->l_prelabel[0] = lp->l_prelabel[1] = '.';
				bcopy((*namep)+(len-MAXPREFIX+2),
					&(lp->l_prelabel[2]),
					MAXPREFIX-2);
				lp->l_prelabel[MAXPREFIX] = '\0';
			} else {
				if (len > 0) {
					bcopy(*namep, lp->l_prelabel, len);
				}
				bcopy(blkstr, lp->l_prelabel+len,
					MAXPREFIX-len);
				lp->l_prelabel[MAXPREFIX] = '\0';
			}
			if (*++namep == NULL)
				cerr(ER_BADNAMEVALS);
		}
		/* Now set name and label */
		len = strlen(*namep);
		if (len > MYMAXPATHLEN)
			len = MYMAXPATHLEN;
		if (len <= 0)
			cerr(ER_BADNAMEFILTER);
		/* Iff it fails regex, forget it */
		if (re_exec(*namep) == 0) {
			lp = olp;
			namep++;
			continue;
		}
		bcopy(*namep, lp->l_name, len+1);
		if (len > MAXLABEL) {
			bcopy(*namep, lp->l_label, MAXLABEL-2);
			lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
			lp->l_label[MAXLABEL] = '\0';
		} else {
			bcopy(*namep, lp->l_label, len);
			bcopy(blkstr, lp->l_label+len, MAXLABEL-len);
			lp->l_label[MAXLABEL] = '\0';
		}
		j++;
		namep++;
	}
	*num = j;
	*listp = lp;
}

/*
 * Get file names from the subtree using np
 */
static int getfilenames(np, listp, dirname, num)
	NameConf *np;
	NameList **listp;
	char *dirname;
	int *num;
{
	register NameList *lp;
	register struct direct *dp;
	register NameList *dlp;
	register int j;
	DIR *dirp;
	char *pp;
	int len, prelen;
	NameList dlphead;
	static struct stat sb;
	static char dpath[MYMAXPATHLEN+1];

	/* Set up dpath with pp pointing to end of it */
	len = strlen(dirname);
	if (len >= MYMAXPATHLEN)
		return(0);
	if ((dirp = opendir(dirname)) == NULL)
		return(0);
	bcopy(dirname, dpath, len);
	pp = dpath+len;
	prelen = len;
	len = MYMAXPATHLEN-len;
	/* Init pointers */
	dlp = &dlphead;
	dlphead.l_next = NULL;
	lp = *listp;
	j = *num;
	/* Loop thru a dir looking for names and dirs */
	while ((dp = readdir(dirp)) != NULL) {
		/* Iff can't fit in MYMAXPATHLEN, forget it */
		if (dp->d_namlen > len)
			continue;
		bcopy(dp->d_name, pp, dp->d_namlen+1);
		/* Now, check out the name to see if we want it */
		if (stat(dpath, &sb) < 0)
			continue;
		if (re_exec(dp->d_name) && access(dpath, np->n_access) == 0 &&
			(sb.st_mode & np->n_modes)) {
			/* Alloc NameList element, as required */
			if (lp->l_next == NULL) {
				if ((lp = creat_namelist()) == NULL) {
					err(ER_NOMEM);
					closedir(dirp);
					return(0);
				}
			} else
				lp = lp->l_next;
			/* Handle prefix as required */
			if (np->n_flags & N_SUBTREE) {
				if (prelen > MAXPREFIX) {
					lp->l_prelabel[0] = lp->l_prelabel[1] = '.';
					bcopy(&dpath[len-MAXPREFIX+2],
						&(lp->l_prelabel[2]),
						MAXPREFIX-2);
					lp->l_prelabel[MAXPREFIX] = '\0';
				} else {
					if (prelen > 0) {
						bcopy(dpath, lp->l_prelabel, prelen);
					}
					bcopy(blkstr, lp->l_prelabel+prelen,
						MAXPREFIX-prelen);
					lp->l_prelabel[MAXPREFIX] = '\0';
				}
			}
			/* Now set name and label */
			bcopy(dpath, lp->l_name, prelen+dp->d_namlen+1);
			if (dp->d_namlen > MAXLABEL) {
				bcopy(dp->d_name, lp->l_label, MAXLABEL-2);
				lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
				lp->l_label[MAXLABEL] = '\0';
			} else {
				bcopy(dp->d_name, lp->l_label, dp->d_namlen);
				bcopy(blkstr, lp->l_label+dp->d_namlen, MAXLABEL-dp->d_namlen);
				lp->l_label[MAXLABEL] = '\0';
			}
			j++;
		}
		/* Iff subtree and a subdir and fits in MYMAXPATHLEN */
		if ((np->n_flags & N_SUBTREE) && (sb.st_mode & S_IFDIR) &&
			(dp->d_namlen < len) &&
			strcmp(dp->d_name, ".") != NULL &&
			strcmp(dp->d_name, "..") != NULL) {
			if ((dlp->l_next = (NameList *)malloc(sizeof(NameList)))
				== NULL) {
				err(ER_NOMEM);
				closedir(dirp);
				dlp = dlphead.l_next;
				while (dlp != NULL) {
					lp = dlp;
					dlp = dlp->l_next;
					free((caddr_t) lp);
				}
				return(0);
			}
			dlp = dlp->l_next;
			dlp->l_next = NULL;
			bcopy(dpath, dlp->l_name, prelen+dp->d_namlen);
			/* append / to path */
			dlp->l_name[prelen+dp->d_namlen] = '/';
			dlp->l_name[prelen+dp->d_namlen+1] = '\0';
		}
	}
	/* Update ret vals. */
	*num = j;
	*listp = lp;
	closedir(dirp);
	/* Iff subtree, recurse thru subdirs */
	if ((np->n_flags & N_SUBTREE) && dlphead.l_next != NULL) {
		lp = dlphead.l_next;
		while (lp != NULL) {
			getfilenames(np, listp, lp->l_name, num);
			dlp = lp;
			lp = lp->l_next;
			free((caddr_t) dlp);
		}
	}
}

/*
 * Get a name arg list for NameConf
 */
int get_name(np, nameret)
	register NameConf *np;
	NameList *nameret;
{
	register GshState *gs = &gshstate;
	int j;
	NameList *lp, *lp2;
	int len;
	static char dirpth[MYMAXPATHLEN+1];

	XDefineCursor(gs->gs_disp, gs->gs_rootwin, gs->gs_fullhrcursor);
	j = 0;
	lp2 = lp = gs->gs_endlp;
	if (re_comp(np->n_namereg) != 0)
		cerr(ER_BADNAMEREG);
	if (np->n_flags & N_NAMEFILTER)
		getfilternames(np, &lp, &j);
	if (np->n_flags & N_NAMEVALS)
		getnamevals(np, &lp, &j);
	if (np->n_flags & N_FILES) {
		len = strlen(np->n_dirpath);
		if (len >= MYMAXPATHLEN)
			cerr(ER_BADDIRPATH);
		if (*(np->n_dirpath+len-1) != '/') {
			bcopy(np->n_dirpath, dirpth, len);
			dirpth[len] = '/';
			dirpth[len+1] = '\0';
			getfilenames(np, &lp, dirpth, &j);
		} else
			getfilenames(np, &lp, np->n_dirpath, &j);
	}
	gs->gs_endlp = lp;
	XDefineCursor(gs->gs_disp, gs->gs_rootwin, gs->gs_hrcursor);
	setnameget(np, lp2, j, nameret);
}

/*
 * Creates new NameList elements and fills in widgets
 *   widgets are not managed until setnameget does it
 */
NameList *creat_namelist()
{
	register GshState *gs = &gshstate;
	register NameList *lp, *lp2;
	register GshConf *gc = gconfptr;
	register int i;
	NameList *lp3;
	Widget *wp, *wp2;
	Widget tw, fw, vw;
	char geom[30];
	char *pp;
	int widv;
	XtTranslations cmdtrn;
	static char viewtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static char bboxtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static XtCallbackRec	helpcall[] = {
		{ help_call,	NULL },
		{ NULL,		NULL },
	};
	static Arg viewlist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNallowVert,		(XtArgVal) True},
	};
	static Arg		viewtitlelist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) "Name Selections"},
	};
	static Arg		bboxlist[] = {
		{XtNborderWidth,	(XtArgVal)NULL},
		{XtNbackground,		(XtArgVal)NULL},
		{XtNtranslations,	(XtArgVal)NULL},
		{XtNwidth,		(XtArgVal)NULL},
		{XtNheight,		(XtArgVal)NULL},
		{XtNcallback,		(XtArgVal)helpcall},
	};
	static Arg popup_args[] = {
		{XtNx, (XtArgVal) NULL},
		{XtNy, (XtArgVal) NULL},
		{XtNgeometry, (XtArgVal) NULL},
		{XtNallowShellResize, (XtArgVal) False},
		{XtNsaveUnder, (XtArgVal) True},
	};
	static XtCallbackRec cmdcall[] = {
		{name_input,	NULL},
		{NULL,		NULL},
	};
	static Arg labellist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNfont,	(XtArgVal) NULL},
		{XtNborderWidth, (XtArgVal) 0},
	};
	static Arg nonamelist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) NONAMEMSG},
	};
	static Arg cmdlist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNfont,	(XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) cmdcall},
	};
	static char cmdtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		<Btn2Up>:	notify(Help) disablenotify() \n\
		<Btn3Down>:	enablenotify() \n\
		<Btn3Up>:	notify(Pop) disablenotify()";
	static int xpos, ypos, wid;
	static Arg getvals[] = {
		{XtNx,		(XtArgVal) &xpos},
		{XtNy,		(XtArgVal) &ypos},
		{XtNwidth,	(XtArgVal) &wid},
	};
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) NULL},
		{XtNy,		(XtArgVal) NULL},
	};
	Widget cw1, cw2, cw3;

	/* If one exists, delete name panel */
	if (name_w != NULL) {
#ifdef SAFE
		/* Super Kludge, but how else can you avoid XtMalloc() fails */
		/* 1000 is a guess, must be > mem required for 2 cmd widgets */
		if ((pp = malloc(NAMEBLOCK*1000)) == NULL)
			return(NULL);
		else
			free(pp);
#endif
		XtDestroyWidget(name_w);
	}
	/* Create NAMEBLOCK more namelist entries */
	lp2 = gs->gs_endname;
	for (i = 0; i < NAMEBLOCK; i++) {
		if ((lp = (NameList *)malloc(sizeof(NameList))) == NULL) {
			lp = gs->gs_endname->l_next;
			while (lp != NULL) {
				lp2 = lp;
				lp = lp->l_next;
				free((caddr_t) lp2);
			}
			gs->gs_endname->l_next = NULL;
			return(NULL);
		}
		if (i == 0)
			lp3 = lp;
		lp2->l_next = lp;
		lp2 = lp;
		lp->l_flags = 0;
		lp->l_next = NULL;
	}
	XtGetValues(gs->gs_cmdw[gs->gs_curtoplevel], getvals, 3);
	setpos[0].value = (XtArgVal) ttyx = xpos+wid+20;
	setpos[1].value = (XtArgVal) ttyy = ypos+20;
	/* Create name selection popup panel */
	widv = gs->gs_basefont->max_bounds.width;
	labellist[2].value = (XtArgVal) (MAXPREFIX*widv+20);
	cmdlist[2].value = (XtArgVal) (MAXLABEL*widv+20);
	nonamelist[2].value = viewtitlelist[2].value = labellist[2].value+cmdlist[2].value;
	labellist[3].value = cmdlist[3].value = (XtArgVal) gs->gs_basefont;
	widv = viewtitlelist[2].value+40;
	sprintf(geom, "%dx%d", widv, NAMEHEIGHT);
	popup_args[2].value = (XtArgVal) geom;
	name_w = XtCreatePopupShell("names", transientShellWidgetClass,
		gs->gs_toplw, popup_args, XtNumber(popup_args));
	title_creat(name_w, gc->gc_namefgr, gc->gc_namebgr, widv-10,
		"Name", namectrl_input, &(gs->gs_helphead),
		(gc->gc_flags & G_ICONCTRL), "Newname", newname_bits,
		newname_width, newname_height, 
		&fw, &cw1, &cw2, &cw3, &newicon_w, &tw);
	viewlist[0].value = (XtArgVal) viewfgr;
	viewlist[1].value = (XtArgVal) viewbgr;
	viewlist[2].value = (XtArgVal) cw1;
	name_vieww = vw = XtCreateManagedWidget("nview", viewportWidgetClass, fw,
		viewlist, XtNumber(viewlist));
	/* and a button box in the viewport for the names and prefixes */
	viewtitlelist[0].value = bboxlist[0].value = (XtArgVal) viewboxfgr;
	viewtitlelist[1].value = bboxlist[1].value = (XtArgVal) viewboxbgr;
	bboxlist[2].value = (XtArgVal) XtParseTranslationTable(bboxtrans);
	viewbox_w = XtCreateManagedWidget("viewb", boxWidgetClass, vw,
		bboxlist, XtNumber(bboxlist));
	/* And title in buttonbox (mainly for width) */
	XtCreateManagedWidget("viewtitle", labelWidgetClass, viewbox_w,
		viewtitlelist, XtNumber(viewtitlelist));
	nonamelist[0].value = (XtArgVal) namefgr;
	nonamelist[1].value = (XtArgVal) namebgr;
	noname_labelw = XtCreateWidget("noname", labelWidgetClass, viewbox_w,
		nonamelist, XtNumber(nonamelist));
	labellist[0].value = (XtArgVal) namefgr;
	labellist[1].value = (XtArgVal) namebgr;
	cmdlist[0].value = (XtArgVal) namefgr;
	cmdlist[1].value = (XtArgVal) namebgr;
	gs->gs_endname = lp;
	lp = gs->gs_namehead.l_next;
	i = 0;
	cmdtrn = XtParseTranslationTable(cmdtrans);
	while (lp != NULL) {
		lp->l_prew = XtCreateWidget("prew", labelWidgetClass, viewbox_w,
			labellist, XtNumber(labellist));
		cmdcall[0].closure = (caddr_t) lp;
		lp->l_w = XtCreateWidget("labw", commandWidgetClass, viewbox_w,
			cmdlist, XtNumber(cmdlist));
		XtOverrideTranslations(lp->l_w, cmdtrn);
		lp = lp->l_next;
		i++;
	}
	i *= 2;
	lp = gs->gs_namehead.l_next;
	wp = wp2 = (Widget *)malloc(i*sizeof(Widget));
	if (wp == NULL) {
		lp = gs->gs_namehead.l_next;
		while (lp != NULL) {
			lp2 = lp;
			lp = lp->l_next;
			free((caddr_t) lp2);
		}
		name_w = (Widget)NULL;
		gs->gs_namehead.l_next = NULL;
		gs->gs_endlp = gs->gs_endname = &(gs->gs_namehead);
		return(NULL);
	}
	while (lp != NULL) {
		*wp++ = lp->l_w;
		*wp++ = lp->l_prew;
		lp = lp->l_next;
	}
	XtManageChildren(wp2, i);
	XtSetValues(name_w, setpos, 2);
	XtRealizeWidget(name_w);
	XtUnmanageChildren(wp2, i);
	return(lp3);
}

