/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Routines for inter proc. comm using properties
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Xlib.h>

/*
 * Send len bytes of data in buf to property prop
 */
send_prop(prop, buf, len)
	int prop;
	char *buf;
	int len;
{
fprintf(stderr,"send prop=%d buf=%s\n",prop, buf);
}

/*
 * Init the icc data structures, must be called after XtRealize but
 * before the input loop.
 */
void init_icc(disp, win)
	Display *disp;
	Window win;
{
	XWindowAttributes win_at;
	long msk;

	icc_win = win;
	icc_disp = disp;
	XGetWindowAttributes(disp, win, &win_at);
	msk = (win_at.your_event_mask|XX);
	XSelectInput(disp, win, msk);
	icc_selhead.l_next = icc_gethead.l_next = NULL;
	icc_msgsize = disp->max_request_size;
	icc_time = CurrentTime;
}

/*
 * Set up data for a selection, if not already setup, setowner...
 */
Boolean set_select(seln, buf, len)
	Atom seln;
	char *buf;
	long len;
{
	register PropList *lp;

	lp = find_selection(&icc_selhead, seln, &olp, 0);
	/* if data save it */
	if (len > 0) {
		dp = (DataList *)XtMalloc(sizeof(DataList)+len);
		dp->d_next = NULL;
		dp->d_len = len;
		bcopy(buf, dp->d_data, len);
	} else {
		dp = NULL;
	}
	/* Iff NULL, not set up yet */
	if (lp == NULL) {
		XSetSelectionOwner(icc_disp, seln, icc_win, icc_time);
		if (XGetSelectionOwner(icc_disp, seln) != icc_win)
			return(False);
		lp = (PropList *)XtMalloc(sizeof(PropList));
		olp->l_next = lp;
		lp->l_next = NULL;
		lp->l_seln = seln;
		lp->l_time = icc_time;
		lp->l_type = type;
		lp->l_len = len;
		lp->l_flags = 0;
		lp->l_offset = 0;
		lp->l_data = lp->l_lastdata = dp;
		return(True);
	} else {
		if (append_flag) {
			lp->l_lastdata->d_next = dp;
			lp->l_lastdata = dp;
			lp->l_len += len;
		} else {
			if (lp->l_flags & ICC_INCR)
				return(False);
			dp2 = lp->l_data;
			while (dp2 != NULL) {
				odp = dp2;
				dp2 = dp2->d_next;
				XtFree((caddr_t) dp2);
			}
			lp->l_lastdata = lp->l_data = dp;
			lp->l_len = len;
		}
	}
	return(True);
}

/*
 * Set up to get a selection via. properties.
 * essentially fill in a header struct and do xconvertselection
 */
Boolean get_select(seln, type)
	Atom seln;
	Atom type;
{
	register PropList *lp;
	PropList *olp;

	lp = find_selection(&icc_gethead, seln, &olp, 0);
	if (lp == NULL) {
		olp->l_next = lp = (PropList *)XtMalloc(sizeof(PropList));
		lp->l_next = NULL;
		lp->l_seln = seln;
		lp->l_type = type;
		lp->l_flags = lp->l_len = 0;
	}
	if (lp->l_flags == 0) {
		lp->l_time = icc_time;
		XConvertSelection(icc_disp, seln, type, None, icc_win, icc_time);
	}
	return(True);
}

/*
 * The biggie, handle events related to the transfers.
 * MUST be called between XtNextEvent and XtDispatch event
 * returns a Boolean that tells you iff XtDispatchEvent should be called
 * for the event.
 */
Boolean event_icc(ev)
	XEvent *ev;
{

	aev = (AnyEvent *)ev;
	/* First update time iff you can */
	switch(aev->type) {
	case ButtonPress:
		icc_time = ((ButtonEvent *)aev)->time;
		return(True);
	};
	/* Iff not for icc_win, bye */
	if (aev->window != icc_win)
		return(True);
	/* Now look for icc related events */
	switch(aev->type) {
	case Selection:
		snev = (SelectionEvent *)aev;
		if ((lp = find_selection(&icc_gethead, snev->selection, &olp, 0)) == NULL)
			return(False);
		if (snev->property == None) {
Failsel:
			olp->l_next = lp->l_next;
			(*(icc_getfunc))(snev->selection, NULL, 0);
			XtFree((caddr_t) lp);
			return(False);
		}
		if (snev->target == INCR) {
			lp->l_flags |= ICC_INCR;
			lp->l_incrprop = snev->property;
			XGetWindowProperty(icc_disp, snev->requestor,
				snev->property, 0, icc_maxreq, False, snev->target,
				&rtyp, &fmt, &nret, &rem, &p);
			if (nret != INCRSIZ || rem != 0 || rtyp != INCR) {
				XDeleteProperty(icc_disp, snev->requestor,
					snev->property);
				goto Failsel;
			}
			lp->l_xferw = ((Incr *)p)->win;
			lp->l_xferp = ((Incr *)p)->prop;
		} else {
			lp->l_xferw = snev->requestor;
			lp->l_xferp = snev->property;
		}
		getdat(lp);
		return(False);
	case PropertyNotify:
		pev = (PropertyNotifyEvent *)aev;
		if (pev->state == NewValue) {
			if ((lp = find_property(&icc_gethead, pev->atom,
				&olp)) == NULL)
				return(False);
			getdat(lp);
			return(False);
		} else {
			if ((lp = find_property(&icc_selhead, pev->atom, &olp))
				== NULL)
				return(false);
			putdat(lp);
			putnotify(lp->l_xferw, lp->l_seln, lp->l_type,
				lp->l_xferp);
			return(False);
		}
	case SelectionRequest:
		srev = (SelectionRequestEvent *)aev;
		if (srev->owner != icc_win || (lp = find_selection(
			&icc_selhead, srev->selection, &olp, srev->time))
			== NULL) {
			putnotify(srev->selection, srev->requestor,
				None, None);
			return(False);
		}
		lp->l_rtype = srev->target;
		incrp->win = lp->l_xferw = srev->requestor;
		incrp->prop = lp->l_xferp = XX;
		putdat(lp);
		if (lp->l_len > (icc_maxreq-MARGIN)) {
			icc_changefailed = False;
			XChangeProperty(icc_disp, srev->requestor, INCR, INCR,
				FMTINCR, PropModeReplace, (caddr_t) incrp,
				INCRSIZ);
			XSync(icc_disp, False);
			if (icc_changefailed) {
				putnotify(srev->selection, srev->requestor,
				None, None);
			} else {
				putnotify(srev->selection, srev->requestor,
					INCR, INCR);
			}
		} else {
			putnotify(srev->selection, srev->requestor,
				lp->l_xferp, lp->l_type);
		}
		return(False);
	default:
		return(True);
	};
}

