/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * These functions display and delete a help window related to a panel.
 * The help window is displayed whenever the middle mouse button is
 * pressed in a panel and zapped when the middle mouse button is pressed
 * inside a help window.
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/AsciiText.h>
#include <X11/Shell.h>
#include <X11/Form.h>
#include "../include/tar.h"
#include "../include/help.h"

#define FER_BADHELPLIB	"Bad Help Library"
extern Widget toplevel;
extern Pixel init_colour();

/* Cant help message */
static char *cant_help = "Sorry, can't Help";
static Pixel help_fgr, help_bgr;
static Widget help_parentw;

/*
 * Initialize the help window text lists from the help library.
 * The help lib is just a tar(5) archive of text messages that are
 * looked up by name through add_help().
 */
init_help(helplib, helphead, popuphead, fgrc, bgrc)
	char *helplib;
	HelpList *helphead;
	HelpList *popuphead;
	char *fgrc, *bgrc;
{
	register HelpList *hl;
	FILE *hf;
	union hblock hblk;
	char *p;
	int l;

	help_parentw = toplevel;
	helphead->hl_next = (HelpList *) NULL;
	popuphead->hl_next = (HelpList *) NULL;
	help_fgr = init_colour(fgrc);
	help_bgr = init_colour(bgrc);
	if (*helplib != NULL && (hf = fopen(helplib, "r")) != NULL) {
		/* Read the tar file and create a linked list of the
		   messages */
		while (fread(&hblk, sizeof(hblk), 1, hf) == 1 
			&& hblk.dbuf.name[0] != '\0') {
			hl = (HelpList *) XtMalloc(sizeof(HelpList));
			/* Paranoia, just make sure its null terminated. */
			strncpy(&(hl->hl_name[0]), hblk.dbuf.name, NAMSIZ);
			hl->hl_name[NAMSIZ] = '\0';
			sscanf(hblk.dbuf.size, "%12O", &l);
			p = XtMalloc(l+1);
			if (fread(p, l, 1, hf) != 1)
				serr(FER_BADHELPLIB);
			if ((l % TBLOCK) != 0)
				if (fread(&hblk,TBLOCK-(l%TBLOCK),1,hf) != 1)
					serr(FER_BADHELPLIB);
			*(p+l) = '\0';
			if (l % 1)
				getc(hf);
			hl->hl_help = p;
			hl->hl_flags = 0;
			hl->hl_popnext = (HelpList *) NULL;
			hl->hl_next = helphead->hl_next;
			helphead->hl_next = hl;
		}
		fclose(hf);
	}
}

/*
 * Add a widget id into the help list
 * Essentially, search for the name and fill in the widget id iff found
 */
HelpList *add_help(name, helphead, w)
	char *name;
	HelpList *helphead;
	Widget w;
{
	register HelpList *hp;

	hp = helphead->hl_next;
	/* Loop through the list */
	while (hp != NULL) {
		if (strcmp(name, hp->hl_name) == 0) {
			hp->hl_widget = w;
			hp->hl_flags |= HL_SET;
			return(hp);
		}
		hp = hp->hl_next;
	}
	return(hp);
}

static void popdown_help();
/*
 * Popup a help window for widget w
 *	create the popup shell as required
 */
popup_help(helphead, popuphead, w)
	HelpList *helphead, *popuphead;
	Widget w;
{
	register HelpList *hp;
	Widget tw;
	Window ww, wt;
	int xt, yt, mt;
	static int xpos, ypos, wid, high;
	static char newtrans[] =
		"<Btn2Down>: enablenotify() \n\
		<Btn2Up>: notify(Help) disablenotify()";
	static XtCallbackRec argcall[] = {
		{popdown_help,	NULL},
		{NULL,		NULL},
	};
	static Arg arglist[] = {
		{XtNstring, (XtArgVal) NULL},
		{XtNlength, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) 2},
		{XtNheight,	(XtArgVal) 2000},
		{XtNtextOptions, (XtArgVal) (resizeHeight|resizeWidth)},
		{XtNeditType, (XtArgVal) XttextRead},
		{XtNtranslations, (XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) argcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg popuplist[] = {
		{XtNx, (XtArgVal) NULL},
		{XtNy, (XtArgVal) NULL},
		{XtNgeometry,	(XtArgVal) NULL},
		{XtNallowShellResize, True},
		{XtNsaveUnder, True},
	};
	static Arg getsiz[] = {
		{XtNwidth,	(XtArgVal) &wid},
		{XtNheight,	(XtArgVal) &high},
	};
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) 0},
		{XtNy,		(XtArgVal) 0},
	};

	hp = helphead->hl_next;
	/* Loop through the list to find the message for widget w */
	while (hp != NULL) {
		if ((hp->hl_flags & HL_SET) && (hp->hl_widget == w)) {
			break;
		}
		hp = hp->hl_next;
	}
	/* Iff not found, pop up cant_help */
	if (hp == NULL) {
		if ((hp = (HelpList *)XtMalloc(sizeof(HelpList))) == NULL) {
			err("No Memory, zap Windows!!");
			return;
		}
		hp->hl_flags = HL_SET;
		hp->hl_widget = w;
		hp->hl_help = cant_help;
		hp->hl_popnext = (HelpList *)NULL;
		hp->hl_next = helphead->hl_next;
		helphead->hl_next = hp;
	}
	/* Pop it up, iff it isn't already */
	if (hp->hl_flags & HL_POPPED)
		return;
	/* Create it if not yet done */
	if ((hp->hl_flags & HL_POPWIDGET) == 0) {
		/* It's fun trying to make Text do this */
		arglist[0].value = (XtArgVal) hp->hl_help;
		arglist[1].value=(XtArgVal)strlen(hp->hl_help);
		arglist[6].value = (XtArgVal)
			XtParseTranslationTable(newtrans);
		arglist[8].value = (XtArgVal) help_fgr;
		arglist[9].value = (XtArgVal) help_bgr;
		hp->hl_popupw = XtCreatePopupShell("poph",
			transientShellWidgetClass, help_parentw,
			popuplist, XtNumber(popuplist));
		argcall[0].closure = (caddr_t) popuphead;
		hp->hl_poptw = XtCreateManagedWidget("popt", asciiStringWidgetClass,
			hp->hl_popupw, arglist,
			XtNumber(arglist));
		XtTextResize(hp->hl_poptw);
		XtRealizeWidget(hp->hl_popupw);
		hp->hl_flags |= HL_POPWIDGET;
	}
	/* find location in root window and pop it up */
	XQueryPointer(XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),
		&ww, &wt, &xpos, &ypos, &xt, &yt, &mt);
	XtGetValues(hp->hl_popupw, getsiz, 2);
	if (xpos > 10)
		xpos -= 10;
	else
		xpos = 0;
	if (ypos > 10)
		ypos -= 10;
	else
		ypos = 0;
	if ((xpos+wid+2) > WidthOfScreen(XtScreen(w)))
		xpos = WidthOfScreen(XtScreen(w))-wid-2;
	if ((ypos+high+2) > HeightOfScreen(XtScreen(w)))
		ypos = HeightOfScreen(XtScreen(w))-high-2;
	setpos[0].value = (XtArgVal) xpos;
	setpos[1].value = (XtArgVal) ypos;
	XtSetValues(hp->hl_popupw, setpos, 2);
	XtPopup(hp->hl_popupw, XtGrabNone);
	hp->hl_flags |= HL_POPPED;
	/* Add to linked list of popped up help widgets */
	hp->hl_popnext = popuphead->hl_popnext;
	popuphead->hl_popnext = hp;
}

/*
 * Erase all popup help windows
 */
static void popdown_help(w, poph, p2)
	Widget w;
	caddr_t poph;
	caddr_t p2;
{
	register HelpList *hp, *ohp;

	if (p2 == NULL || *p2 != 'H')
		return;
	ohp = (HelpList *)poph;
	hp = ohp->hl_popnext;
	ohp->hl_popnext = (HelpList *) NULL;
	/* Loop through popped up help widgets and pop them down */
	while (hp != NULL) {
		if (hp->hl_flags & HL_POPPED) {
			XtPopdown(hp->hl_popupw);
			hp->hl_flags &= ~HL_POPPED;
		}
		ohp = hp;
		hp = hp->hl_popnext;
		ohp->hl_popnext = NULL;
	}
}

/*
 * Set parent widget for help
 */
void help_setparent(pw)
	Widget pw;
{
	help_parentw = pw;
}

