/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include "Xsdemo.h"
#include <stdio.h>
#include <math.h>
#include "cross_weave"
char *titles[] = { "  Bubble Sort   ",
	           "   Shell Sort   ",
	           "  Exchange Sort ",
	           "   Quick Sort   ",
	           " Exit Sort Demo " };
char *text1[] = {
		"Sorted = False                           ",
		"While (Sorted == False){                 ",
		"   Sorted = True;                        ",
		"   for ( i = 0; i < numtosort - 1; i++){ ",
		"        if(element[i] > element[i+1]){   ",
		"              holder = element[i];       ",
		"              element[i] = element[i+1]; ",
		"              element[i+1] = holder;     ",
		"              Sorted = False;            ",
		"         }                               ",
		"    }                                    ",
		"}                                        "};


char *text2[] = {
		"Sorted = False                               ",
		"gap = numtosort/2                            ",
		"While (gap > 0){                             ",
		"     While (Sorted == False){                ",
		"     Sorted = True;                          ",
		"     for ( i = 0; i < numtosort - gap; i++){ ",
		"          if(element[i] > element[i+gap]){   ",
		"                holder = element[i];         ",
		"                element[i] = element[i+gap]; ",
		"                element[i+gap] = holder;     ",
		"                Sorted = False;              ",
		"           }                                 ",
		"      }                                      ",
		"      Sorted = False                         ",
		"      gap = gap/2;                           ",
		"}                                            "};

char *text3[] = {
		"bounds = 0                               ",
		"for (i = 0; i < numtosort - 1; i++){     ",
		"   bounds = bounds + 1;                  ",
		"   for ( j = 0; j < numtosort; i++){     ",
		"        if (element[i] > element[j]){    ",
		"              holder = element[i];       ",
		"              element[i] = element[j];   ",
		"              element[j] = holder;       ",
		"         }                               ",
		"    }                                    ",
		"}                                        "};

char *text4[] = {
		"quicksort(numarray,left,right)                             ",
		"          int numarray[];                                  ",
		"          int left,right;                                  ",
		"{                                                          ",
		"     int i,j,x,holder;                                     ",
		"                                                           ",
		"     i = left; j = right; x = left;                        ",
		"     do{                                                   ",
		"          while((numarray[i] < numarray[x]) && (i < right))",
		"              i++;                                         ",
		"          while((numarray[x] < numarray[j]) && (j > left)) ",
		"              j--;                                         ",
		"          if( i <= j){                                     ",
		"              holder = numarray[i];                        ",
		"              numarray[i] = numarray[j];                   ",
		"              numarray[j] = holder;                        ",
		"              i++; j--;                                    ",
		"          }                                                ",
		"      } while (i <= j);                                    ",
		"      if( left < j )                                       ",
		"          quicksort(numarray,left,j);                      ",
		"      if( i < right)                                       ",
		"          quicksort(numarray,i,right);                     ",
		"}                                                          "};

GC swinGC,normGC,invrGC,crossweaveGC,butGC,invrbutGC;
XGCValues value;
XFontStruct *tfn,*srcfn,*but;
char *dpyname = NULL;
Display *display;
int screen;
char *fn = "vri-31",*sfn = "6x10",*butfn = "serifb10";
struct src bubble;

main(argc,argv)
	int argc;
	char **argv;
{
	Window testw,srcwin,sortwin,wdef[NUMT];
        int sortarray[MAX_NUM_ELEM];
	struct elementrep bararray[MAX_NUM_ELEM];
        int numelement,string_width,status;
	int titlepos[NUMT][2];
	Pixmap crossweave;	
	XEvent event;
	Cursor arrow,trek;
	int cursor_shape1,cursor_shape2;
	int oldchoice = -1,newchoice = -1,Continue = 1, gotit,i,j;

	/*
	 * try to open the display .. if it can't be
	 * opened we are in trouble so exit
	 */

	while (*++argv) 
		if (!strcmp (*argv, "-display")) 
			dpyname = *++argv;
	if((display = XOpenDisplay(dpyname)) == NULL){
            fprintf(stderr,"Could not open Display %s\n",XDisplayName(NULL));
            exit(-1);
        }
	screen = DefaultScreen(display);	
	/*
	 * try to get the font for the title window.
	 * if we can't open it or query it then exit.
	 */

	if ((tfn = XLoadQueryFont(display,fn)) == NULL) {
               fprintf(stderr,"SortDemo: Could not load font -> %s\n",fn);
               exit(1);
	}

	if ((srcfn = XLoadQueryFont(display,sfn)) == NULL) {
               fprintf(stderr,"SortDemo: Could not load font -> %s\n",sfn);
               exit(1);
	}
	
	if ((but = XLoadQueryFont(display,butfn)) == NULL) {
               fprintf(stderr,"SortDemo: Could not load font -> %s\n",butfn);
               exit(1);
	}
	/*
         * Create Pixmaps for tiling stippling etc.
	 */

      crossweave = XCreatePixmapFromBitmapData(display,
	            RootWindow(display,screen),
		    cross_weave_bits,cross_weave_width,cross_weave_height,
		    WhitePixel(display,screen),BlackPixel(display,screen),
		    DefaultDepth(display,screen));

	/*
	 * Create GC's for our demo
	 */

	value.foreground = BlackPixel(display,screen);
	value.background = WhitePixel(display,screen);
	value.font = srcfn->fid;
	swinGC = XCreateGC(display,RootWindow(display,screen),
		    GCForeground|GCBackground|GCFont,
		    &value);	

	value.foreground = BlackPixel(display,screen);
	value.background = WhitePixel(display,screen);
	value.line_width = 1;
	value.fill_style = FillSolid;
	value.font = tfn->fid;
	normGC = XCreateGC(display,RootWindow(display,screen),
  	        GCForeground|GCBackground|GCFillStyle|GCFont|GCLineWidth,
		    &value);
	value.foreground = BlackPixel(display,screen);
	value.background = WhitePixel(display,screen);
	value.font = but->fid;
	butGC = XCreateGC(display,RootWindow(display,screen),
		    GCForeground|GCBackground|GCFont,
		    &value);
	value.foreground = WhitePixel(display,screen);
	value.background = BlackPixel(display,screen);
	value.font = but->fid;
	invrbutGC = XCreateGC(display,RootWindow(display,screen),
		    GCForeground|GCBackground|GCFont,
		    &value);
	value.foreground = BlackPixel(display,screen);
	value.background = WhitePixel(display,screen);
	value.line_width = 1;
	value.fill_style = FillTiled;
	value.tile = crossweave;
	crossweaveGC = XCreateGC(display,RootWindow(display,screen),
  	        GCForeground|GCBackground|GCFillStyle|GCTile|GCLineWidth,
		    &value);

	/*
         * Create the main window, the demo window and the button windows 
	 */

	testw = XCreateSimpleWindow(display,RootWindow(display,screen),
			WINX,WINY,WINW,WINH,BDRW,BlackPixel(display,screen),
			WhitePixel(display,screen));
	XSelectInput(display,testw, (ExposureMask));
	sortwin = XCreateSimpleWindow(display,testw,
			SORTX,SORTY,SORTW,SORTH,BDRW,BlackPixel(display,screen),
			WhitePixel(display,screen));
	XSelectInput(display,sortwin, (ExposureMask));
	cursor_shape1 = XC_arrow;
	arrow = XCreateFontCursor(display,cursor_shape1);
	XDefineCursor(display,testw,arrow);
	cursor_shape2 = XC_trek;
	trek = XCreateFontCursor(display,cursor_shape2);
	XDefineCursor(display,sortwin,trek);
	XMapWindow(display,testw);
	XMapWindow(display,sortwin);
        redrawt(testw);
	maketwins(testw,wdef,titlepos);
	XFlush(display);
	for (i = 0; i < NUMT;i++)
		XSelectInput(display,wdef[i],(ExposureMask|ButtonPressMask));
	while(Continue){
		i = -1;
		gotit = 0;
		XNextEvent(display,&event);
		switch(event.type){
			case ButtonPress:	
				gotit = 0;
				while(!gotit){
					i+=1;
					if(event.xbutton.window == wdef[i])
						gotit = 1;
					if (i >= NUMT){
						gotit = 1;
						i = -1;
					}
				}
				gotit=0;
				break;
		case Expose:
			j = -1;
			if(event.xexpose.window == wdef[0]) j = 0;
			if(event.xexpose.window == wdef[1]) j = 1;
			if(event.xexpose.window == wdef[2]) j = 2;
			if(event.xexpose.window == wdef[3]) j = 3;
			if(event.xexpose.window == wdef[4]) j = 4;
			if (j >= 0 && j < 5)
				redrawtitle(wdef[j],titlepos[j][0],titlepos[j][1],j);
			if(event.xexpose.window == testw)
				redrawt(testw);
			break;
		default : i = -1;
			  break;
		}
	newchoice = i;
	hilite(wdef,titlepos,newchoice,oldchoice);
	XFlush(display);
	if((srcwin) && (i != -1)){
		XDestroyWindow(display,srcwin);
		srcwin = NULL;
	}
	if(i >= 0 && i < 4){
		XClearWindow(display,sortwin);XFlush(display);
        	getrandom(sortarray,NUMBARS,SORTWINH);
       	 	initializebars(sortwin,sortarray,bararray,NUMBARS);
		drawscr(sortwin,bararray,NUMBARS);
	}

	switch (i){
		case 0:
			createsrc(text1,0);
			makesrc(sortwin,&srcwin);
			XMapWindow(display,srcwin);
			drawsrc(srcwin);
			XFlush(display);
			bubblesort(sortwin,srcwin,sortarray,bararray,NUMBARS);
        		XFlush(display);
			oldchoice = 0;
			newchoice = -1;
			break;

		case 1:
			createsrc(text2,1);
			makesrc(sortwin,&srcwin);
			XMapWindow(display,srcwin);
			drawsrc(srcwin);
			XFlush(display);
			shellsort(sortwin,srcwin,sortarray,bararray,NUMBARS);
			XFlush(display);
			oldchoice = 1;
			newchoice = -1;
			break;
		case 2:
			createsrc(text3,2);
			makesrc(sortwin,&srcwin);
			XMapWindow(display,srcwin);
			drawsrc(srcwin);
			XFlush(display);
			exchangesort(sortwin,srcwin,sortarray,bararray,NUMBARS);
			XFlush(display);
			oldchoice = 2;
			newchoice = -1;
			break;
		case 3:
			createsrc(text4,3);
			makesrc(sortwin,&srcwin);
			XMapWindow(display,srcwin);
			drawsrc(srcwin);
			XFlush(display);
			quicksort(sortwin,srcwin,sortarray,bararray,NUMBARS,0,(NUMBARS - 1));
			XFlush(display);
			oldchoice = 3;
			newchoice = -1;
			break;

		case 4: Continue = 0;
			oldchoice = 4;
			newchoice = -1;
			break;
		default:;
	}

	hilite(wdef,titlepos,newchoice,oldchoice);
	XFlush(display);
    }

}
