/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

#include <X11/Xlib.h>
#include <stdio.h>
#include "Xsdemo.h"
extern GC butGC;
extern GC invrbutGC;
extern char *titles[5];
extern int screen;
extern Display *display;

hilite(wdef,tpos,current,last)
	Window wdef[];
	int tpos[][2];
	int current, last;
{
	XSetWindowAttributes attrib;
	unsigned long vmask;

	/*
	 * check whether indices are realistic
	 */

	if(current>=NUMT || current < -1){
		fprintf(stderr,"\nHilite: Error current (%d) out of bounds",current);
		exit(1);
	}
	if(last >= NUMT || last < -1){
		fprintf(stderr,"\nHilite: Error last (%d) out of bounds",last);
		exit(1);
	}

	/* 
	 * if there was previous highliting then
	 * change the window back to normal
	 */

	if (last >= 0){
		attrib.background_pixel = WhitePixel(display,screen);
		attrib.border_pixel = BlackPixel(display,screen);
		vmask = CWBackPixel|CWBorderPixel;
		XChangeWindowAttributes(display,wdef[last],vmask,&attrib);
		XClearWindow(display,wdef[last]);
		XDrawString(display,wdef[last],butGC,tpos[last][0],
			tpos[last][1],titles[last],strlen(titles[last]));
		XFlush(display);
	}

	/*
	 * highlite the new window
	 */

	if(current>=0){
		attrib.background_pixel = BlackPixel(display,screen);
		attrib.border_pixel = WhitePixel(display,screen);
		vmask = CWBackPixel|CWBorderPixel;
		XChangeWindowAttributes(display,wdef[current],vmask,&attrib);
		XClearWindow(display,wdef[current]);
		XDrawString(display,wdef[current],invrbutGC,tpos[current][0],
	      	     tpos[current][1],titles[current],strlen(titles[current]));
		XFlush(display);
	}
}
