#ifndef lint
static char rcsid[] = "$Header: Dialog.c,v 1.10 88/02/26 11:57:37 swick Exp $";
#endif lint


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* NOTE: THIS IS NOT A WIDGET!  Rather, this is an interface to a widget.
   It implements policy, and gives a (hopefully) easier-to-use interface
   than just directly making your own form. */


#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/IntrinsicP.h>
#include <X11/Misc.h>
#include <X11/StringDefs.h>
#include <X11/AsciiText.h>
#include <X11/Command.h>
#include <X11/Label.h>
#include <X11/DialogP.h>


XtResource resources[] = {
  {XtNlabel, XtCLabel, XtRString, sizeof(String),
     XtOffset(DialogWidget, dialog.label), XtRString, NULL},
  {XtNvalue, XtCValue, XtRString, sizeof(String),
     XtOffset(DialogWidget, dialog.value), XtRString, NULL},
  {XtNmaximumLength, XtCMax, XtRInt, sizeof(int),
     XtOffset(DialogWidget, dialog.max_length), XtRString, "256"},
   {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
      XtOffset(DialogWidget, dialog.callbacks), XtRCallback, (caddr_t)NULL},
};

static void Initialize(), ConstraintInitialize();
static Boolean SetValues();
static void Notify();
static void EnableNotify();
static void DisableNotify();
static XtActionsRec actionsList[] =
{
  {"notify",		Notify},
  {"enablenotify",	EnableNotify},
  {"disablenotify",	DisableNotify},
};
static char defaultTrans[] =
	"<Btn2Down>:	enablenotify() \n\
	 <LeaveWindow>: disablenotify() \n\
	 <Btn2Up>:	notify(Help) disablenotify()";

DialogClassRec dialogClassRec = {
  { /* core_class fields */
    /* superclass         */    (WidgetClass) &formClassRec,
    /* class_name         */    "Dialog",
    /* widget_size        */    sizeof(DialogRec),
    /* class_initialize   */    NULL,
    /* class_part init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    actionsList,
    /* num_actions        */    XtNumber(actionsList),
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    defaultTrans,
    /* query_geometry     */	NULL
  },
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* move_focus_to_next */   NULL,
    /* move_focus_to_prev */   NULL
  },
  { /* constraint_class fields */
    /* subresourses       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(DialogConstraintsRec),
    /* initialize         */   ConstraintInitialize,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  { /* form_class fields */
    /* empty              */   0
  },
  { /* dialog_class fields */
    /* empty              */   0
  }
};

WidgetClass dialogWidgetClass = (WidgetClass)&dialogClassRec;


/* ARGSUSED */
static void Initialize(request, new)
Widget request, new;
{
    DialogWidget dw = (DialogWidget)new;
    static Arg label_args[] = {
	{XtNlabel, (XtArgVal)NULL},
	{XtNborderWidth, (XtArgVal) 0}
    };
    static char texttrans[] =
     "<Key>0xff53:		forward-character() \n\
     <Key>0xff51:		backward-character() \n\
     <Key>0xffff:		delete-previous-character() \n\
     <Key>0xff08:		delete-previous-character() \n\
     <Key>0xff0d:		enablenotify() notify() disablenotify() \n\
     <Btn2Down>:		enablenotify() \n\
     <Btn2Up>:			notify(Help) disablenotify() \n\
     <LeaveWindow>:		disablenotify() \n\
     <Key>:			insert-ascii(Blank) \n\
     Shift<Key>:		insert-ascii(Blank)";
    static Arg text_args[] = {
	{XtNwidth, (XtArgVal)NULL},
	{XtNstring, (XtArgVal)NULL},
	{XtNlength, (XtArgVal)0},
	{XtNfromVert, (XtArgVal)NULL},
	{XtNresizable, (XtArgVal)TRUE},
	{XtNtextOptions, (XtArgVal)(resizeWidth | resizeHeight)},
	{XtNeditType, (XtArgVal)XttextEdit},
	{XtNright, (XtArgVal)XtChainRight},
	{XtNtranslations, (XtArgVal)NULL},
    };
    Widget children[2], *childP = children;

    label_args[0].value = (XtArgVal)dw->dialog.label;
    dw->dialog.labelW = XtCreateWidget( "label", labelWidgetClass, new,
				        label_args, XtNumber(label_args) );
    *childP++ = dw->dialog.labelW;

    if (dw->dialog.value) {
        String initial_value = dw->dialog.value;
	Cardinal length = Max( dw->dialog.max_length, strlen(initial_value) );
	dw->dialog.value = XtMalloc( length );
	strcpy( dw->dialog.value, initial_value );
	text_args[0].value = (XtArgVal)dw->dialog.labelW->core.width; /*|||hack*/
	text_args[1].value = (XtArgVal)dw->dialog.value;
	text_args[2].value = (XtArgVal)length;
	text_args[3].value = (XtArgVal)dw->dialog.labelW;
	text_args[8].value = (XtArgVal)XtParseTranslationTable(texttrans);
	dw->dialog.valueW = XtCreateWidget("value",asciiStringWidgetClass,new,
					   text_args, XtNumber(text_args) );
	*childP++ = dw->dialog.valueW;
#ifdef notdef
	static int grabfocus;
	static Resource resources[] = {
	    {XtNgrabFocus, XtCGrabFocus, XtRBoolean, sizeof(int),
		 (caddr_t)&grabfocus, (caddr_t)NULL}
	};
	XrmNameList names;
	XrmClassList classes;
	grabfocus = FALSE;
	XtGetResources(dpy, resources, XtNumber(resources), args, argCount,
		       parent, "dialog", "Dialog", &names, &classes);
	XrmFreeNameList(names);
	XrmFreeClassList(classes);
	if (grabfocus) XSetInputFocus(dpy, data->value, RevertToParent,
				      CurrentTime); /* !!! Hackish. |||*/
#endif notdef
    } else {
        dw->dialog.valueW = NULL;
    }

    XtManageChildren( children, (Cardinal)(childP - children) );
}


/* ARGSUSED */
static void ConstraintInitialize(request, new)
Widget request, new;
{
    DialogWidget dw = (DialogWidget)new->core.parent;
    WidgetList children = dw->composite.children;
    DialogConstraints constraint = (DialogConstraints)new->core.constraints;
    Widget *childP;

    if (!XtIsSubclass(new, commandWidgetClass))	/* if not a button */
	return;					/* then just use defaults */

    constraint->form.left = constraint->form.right = XtChainLeft;
    constraint->form.vert_base = dw->dialog.valueW
				 ? dw->dialog.valueW
				 : dw->dialog.labelW;

    if (dw->composite.num_mapped_children > 1) {
        for (childP = children + dw->composite.num_children - 1;
	     childP >= children; childP-- ) {
	    if (*childP == dw->dialog.labelW || *childP == dw->dialog.valueW)
	        break;
	    if (XtIsManaged(*childP) &&
		XtIsSubclass(*childP, commandWidgetClass)) {
	        constraint->form.horiz_base = *childP;
		break;
	    }
	}
    }
}


/* ARGSUSED */
static Boolean SetValues(current, request, new)
Widget current, request, new;
{
    return False;
}


void XtDialogAddButton(dialog, name, function, param)
Widget dialog;
char *name;
void (*function)();
caddr_t param;
{
    DialogWidget parent = (DialogWidget)dialog;
    static XtCallbackRec callback[] = { {NULL, NULL}, {NULL, NULL} };
    static Arg arglist[] = {
	{XtNcallback, (XtArgVal) callback},
	{XtNfromHoriz, (XtArgVal) NULL},
	{XtNfromVert, (XtArgVal) NULL},
	{XtNleft, (XtArgVal) XtChainLeft},
	{XtNright, (XtArgVal) XtChainLeft}
    };

    callback[0].callback = function;
    callback[0].closure =  param;

    if ((parent->composite.num_mapped_children > 2)
	|| (!parent->dialog.value
	    && (parent->composite.num_mapped_children > 1)))
       arglist[1].value = (XtArgVal)parent->
	 composite.children[parent->composite.num_mapped_children - 1];
    else
       arglist[1].value = (XtArgVal)NULL;

    if (parent->dialog.value)
       arglist[2].value = (XtArgVal) parent->dialog.value;
    else
       arglist[2].value = (XtArgVal) parent->dialog.label;

    XtCreateManagedWidget( name, commandWidgetClass, dialog, 
			   arglist, XtNumber(arglist) );
}


char *XtDialogGetValueString(w)
Widget w;
{
    return ((DialogWidget)w)->dialog.value;
}

/* ARGSUSED */
static void Notify(w,event,params,num_params)
     Widget w;
     XEvent *event;
     String *params;		/* unused */
     Cardinal *num_params;	/* unused */
{
  DialogWidget dw = (DialogWidget)w;
  if (dw->dialog.enable_notify) {
	  if (*num_params == 0)
	      XtCallCallbacks(w, XtNcallback, NULL);
	  else
	      XtCallCallbacks(w, XtNcallback, *params);
  }
}

/*
 * Enable notify by setting boolean
 */
static void EnableNotify(w,event,params,num_params)
	Widget w;
	XEvent *event;
	String *params;
	Cardinal *num_params;
{
	DialogWidget cbw = (DialogWidget)w;

	cbw->dialog.enable_notify = True;
}

/*
 * Disable notify by clearing boolean
 */
static void DisableNotify(w,event,params,num_params)
	Widget w;
	XEvent *event;
	String *params;
	Cardinal *num_params;
{
	DialogWidget cbw = (DialogWidget)w;

	cbw->dialog.enable_notify = False;
}

