.LP
.nr PS 12
.nr VS 16
.LP
.SH
Gsh
.SH
Introduction
.PP
Gsh attempts to provide the functional equivalent of the single command
line component of the standard Unix shells, configured to a specific user
community.
The shell runs on a workstation as an X-windows client and uses visual
interface technology for its interactive dialog.
Most input actions consist of selections using mouse button1
over a specific selection item in one of several panels of
widgets.
Once a single line command has been generated via. mouse interaction
it is executed, usually tied to a terminal emulation window,
by a normal Unix shell.
.SH
Basics
.PP
Input is normally provided by the mouse, with some keyboard input required
for new name creation.
All other keyboard input is associated with the vif(1) terminal emulation
window for the associated client.
The mouse buttons are used as follows:
.nf
.RS
.IP "Left " 10
- Selection of objects
.IP "Center " 10
- Help window popup/zap
.IP "Right " 10
- Popup Menus and auxiliary popup windows
.RE
.fi
.LP
There are two panels that remain on the display at all times and provide
the basic interactions:
.IP "Top Level" 16
This panel provides for selection of command groupings (top levels) from
the buttons on the panel or logout etc. via. the control buttons at the top left corner
of the title bar.
The control buttons
.I
logout, start a selected command, reset a command selection or start the
directory browser
.R
when selected.
There are other assorted optional widgets providing information such
as a clock or mail to be read widget.
.IP "Command" 16
This panel permits selection of a command and as such is the fundamental
one in the system.
The elements on the panel are defined by which top level (see above) has
currently been selected.
When an item is selected (the good old left mouse button), the corresponding
shell command line is displayed in the command window. If the command
requires name arguments (file names or whatever), a name object selection
panel will pop up. (See Name below)
Once selected the command can run either immediately or after selection of
.I
Accept
.R
in the command title bar.
When it runs, it brings up associated windows, most often using vif(1) to
control the command's execution.
.IP "Dir Operations" 16
These can be performed by bringing up the directory browser by selecting
the 4th control button in Top Level.
The scroll bars allow you to scan the tree and then the left mouse button
pulls down an operations menu to be performed on that directory.
The most basic operation is
.B
List
.R
that lists the files in the directory.
Optionally, there are selections for
.I
chdir, mkdir, rmdir and rm
.R
as well.
Other panels will be raised to get any required associated information,
such as a new directory name.
.R
This panel may be used at any time to help with locating names for the
name argument list.
.IP "Process Ctrl Menu" 16
This menu controls a command execution once it is created
via. the command and name selection panels. It consists of three selections
that
.I
Pause, Continue and Kill
.R
the current command during its execution.
The menu is popped up by pressing the right mouse button on the window
for the command that the menu is to control.
.IP "Command String Window" 16
A command string window displays the standard
Unix shell command line being built.
.SH
Raised Panels
.PP
There are two panels that are generated either for name selection for
a command that has been mouse selected.
These will either consist of a set of names (often file names) that may be
selected from or a New Name panel that allows keystroke input of new text
strings for new names for command arguments.
.IP "Name Panel" 16
The name panel pops up to allow selection of names for commands.
The panel consists of a title bar and a button box in a viewport that
allows scrolling via. a scrollbar if the buttons don't fit on the window.
Selection of names adds them to the name list for the command.
For some commands, a New Name selection is enabled (the 4th button in the
title bar).
Selecting this button, pops up a New Name panel. (see below)
The
.I
Accept
.R
control button in the title bar accepts the selected name(s), whereas the
.I
Reset
.R
button allows you to restart selections and the
.I
Cancel
.R
button cancels name selection entirely.
.IP "New Name" 16
The New name panel allows keyboard input of a new name.
Once the name has been entered, type <cr> or mouse select the
.I
Accept
.R
control button.
.SH
Help Windows
.PP
If you press the middle mouse button over any of the panels or
(in some cases) the selection items, a text window with a
.I
help message
.R
will pop up.
To get rid of the help windows, just press the middle mouse button
while the mouse cursor is inside any one of these windows.
.SH
Command Windows
.PP
When commands are executed, they normally have associated control windows
of one of two types:
.IP "vif - "
The vif(1) program displays a panel defined by its configuration and has
the
.I
stdio
.R
of the command tied to it via. a pty connection.
(see VIF section)
.IP "ctrl icon - "
For commands that do not do character I/O, a ctrl icon window may pop up
that simply has the command name in it.
.PP
For both types of windows, a press of the right mouse button will pop up
a process control menu.
.SH
VIF
.PP
The vif(1) client provides a vt102 terminal emulation window with some
configured interface widgets.
The widgets can include a set of selection buttons accross the top and
a scrollbar down the left side of the screen.
It also can allow mouse input on the terminal emulation window.
If the message,
.I
Press Button to Continue
.R
pops up in reverse video at the top, you must press a mouse button on the
terminal emulation screen to continue scrolling.
This is configured for output only windows, to avoid loss of output.
(ala more(1))
.SH
Error Handling
.PP
Unfortunately, most errors will occur are due to inappropriate use of the Unix
utilities that are initiated from the command level and cannot be recognized
or dealt with by xgsh.
However, two types of errors are detected and handled by xgsh.
Fatal errors are a result of a flaw in the configuration structure or
a problem with the X server connection and result in a message and
termination of the shell.
Non-fatal errors result from an inappropriate mouse selection or keyboard
input name and will generate a message (or icon) error window and reset
the command selection in progress.
For example, selecting a pascal compile when there are no *.p text files
(pascal source) in the appropriate directory will cause a non-fatal error.
For the most part, detection of these is dependent on the configuration
that is in use at the time.
.SH
Configuration
.PP
The layout,
contents of the panels and actions
associated with selections is largely defined by the
configuration that is being used. This configuration is actually a
large initialized C structure that holds definitions for all commands
that make up each of the top levels.
For each command there is an associated shell command string which
may optionally require name arguments to be filled in.
This is indicated by a "^" character in the command string.
When name arguments are required, the configuration defines the name
source and optionally a New-Name object used to pop up a New Name Panel.
The name strings must pass a regular expression defined for the command.
Names made available for selection may be file names in a given directory,
a list explicitly provided in the configuration or taken from the stdout
of a name argument generation command that is defined.
In the case of file names, further restrictions such as 
.I
ascii character file with
read/write access 
.R
may be specified.
These types of restrictions are hoped to minimize the simple errors
that users run into using a standard Unix shell.
If the user is to be allowed to enter new names via. keyboard input, the
New-Name object will be configured into the Name Selection Panel.
.PP
As well as the commands, the configuration defines a variety of parameters
controlling the global layout and restrictions such as 
.I
can the user chdir
.R
or 
.I
colours of the panels.
.R
There are a few elements of a configuration that defines its overall
structure. These are for the most part flags specified at the global
level and control restrictions.
The most significant are:
.IP "- "
whether or not to allow directory tree manipulations
.IP "- "
whether to force directory changes for each top level entered
(essentially force a directory subtree on the user)
.IP "- "
whether or not to allow multiple running jobs
.IP "- "
whether to use string names or icons for selection items
.IP "- "
whether to show the Unix shell command being created
.LP
For now, details on the configuration structure are only available in
.I
include/xgshconf.h and include/vifconf.h
.R
along with the example configurations in
.I
xgsh/configs and vif/configs.
.R
There are a few additional hints in
.I
doc/configs.
.R
.SH
Getting Started
.PP
First, follow the steps in "install" to get a runnable "xgsh" client.
And then you may fire it up on several of the example config's and play 
with it
for a while.
You may want to make use of the middle mouse button to pop up
the help windows.
To construct config's for your use, take a close look at the above mentioned files
and hack away at the closest of the examples.
.sp
A few useful hints are as follows:
.IP "- "
Initially a string-name configuration is simpler and can easily be
converted to icons once you spend the time to make the actual icons
(you will learn to love
.I
bitmap
.R
)
.IP "- "
Non-interactive commands that write to stdout should have a tty window
with the flags C_WINLINGER and C_DEFUNCT or'd with C_TTYPAGESCROLL
and usually out.vif to avoid loss of output.
.IP "- "
Interactive commands that require a tty should have a tty window, but
without C_WINLINGER or C_TTYPAGESCROLL
.IP "- "
Simple configs. should not allow multiple active commands
.IP "- "
For novice users, you might consider not allowing explicit directory
changes {G_DIRBROWSER} but forcing a subdirectory for each top level.
{G_CHDIR}
.IP "- "
Commands not requiring a tty window (batch or X clients) can be configured
with or without an assoctiated icon window {C_ICONW}
.LP
You may construct a help library of the text that is popped up in the help
windows by following the example of
.I
icon
.R
in the helplib directory.
It is simply a tar file of the text of the messages for each window where the file names
determine which widget of which panel the message is associated with.
See the
.I
helplib/Readme
.R
for the naming conventions.
.SH
Directions
.PP
The current rendition of xgsh is intended as a prototype to help with
the definition of
a good visual interface for Unix on a workstation.
It time, it is hoped that a production version that runs under X11 and Xt
will be built, at least loosely based on the current system.
There are far reaching questions related to
.I
what is a good model of top level interaction on a graphics workstation
and does it relate to the I/O stream model of Unix
.R
as well as many more mundane ones related to detailed interaction
(ala. what pops up vs. stays visible) and panel layout (graphical appearance)
that must be tackled.
An interface suitable for non-novice users will require capabilities such as
extensibility that are somewhere down the road.
The file
.I
Todo
.R
has a little more detail on this.
