/******************************************************************/

/* 
 * TreeP.h - Private definitions for Tree widget
 * 
 */

#ifndef _TreeP_h
#define _TreeP_h

/***********************************************************************
 *
 * Box Widget Private Data
 *
 ***********************************************************************/
#include <X11/TreeI.h>
#include <X11/Tree.h>
#include <X11/CommandP.h>
#include <X11/CompositeP.h>

/* New fields for the tree widget class record */
typedef struct {int empty;} TreeClassPart;

/* Full class record declaration */
typedef struct _TreeClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    CommandClassPart    command_part;
    TreeClassPart	tree_class;
} TreeClassRec;

extern TreeClassRec treeClassRec;

/* New fields for the tree widget record */
typedef struct {
    Dimension   h_factor, v_factor;
    Dimension	width, height;
    Dimension   lchildw,lchildh,no_level;
    GC		lineGC;
    GC		invrlineGC;
    Pixel	fg;
    Pixel       bg;
    TreeList	*head;
    Widget	parent;
} TreePart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _TreeRec {
    CorePart	    core;
    CompositePart   composite;
    CommandPart	    command;
    TreePart 	    tree;
} TreeRec;

#endif _TreeP_h
