/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/filePanel.h,v $
 *	$Header: filePanel.h,v 1.1 86/12/17 08:54:29 swick Exp $
 */

/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        filePanel.h
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: The file the declarations for filePanel.c.
 **
 **   *******************************************************************
 **   * (c)  Copyright Hewlett-Packard Company, 1986.  All rights are   *
 **   * reserved.  Copying or other reproduction of this program except *
 **   * for archival purposes is prohibited without the prior written   *
 **   * consent of Hewlett-Packard Company.                             *
 **   *******************************************************************
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	filePanel.h,v $
 * Revision 1.1  86/12/17  08:54:29  swick
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/


/*
 *  Editor static declarations for the read file panel.
 */

static xrTitleBarInfo readTBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Read Raster",		/* title name	    */
   NULL,			/* gadget 1	    */
   NULL				/* gadget 2	    */
};

static INT8 fileName[15] = "tempRaster";

static xrTextEditInfo panelTEInfo =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "File Name",			/* editor label     */
   fileName,			/* editor string    */
   14,				/* max chars        */
   0,				/* insert pos       */
   XrINTERACTIVE,		/* insert mode      */
   XrLEFT_ALIGNED,		/* label position   */
   XrAVGWIDTH
};


static INT8 *readLabels[] =
{
   "Read File",
   "Cancel"
};

static xrPushButtonInfo readPBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   2, 1,			/* field, col count */
   0,				/* default button   */
   2,				/* border width     */
   readLabels,			/* labels           */
   NULL				/* flags            */
};


/*
 *  Panel static declarations for the read panel.
 */


static xrPanelContext panelContext;

static xrPanelField readFields[] =
{
   {  XrTitleBar,    (INT8 *) &readTBInfo,  NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo, NULL  },
   {  XrPushButton,  (INT8 *) &readPBInfo,  NULL  },
};

static xrPanelInfo readInfo =
{
   {0, 0},		/* panel origin      */
   {0, 0},
   0,			/* relative to       */
   0,                   /* child of          */
   &panelContext,	/* panel context     */
   readFields,		/* panel editor list */
   3,			/* editor count      */
   0,			/* panel id	     */
};

static xrPanel * readPanel;


/*
 *  Static editor declarations for the write panel.
 */

static xrTitleBarInfo writeTBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Write Raster",		/* title name	    */
   NULL,			/* gadget 1	    */
   NULL				/* gadget 2	    */
};

static INT8 * writeLabels[] =
{
   "Write File",
   "Cancel"
};

static xrPushButtonInfo writePBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   2, 1,			/* field, col count */
   -1,				/* default button   */
   2,				/* border width     */
   writeLabels,			/* labels           */
   NULL				/* flags            */
};


/*
 *  Static declarations for the panel structures for the write panel.
 */

static xrPanelField writeFields[] =
{
   {  XrTitleBar,    (INT8 *) &writeTBInfo,  NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo,  NULL  },
   {  XrPushButton,  (INT8 *) &writePBInfo,  NULL  },
};

static xrPanelInfo writeInfo =
{
   {0, 0},		/* panel origin      */
   {0, 0},
   0,			/* relative to       */
   0,                   /* child of          */
   &panelContext,	/* panel context     */
   writeFields,		/* panel editor list */
   3,			/* editor count      */
   0,			/* panel id	     */
};

static xrPanel * writePanel;

