/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * Copyright (c) 1991, Locus Computing Corporation
 * All rights reserved
 */
/* 
 * $Log: bvp_vpsops.c,v $
 * Revision 1.15  1994/11/18  20:51:04  mtm
 * Copyright additions/changes
 *
 * Revision 1.14  1994/04/28  19:20:39  chrisp
 * Changes for introduction of tncgen and support of i386 builds.
 * Generated prototype header files changed for consistency with tnc/.
 *
 *  Reviewer: dleslie, cfj
 *  Risk: M
 *  Benefit or PTS #: 9188
 *  Testing: Builds and tested on i386 platform.
 *  Module(s):
 *      Modified Files:
 *      	bvp_init.c bvp_vpops.c bvp_vpsops.c
 *      Added Files:
 *      	gen_dispatch_table.sh gen_op_macros.sh gen_prototypes.sh
 *      	gen_table_struct.sh tncgen vp.ops vprocgen.mk vps.ops
 *      Removed Files:
 *      	maketables.sh
 *
 * Revision 1.13  1994/03/14  02:09:58  slk
 * Checkpoint Restart Code Drop
 *  Reviewer: Stefan Tritscher
 *  Risk: Medium
 *  Benefit or PTS #: Enhancement
 *  Testing: Locus VSTNC, EATS TCP-IP, Individual Checkpoint/Restart tests.
 *  Module(s):
 *
 * Revision 1.12  1993/12/20  19:04:46  dleslie
 *  Reviewer: none
 *  Risk: low
 *  Benefit or PTS #: don't declare variable as register if we're taking
 * 	its address, so we pass 'lint'
 *  Testing: built
 *  Module(s): bvp_vpsops.c
 *
 * Revision 1.11  1993/12/03  20:11:11  paul
 * Various fixes to RPM support, plus support for global setting of Timezone
 *
 * Added bvpsop_settimezone. This calls pps_settimezone which I think is
 * still the right thing, even if TNC is not defined, since we still want to
 * call the low level set timezone code for *this* node.
 *
 *  Reviewer: John Litvin (jlitvin@ssd.intel.com) Brent Olsen (bolsen@locus.com)
 *  Risk: Moderate
 *  Benefit or PTS #: :Fixes bug #s 3503 5303 6029 7299
 *  Testing: functionality checked on olympus.sd.locus.com w/RPM support
 *  Module(s): server/vproc/bvp_vpsops.c
 *
 * Revision 1.10  1993/11/04  17:24:36  cfj
 * The new time of day code whichs distributes the rpm offset from Locus would not
 * build with TNC turned off.  Therefore the RAMDISK would not build.
 *
 *  Reviewer: jlitvin
 *  Risk: Low
 *  Benefit or PTS #: Ramdisk server now builds.
 *  Testing: Build the ramdisk.
 *  Module(s): This one.
 *
 * Revision 1.9  1993/10/29  11:55:38  paul
 * Add support for setting and using the RPM distributed time-of-day clock.
 *
 * Revision 1.8  1993/07/14  18:47:25  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.6  1993/07/01  21:10:58  cfj
 * Adding new code from vendor
 *
 * Revision 1.7  1993/05/06  19:11:14  stefan
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.6  1993/04/03  03:13:24  brad
 * Merge of PFS branch (tagged PFS_End) into CVS trunk (tagged
 * Main_Before_PFS_Merge).  The result is tagged PFS_Merge_Into_Main_April_2.
 *
 * Revision 1.1.2.3.2.2  1993/01/09  00:05:53  brad
 * Merged changes between ...Locus_Bug_Drop_OK... and Jan5 main trunk
 * tags into the PFS branch, to bring PFS up-to-date with Transmittal
 * 7.
 *
 * Revision 1.5  1992/12/18  17:12:45  nandy
 * Added a stub fro reset_boot_nodelist. This will allow a non NX servers
 * to get built
 *
 * Revision 1.1.2.3.2.1  1992/12/16  06:06:22  brad
 * Merged trunk (as of the Main_After_Locus_12_1_92_Bugdrop_OK tag)
 * into the PFS branch.
 * 
 * Revision 1.4  1992/12/11  03:07:55  cfj
 * Merged 12-1-92 bug drop from Locus.
 *
 * Revision 1.3  1992/11/30  22:58:38  dleslie
 * Copy of NX branch back into main trunk
 *
 * Revision 1.1.2.3  1992/11/13  18:53:26  cfj
 * Added reset_boot_node_list() system call.
 *
 * Revision 1.1.2.2  1992/11/06  20:34:59  dleslie
 * Merged bug drop from Locus November 3, 1992, with NX development
 *
 * Revision 1.1.2.1  1992/11/05  23:47:17  dleslie
 * Local changes for NX through noon, November 5, 1992.
 *
 * Revision 1.1.1.4  1993/05/03  17:55:28  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 3.3  1992/12/01  11:56:07  chrisp
 * Add virtual process system operation for VSPOP_REBOOT() in support
 * 	of the reboot() system call.
 *
 * Revision 3.2  92/10/28  16:05:00  roman
 * Include procedure prototypes now generated by maketables.sh
 *         for better type-checking.
 * Add new vpsops for table(), sethostid(), sethostname(), and
 * 	setdomainname() system calls.
 * 
 * Revision 3.1  92/10/01  10:38:36  roman
 * Fix up types for clean compilation under gcc.
 * 
 * Revision 3.0  92/09/28  16:12:04  roman
 * Initial submission of file with non-TNC code for virtual process system
 * operations.
 * 
 */

#include <sys/types.h>
#include <sys/vproc.h>
#include <sys/errno.h>
#include <sys/errno.h>

/* Include generated procedure prototypes for operations */
#include <vproc/bvps_protos_gen.h>

/*
 * Virtual process system operation for VPSOP_SIGPROCSET()
 */
int 
bvpsop_sigprocset(
	struct	procset *ps,
	int		signo,
	int		arg,
	int		*nproc)
{
	uid_t		uid, ruid;
	pid_t		pid, sid;
	boolean_t	has_priv;

	(void) pproc_get_attr(0,&pid,0,0,&sid,&has_priv,&uid,&ruid,0,0);
	return (pps_sigprocset(ps, signo, arg, has_priv, 
			       uid, ruid, pid, sid, nproc));
}


/*
 * Virtual process system operation for VPSOP_PROCSET_NICE()
 */
int 
bvpsop_procset_nice(
	struct procset	*ps,
	int		*nice,
	int		flag)
{
	uid_t		euid, ruid;
	int		has_priv;

	switch (flag&(VPROC_SET|VPROC_GET)) {
	case VPROC_GET:
		return(pps_procset_get_nice(ps, nice));
	case VPROC_SET:	
		(void) pproc_get_attr(0,0,0,0,0,&has_priv,&euid,&ruid,0,0);
		return(pps_procset_set_nice(ps, euid, ruid, has_priv, *nice));
	default:
		return(EINVAL);
	}
}


/*
 * Virtual process system operation for VPSOP_PID_FROM_TASK()
 */
int 
bvpsop_pid_from_task(
	task_t		task,
	pid_t		*pid,
	char		*comm,
	unsigned int	*commlen)
{
	return(pps_pid_from_task(task, pid, comm, commlen));
}


/*
 * Virtual process system operation for VPSOP_TABLE()
 */
int
bvpsop_table(
	int		id,
	int		index,
	caddr_t		addr,
	int		nel,
	u_int		lel,
	int		*retval)
{
	struct args {
		int	id;
		int	index;
		caddr_t	addr;
		int	nel;
		u_int	lel;
	} ua;
	ua.id = id;
	ua.index = index;
	ua.addr = addr;
	ua.nel = nel;
	ua.lel = lel;
	return(pps_table(&ua, retval));
}


/*
 * Virtual process system operation for VPSOP_SETHOSTID()
 */
int
bvpsop_sethostid(
	long	new_hostid)
{
	return(pps_sethostid(new_hostid));
}

/*
 * Virtual process system operation for VPSOP_SETHOSTNAME()
 */
int
bvpsop_sethostname(
	char		*new_hostname,
	unsigned int	new_hostnamelen)
{
	return(pps_sethostname(new_hostname, new_hostnamelen));
}

/*
 * Virtual process system operation for VPSOP_SETDOMAINNAME()
 */
int
bvpsop_setdomainname(
	char		*new_domainname,
	unsigned int	new_domainnamelen)
{
	return(pps_setdomainname(new_domainname, new_domainnamelen));
}

/*
 * Virtual process system operation for VPSOP_RPMOFFSET()
 * This is just a stub for the non-TNC case.
 */
int
bvpsop_rpmoffset(
	unsigned int	rpmlow,
	unsigned int	rpmhigh)
{
    return ESUCCESS;
}

/*
 * Virtual process system operation for VPSOP_SETTIMEZONE()
 */
int
bvpsop_settimezone(
	struct timezone new_timezone)  
{
	return(pps_settimezone(new_timezone));
}

#ifdef NX
/*
 * Local private virtual process system operation 
 * for PVPSOP_RESET_BOOT_NODE_LIST()
 */
bvpsop_reset_boot_node_list(
        char           *nodelist,
        unsigned int    nodelistlen,
	boolean_t       local_node_only)
{
	return(pps_reset_boot_node_list(nodelist, nodelistlen));
}
#else
bvpsop_reset_boot_node_list(
        char           *nodelist,
        unsigned int    nodelistlen,
	boolean_t       local_node_only)
{
	return;
}

#endif /* NX */

/*
 * Virtual process system operation for VPSOP_REBOOT()
 */
int
bvpsop_reboot(
	int	panic_flag,
	int	options)
{
	pps_bootsync(panic_flag, options);
	pps_boot(panic_flag, options);

	return(EAGAIN);	/* Back from the grave? */
}
