/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * Copyright (c) 1991, Locus Computing Corporation
 * All rights reserved
 */
/* 
 * HISTORY
 * $Log: bvp_init.c,v $
 * Revision 1.9  1994/11/18  20:50:59  mtm
 * Copyright additions/changes
 *
 * Revision 1.8  1994/04/28  19:20:27  chrisp
 * Changes for introduction of tncgen and support of i386 builds.
 * Generated prototype header files changed for consistency with tnc/.
 *
 *  Reviewer: dleslie, cfj
 *  Risk: M
 *  Benefit or PTS #: 9188
 *  Testing: Builds and tested on i386 platform.
 *  Module(s):
 *      Modified Files:
 *      	bvp_init.c bvp_vpops.c bvp_vpsops.c
 *      Added Files:
 *      	gen_dispatch_table.sh gen_op_macros.sh gen_prototypes.sh
 *      	gen_table_struct.sh tncgen vp.ops vprocgen.mk vps.ops
 *      Removed Files:
 *      	maketables.sh
 *
 * Revision 1.7  1993/07/14  18:47:14  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.5  1993/07/01  21:10:41  cfj
 * Adding new code from vendor
 *
 * Revision 1.6  1993/05/06  19:10:52  stefan
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.5  1993/04/03  03:13:19  brad
 * Merge of PFS branch (tagged PFS_End) into CVS trunk (tagged
 * Main_Before_PFS_Merge).  The result is tagged PFS_Merge_Into_Main_April_2.
 *
 * Revision 1.1.2.2.2.1  1993/02/16  20:09:21  brad
 * Merged trunk (as of the T8_EATS_PASSED tag) into the PFS branch.
 *
 * Revision 1.4  1993/01/22  18:16:32  cfj
 * 01-20-93 Locus code drop.
 *
 * Revision 1.1.2.2  1992/11/06  20:34:52  dleslie
 * Merged bug drop from Locus November 3, 1992, with NX development
 *
 * Revision 1.1.1.3  1993/05/03  17:55:19  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 3.13  1992/12/29  13:18:57  chrisp
 * In bvp_init0(), initialize the vproc and pvproc zones.
 * Explicitly zeroize the pvproc structures for vproc 0 and 1.
 * Make check for vproc 0/1 conditional on VPROC_DEBUG since vproc field
 * 	vp_index is likewise conditioned.
 *
 * Revision 3.12  92/10/28  16:02:09  roman
 * Change included files to match the new files names and locations
 * 	generated by maketables.sh.
 * 
 * Revision 3.11  92/10/09  10:01:56  roman
 * Fix up typecasting for clean i860 compilations.
 * 
 * Revision 3.10  92/10/08  17:17:44  chrisp
 * Operations tables deleted and replaced by declarations included for
 * 	generated file. Names altered to be consistent.
 * 
 * Revision 3.9  92/09/29  08:29:53  roman
 * Fix RCS comments.
 * Remove vproc op for killall (now a virtual process system 
 * 	operation [vpsop]).
 * Add declarations and initialization of vpsops.
 * Change pvproc field name references to new (better) style names.
 * 
 * Revision 3.8  92/06/17  09:18:35  roman
 * [Bug 0026] New vproc op VPOP_GET_TASK_PORT() added to get task_by_pid() 
 *	system call working.
 * 
 * Revision 3.7  92/01/30  14:20:04  chrisp
 * Add ptrace.
 * 
 * Revision 3.6  92/01/08  16:43:20  chrisp
 * Split bpvproc_init into 2 sections handling procs 0 and 1 separately.
 * 
 * Revision 3.5  92/01/07  11:20:22  chrisp
 * Proc 0 is session leader.
 * Minor textual amendments.
 * 
 * Revision 3.4  91/12/20  16:55:44  chrisp
 * RESIGN_PGRP now not a VPOP; SET_STOP_STATE is STATE.
 * Set init to be a session leader.
 * 
 * Revision 3.3  91/11/14  14:59:16  chrisp
 * Revision of CTTY related vproc operations and the elimination of
 * VPOP_GET_PGRPJOBC and VPOP_IS_PGRPLEADER.
 * 
 * Revision 3.2  91/11/01  17:26:34  roman
 * Add new VPOP_FREE entry to vproc op table.
 * 
 * Revision 3.1  91/10/30  12:53:04  roman
 * Change the routine used by LOCATE_VPROC_PID to use locate_vproc_pid()
 * from vp_subr.c rathern than vprocptr(), which does not increment
 * the vproc reference count.
 * 
 * Revision 3.0  91/10/25  10:33:47  roman
 * Initial submission of a version of pvp_init.c from the pvproc directory.
 * This version does not support distributed vproc operations.
 * 
 */
#include <sys/vproc.h>
#include <vproc/bpvproc.h>
#include <kern/zalloc.h>

/*
 * Declaration of vproc operations table.
 */
#include <vproc/bvproc_protos_gen.h>
#include <vproc/bvps_protos_gen.h>
#include <vproc/bvpop_tables_gen.c>

/*
 * Actually initialize the pvproc table and vproc 0.
 */
bpvproc_init0(struct proc *proc0)
{
	struct vproc *v, *w;
	struct pvproc *pvp;
	int hashidx;
	extern struct vproc *vproc_alloc();
	extern struct vproc *locate_vproc_pid(pid_t pid);
	extern struct vproc *vproc_new();
	extern zone_t vproc_zone, pvproc_zone;

	/*
	 * Set up the virtual process system operations table.
	 */
	vps_ops = &bvps_ops_table;

	/*
	 * Set things up so the LOCATE_VPROC_PID() macro works.
	 */
	locate_vproc_pid_routine = locate_vproc_pid;

	/*
	 * Pre-allocate space for the vproc and pvproc tables.
	 * Though the number of vprocs is actually 0 at his stage.
	 */
	vproc_zone  = zinit(sizeof(struct vproc), 0,
			    nvproc*sizeof(struct vproc), "vproc_table");
	pvproc_zone = zinit(sizeof(struct pvproc), 0,
			    nvproc*sizeof(struct pvproc), "pvproc_table");
	if (vproc_zone == NULL || pvproc_zone == NULL)
		panic("bpvproc_init0: unable to zinit (p)vproc table");
	nvproc = 0;

	/*
	 * Allocate and initialize the vproc and pvproc for vproc[0]
	 * (a dummy process, never used).
	 */

	/* allocate a vproc */
	if ((v = vproc_alloc()) == NULL)
		panic("bpvproc_init0: unable to allocate vproc[0]");
#ifdef	VPROC_DEBUG
	if (v->vp_index != 0)
		panic("bpvproc_init0: initial vproc is not vproc[0]");
#endif
	v->vp_pid = 0;
	pvp = PVP(v);
	bzero((caddr_t) pvp, sizeof(struct pvproc));

	/* put the vproc on the vproc hash chain */
	w = vproc_hash[hashidx = VPROCPIDHASH(v->vp_pid)];
	v->vp_hashbwd = NULL;
	v->vp_hashfwd = w;
	vproc_hash[hashidx] = v;
	if (w)
		w->vp_hashbwd = v;

	v->vp_ops = &bvproc_ops_table;

	VPROC_HOLD(v, "bpvproc_init0");

	/*
	 * Allocate a Mach port for the vproc.
	 */
	(void) vproc_port_allocate(v);

	/*
	 * point the vproc at the physical process
	 */
	pvp->pvp_pproc = proc0;

	/* sort out the immediate family relationships */
	pvp->pvp_childl = NULL;
	pvp->pvp_head_childl = NULL;
	pvp->pvp_ppid = 0;
	pvp->pvp_pgid = 0;
	pvp->pvp_sid = 0;
	pvp->pvp_flag |= PV_SESSIONLEADER;

	VPROC_HOLD(v, "bpvproc_init0");

	/* initialize the process structure with values from the pvproc */
	pproc_set_attr(pvp->pvp_pproc, 
		       v, 
		       &v->vp_pid, 
		       &pvp->pvp_ppid, 
		       &pvp->pvp_pgid, 
		       &pvp->pvp_sid,
		       0);
}

/*
 * Allocate and initialize the vproc and pvproc for vproc[1]
 * (the init process)
 */
bpvproc_init1(struct proc *proc1)
{
	struct vproc *v, *w;
	struct pvproc *pvp;
	int hashidx;
	extern struct vproc *vproc_alloc();
	extern struct vproc *locate_vproc_pid(pid_t pid);

	/* allocate a vproc */
	if ((v = vproc_alloc()) == NULL)
		panic("pvproc_init1: unable to allocate vproc[1]");
#ifdef	VPROC_DEBUG
	if (v->vp_index != 1)
		panic("pvproc_init1: initial vproc is not vproc[1]");
#endif
	v->vp_pid = 1;
	pvp = PVP(v);
	bzero((caddr_t) pvp, sizeof(struct pvproc));

	/* put the vproc on the vproc hash chain */
	w = vproc_hash[hashidx = VPROCPIDHASH(v->vp_pid)];
	v->vp_hashbwd = NULL;
	v->vp_hashfwd = w;
	vproc_hash[hashidx] = v;
	if (w)
		w->vp_hashbwd = v;

	v->vp_ops = &bvproc_ops_table;

	VPROC_HOLD(v, "bpvproc_init1");

	/*
	 * Allocate a Mach port for the vproc.
	 */
	(void) vproc_port_allocate(v);

	/*
	 * point the vproc at the physical process
	 */
	pvp->pvp_pproc = proc1;

	/* sort out the immediate family relationships */
	pvp->pvp_childl = NULL;
	pvp->pvp_head_childl = NULL;
	pvp->pvp_ppid = 0;
	pvp->pvp_pgid = 0;
	pvp->pvp_sid = 0;

	VPROC_HOLD(v, "bpvproc_init1");

	/* initialize the process structure with values from the pvproc */
	pproc_set_attr(pvp->pvp_pproc, 
		       v, 
		       &v->vp_pid, 
		       &pvp->pvp_ppid, 
		       &pvp->pvp_pgid, 
		       &pvp->pvp_sid,
		       0);
}
