/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * Copyright (c) 1991, Locus Computing Corporation
 * All rights reserved
 */
/* 
 * HISTORY
 * $Log: vproc.h,v $
 * Revision 1.23  1995/03/14  02:02:39  raya
 * Modified original fix for PTS-12465 to call VPOP_REPORT_STATE()
 * in order to reset the PV_NX_NO_SIGCHLD flag rather than resetting
 * it directly.  VPOP_REPORT_STATE() will update the value of the
 * flag on both the local node as well as the node on which the
 * parent process is running.
 *
 *  Reviewer:              Johannes
 *  Risk:                  Low
 *  Benefit or PTS #:      12465
 *  Testing:               Selective developer testing
 *  Module(s):             dvp_pvpops.c dvp_vpops.c vproc.h
 *
 * Revision 1.22  1995/01/27  22:43:50  yazz
 *  Reviewer: John Litvin
 *  Risk: Med
 *  Benefit or PTS #: 12237
 *  Testing: EATs sched, os_interfaces, controlc
 *  Module(s):
 * 	server/bsd/kern_exit.c
 * 	server/sys/proc.h
 * 	server/sys/vproc.h
 * 	server/tnc/rtask_cli_pproc.c
 * Change pproc ref count mechanism so it never has to block.  Instead of
 * blocking until the ref count drops to zero before clearing out a pproc
 * structure and placing it back on the freelist, set a flag so that this
 * action will take place as soon as the ref count does drop to zero.
 *
 * Revision 1.21  1994/11/18  20:42:23  mtm
 * Copyright additions/changes
 *
 * Revision 1.20  1994/09/29  22:56:24  yazz
 *  Author of fix: Chris Peak
 *  Reviewer: Bob Yasi, Nandini Ajmani
 *  Risk: Medium
 *  Benefit or PTS #: 9346 (plus 10485, 6266, 7916, 9265, 8194)
 *  Testing: control-c EAT case 3 (20 iterations), other EATs os_interfaces,
 * 		xtrnl, controlc, rmcall, fileio, message
 *  Module(s):
 * 	server/sys/vproc.h
 * 	server/uxkern/proc_to_task.h
 * 	server/uxkern/proc_to_task.c
 * 	server/tnc/dvp_vpops.c
 * 	server/tnc/rvp_subr.c
 *
 * Abolish the renaming of vproc ports for send rights on remote nodes.
 * Add new field to vproc struct to hold the port name.
 *
 * Revision 1.19  1994/04/28  19:09:41  chrisp
 * tncgen: vproc operation structs, protos and macros now autogenerated
 * and included from _gen.h files.
 *
 *  Reviewer: dleslie, cfj
 *  Risk: M
 *  Benefit or PTS #: 9188
 *  Testing: Builds, builds, builds.
 *  Module(s): vproc.h
 *
 * Revision 1.18  1994/03/14  02:03:36  slk
 * Checkpoint Restart Code Drop
 *  Reviewer: Stefan Tritscher
 *  Risk: Medium
 *  Benefit or PTS #: Enhancement
 *  Testing: Locus VSTNC, EATS TCP-IP, Individual Checkpoint/Restart tests.
 *  Module(s):
 *
 * Revision 1.17  1993/12/03  20:05:17  paul
 * Various fixes to RPM support, plus support for global setting of Timezone
 *
 * Added the VPSOP definitions
 *
 *  Reviewer: John Litvin (jlitvin@ssd.intel.com) Brent Olsen (bolsen@locus.com)
 *  Risk: Moderate
 *  Benefit or PTS #: :Fixes bug #s 3503 5303 6029 7299
 *  Testing: functionality checked on olympus.sd.locus.com w/RPM support
 *  Module(s):server/sys/vproc.h
 *
 * Revision 1.16  1993/11/03  19:03:29  yazz
 * Define new flag bit to identify a signal as being directed at an entire
 * process group.
 * Declare phys layer routine pproc_signal_received for use by vproc layer.
 *
 * Revision 1.15  1993/10/29  11:54:50  paul
 * Add support for setting and using the RPM distributed time-of-day clock.
 *
 * Revision 1.14  1993/10/11  13:24:59  nandy
 * Added uid and ruid to VPOP_GET_ATTR()
 *
 * Revision 1.13  1993/07/14  18:31:23  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.9  1993/07/01  20:40:35  cfj
 * Adding new code from vendor
 *
 * Revision 1.12  1993/05/17  19:06:40  cfj
 * 05-06-93 MI driver drop from Locus.
 *
 * Revision 1.11  1993/05/10  16:57:52  stefan
 * Added the parentheses I forgot before.
 *
 * Revision 1.10  1993/05/10  15:24:20  stefan
 * Resolved overlap in REPORT_STATES.
 *
 * Revision 1.9  1993/05/06  19:21:26  nandy
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.8  1993/04/03  03:08:10  brad
 * Merge of PFS branch (tagged PFS_End) into CVS trunk (tagged
 * Main_Before_PFS_Merge).  The result is tagged PFS_Merge_Into_Main_April_2.
 * Revision 1.1.1.7  1993/05/03  17:44:09  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 1.1.2.3.2.3  1993/02/16  20:05:07  brad
 * Merged trunk (as of the T8_EATS_PASSED tag) into the PFS branch.
 *
 * Revision 1.7  1993/02/03  00:59:19  nandy
 * #ifdef VPROC_DEBUG removed from vproc struct to allow vp_next to be a part
 * of the vproc structure.
 *
 * Revision 1.6  1993/01/22  21:11:52  cfj
 * Turn off VPROC_DEBUG everywhere.
 *
 * Revision 1.1.2.3.2.2  1992/12/16  06:01:31  brad
 * Merged trunk (as of the Main_After_Locus_12_1_92_Bugdrop_OK tag)
 * into the PFS branch.
 *
 * Revision 1.1.2.3.2.1  1992/12/14  23:20:59  brad
 * Merged tip of old NX branch with PFS branch.
 *
 * Revision 1.5  1993/01/21  18:31:38  cfj
 * 01-20-93 Locus code drop.
 *
 * Revision 1.4  1992/12/11  03:00:23  cfj
 * Merged 12-1-92 bug drop from Locus.
 *
 * Revision 1.3  1992/11/30  22:45:52  dleslie
 * Copy of NX branch back into main trunk
 *
 * Revision 1.1.2.4  1992/11/24  21:38:08  cfj
 * Turn off VPROC_DEBUG.
 *
 * Revision 1.1.2.3  1992/11/13  18:52:20  cfj
 * Added reset_boot_node_list() system call.
 *
 * Revision 1.1.2.2  1992/11/06  20:30:06  dleslie
 * Merged bug drop from Locus November 3, 1992, with NX development
 *
 * Revision 1.1.2.1  1992/11/05  22:43:21  dleslie
 * Local changes for NX through noon, November 5, 1992.
 *
 * Revision 1.23  1992/11/02  21:49:49  cfj
 * Final integration and testing of IPD modifications
 *
 * Revision 1.29  93/06/22  17:57:04  yazz
 * [ Bug #0251 ] Remove declaration for new-defunct routine pproc_clear_-
 *	sleep_wait().  (roman)
 * 
 * Revision 1.28  93/06/16  15:10:54  klh
 * 	Revision 1.10  93/06/04  12:22:21  rabii
 * 		Added node argument to vpop_fork and friends (rabii)
 * 
 * Revision 1.27  93/05/07  13:13:18  bolsen
 * [Bug 252] made VPROC_DEBUG dependant on MACH_ASSERT.
 * 
 * Revision 1.26  93/04/22  16:34:11  roman
 * [Bug 222] Waiting for pgid has problems.
 * Fixed minor typos.
 * 
 * Revision 1.25  92/12/29  12:54:32  chrisp
 * To support a dynamically allocated, non-contiguous vproc table, extra
 * 	fields are added to each vproc structure for debugging purposes
 * 	(specifically for the table() call): vp_index is the vproc index
 * 	number and vp_next is a static link to the next vproc in the vproc
 * 	table.
 * 
 * Revision 1.24  92/12/02  11:09:25  chrisp
 * Change the vproc hash table to be dynamically allocated at system startup.
 * 
 * Revision 1.23  92/12/01  11:14:22  chrisp
 * Add virtual process system operation VPSOP_REBOOT() [plus declarations
 * 	for physical process system interface routines pps_bootsync()
 * 	and pps_boot().
 * 
 * Revision 1.22  92/10/28  15:04:01  roman
 * Add new virtual process system operations and physical process system
 * 	operations for table(), sethostid(), sethostname(), and
 * 	setdomainname() system calls.
 * 
 * Revision 1.21  92/10/01  10:27:08  roman
 * Fix up types for clean compilation under gcc.
 * 
 * Revision 1.20  92/09/30  10:41:19  chrisp
 * Add routines pproc_assert_sleep_wait() and pproc_clear_sleep_wait().
 *         pproc_assert_sleep_wait() is called in a process' wait()
 *         loop while scanning for stopped or zombied child processes
 *         to ensure that no signal (particularly SIGCHLD) is delivered
 *         until pproc_sleeping_waiting() or pproc_clear_sleep_wait()
 *         is called (marking the end of the scan).
 * 
 * Revision 1.19  92/09/29  07:24:06  roman
 * Change some field names to reflect real uses.
 * Externalize lock types (put types at top of file) and add vproc
 * 	locking macros (for code readability and portability).
 * Get rid of vproc op and pproc op for killall - replaced with a virtual 
 * 	process system operation and physical process system operation.
 * Change vproc op for set_state to report_state.
 * Add vproc op for terminal_sigpgrp and get rid of VPROC_TERMINAL_ACCESS
 * 	flag for the sigpgrp vproc op.
 * Add the concept of virtual process system operations (vpsops) and
 * 	physical process system operations (ppsops).
 * 
 * Revision 1.18  92/06/17  09:11:53  roman
 * [Bug 0026] New vproc op VPOP_GET_TASK_PORT() added to get task_by_pid() 
 *	system call working.
 * 
 * Revision 1.17  92/06/10  14:23:17  chrisp
 * Amend _VPOP_ macro to expand debugging information correctly with the i860
 * 	(ANSI) compiler.
 * 
 * Revision 1.16  92/03/18  12:00:05  roman
 * Get rid of macros for locking and unlocking vprocs. These are the
 * responsibility of the pvproc level of code.
 * 
 * Revision 1.15  92/03/12  15:04:01  roman
 * Add magic number field (and #define) at front of vproc.
 * Add mutex for reference counting.
 * 
 * Revision 1.14  92/03/03  16:05:16  chrisp
 * VPOP_CTTY_GETATTR() now takes an additional parameter, which may be null.
 * Vproc debugging call changed so that vproc pointer is always available to the
 * debugging routines for determination of pid.
 * 
 * Revision 1.13  92/01/30  14:13:15  chrisp
 * Add VPOP_PTRACE including pproc_ptrace interface declaration.
 * 
 * Revision 1.12  92/01/15  16:40:20  roman
 * Get rid of procedure prototypes for pproc_get_proc0() and pproc_get_proc1().
 * These routines have been deleted.
 * 
 * Revision 1.11  92/01/07  11:17:39  chrisp
 * Add panic in _VPOP_ if NULL vproc pointer specified.
 * 
 * Revision 1.10  91/12/20  16:33:06  chrisp
 * VPOP_RESIGN_PGRP removed; VPROC_IFTRACED flag added as a signalling option;
 * attribute has_execd added to VPOP_GETATTR.
 * 
 * Revision 1.9  91/11/22  10:13:55  chrisp
 * VPOP_SET_STOP_STATE generalized to VPOP_SET_STATE to include zombie
 * as well as stopped and unstopped.
 * 
 * Revision 1.8  91/11/19  13:11:19  chrisp
 * Add declarations of all pproc_* functions representing the interface from
 * the VPROC layer to the base physical code.
 * 
 * Revision 1.7  91/11/14  14:51:32  chrisp
 * Substantial revisions for controlling terminal operations.
 * Additional parameter added to the signaling VPOP operations.
 * 
 * Revision 1.6  91/11/04  12:05:43  roman
 * Change interface for debugging the reference counts to always use
 * vproc_db4(), with an extra "adjustment" count parameter.
 * 
 * Revision 1.5  91/11/01  17:11:22  roman
 * Fix VPROC_HOLD and VPROC_RELEASE macros to use a comma-separated
 * expresssion rather than a set of statements with no braces. Added
 * a new vproc op VPOP_FREE to give the pvproc layer a chance to do something
 * when a vproc is eliminated. Change the debugging for VPROC_HOLD
 * and VPROC_RELEASE to be done before the actual action rather than
 * after (doing debugging after the vproc is gone is potentially
 * dangerous).
 * 
 * Revision 1.4  91/10/30  12:46:04  roman
 * Change the routine name that is called by LOCATE_VPROC_PID() macro.
 * 
 * Revision 1.3  91/10/25  10:44:16  roman
 * Reorg the file to get rid of the pid/node manipulation. Now done in
 * dpvproc.h. Change LOCATE_VPROC_PID() to use indirect procedure
 * pointer.
 * 
 * Revision 1.2  91/10/18  18:39:01  chrisp
 * 	Proper PVPOPs. New debugging message formatting.
 * 
 *
 */
#ifndef _H_VPROC
#define _H_VPROC

#include <sys/types.h>
#include <sys/resource.h>
#include <sys/tty.h>
#include <sys/vnode.h>
#include <sys/procset.h>

#if	MACH_ASSERT
#define VPROC_DEBUG 1
#endif	/* MACH_ASSERT */

/*
 * Real names for locks and lock routines used by vproc structure.
 */
typedef struct mutex vp_lock_t;

#define VP_SLOCK_T_INITIALIZER MUTEX_INITIALIZER
#define vp_lock_init	mutex_init
#define vp_lock_lock	mutex_lock
#define vp_lock_unlock	mutex_unlock

/*
 * Vproc structure.
 */
struct	vproc {
	long		  vp_magic;	/* magic number id for vproc */
#define			  VP_MAGIC	0x63727076
	pid_t		  vp_pid;	/* vproc process identifier */
	unsigned long	  vp_ref_cnt;	/* vproc usage count */
	struct vproc_ops  *vp_ops;	/* vproc operations */
	caddr_t  	  vp_data;	/* implementation dependent data */
	vp_lock_t	  vp_ref_cnt_lock; /* lock for reference counting */
	struct pid_hash {
		struct vproc	*hashfwd;
		struct vproc	*hashbwd;
	} vp_pid_hash; 
/* #ifdef VPROC_DEBUG removed to add  vp_next to the structure */
	unsigned long	  vp_index;	/* vproc index number */
	struct vproc	  *vp_next;	/* static link to next vproc */
	mach_port_t	  vp_port_name;	/* name of associated Mach port */
};
#define	vp_hashfwd	vp_pid_hash.hashfwd
#define	vp_hashbwd	vp_pid_hash.hashbwd

/*
 * The vproc table pointers.
 */
extern struct vproc *vproc;		/* the vproc process table, itself */
extern struct vproc *vprocNVPROC;	/* pointer past end of table */
extern struct vproc *vprocfree;		/* pointer to free vproc list */
extern int nvproc;			/* number of vprocs */

/*
 * Hash table for vproc table 
 */
#define VPROC_NHASH 256			/* Minimum number entries in table */
extern int vprochsz;			/* Actual size of the hash table */
extern struct vproc **vproc_hash;	/* hash table itself */
#define VPROCPIDHASH(pid) ((pid)&(vprochsz-1)) /* hash a pid to hash table */
vp_lock_t	    vproc_list_lock;	/* Lock for free list and hash table */

extern struct vproc *vprocptr(pid_t pid);
extern struct vproc *(*locate_vproc_pid_routine)(pid_t pid);

/*
 * locate/create a vproc given the pid of a process.
 * validate whether a process id is valid or not.
 */
#define VPROCPTR(pid)	(vprocptr(pid))
#define	LOCATE_VPROC_PID(pid) \
			(*locate_vproc_pid_routine)(pid)

/*
 * Macros which define the existence rules for a vproc.
 */
#ifdef VPROC_DEBUG
#define	DECREMENT_VP_REFCNT(z, str) 		\
	(vproc_db4(z, "RELEASE", str, -1), 	\
	vproc_release(z))
#define	INCREMENT_VP_REFCNT(z, str)		\
	(vproc_db4(z, "HOLD", str, +1), 	\
	vproc_hold(z))
#else
#define	DECREMENT_VP_REFCNT(z, str)	vproc_release(z)
#define	INCREMENT_VP_REFCNT(z, str)	vproc_hold(z)
#endif /* VPROC_DEBUG */

#define	VPROC_HOLD(v, str)	INCREMENT_VP_REFCNT((v), (str))
#define	VPROC_RELEASE(v, str)	DECREMENT_VP_REFCNT((v), (str))

/*
 * Lock macros used by the virtual process code.
 */
#define VPROC_LIST_LOCK() do {				\
		vp_lock_lock(&vproc_list_lock);		\
		} while(0)
#define VPROC_LIST_UNLOCK() do {			\
		vp_lock_unlock(&vproc_list_lock);	\
		} while(0)

#define VPROC_REFCNT_LOCK_INIT(v) do {			\
		vp_lock_init(&(v)->vp_ref_cnt_lock);	\
		} while(0)
#define VPROC_REFCNT_LOCK(v) do {			\
		vp_lock_lock(&(v)->vp_ref_cnt_lock);	\
		} while(0)
#define VPROC_REFCNT_UNLOCK(v) do {			\
		vp_lock_unlock(&(v)->vp_ref_cnt_lock);	\
		} while(0)

/*
 * The vproc operations table and macros are generated automatically
 * and included here.
 */
#include <vproc/vproc_struct_gen.h>
#include <vproc/vproc_macros_gen.h>

/*
 * The following are the flag values for vproc ops. The following
 * rules apply to these values:
 *  VPOP_SIG*		can use VPROC_HAS_PRIV, VPROC_CANT_BLOCK,
 *			VPROC_CHECK_CTTY, VPROC_NOSIGSELF, VPROC_PGRP_SIG
 *  VPOP_*_NICE		can use VPROC_SET, VPROC_GET, VPROC_HAS_PRIV (ignored
 *			if VPROC_GET is also used)
 */
#define	VPROC_SET		0x0040	/* set specified flag */
#define	VPROC_GET		0x0080	/* retrieve flag */
#define	VPROC_CLEAR		0x0100	/* clear specified flag */
#define	VPROC_HAS_PRIV		0x0200	/* don't check priviledges to send */
#define	VPROC_CANT_BLOCK	0x0400	/* process cannot block */
#define	VPROC_CHECK_CTTY	0x0800	/* check for controlling tty */
#define	VPROC_CHILD_STOP	0x1000	/* don't deliver if parent ignoring */
#define	VPROC_IFTRACED		0x2000	/* untrace and deliver if traced */
#define	VPROC_IFSTOPPED		0x4000	/* deliver if and only if stopped */
#define	VPROC_NOSIGSELF		0x0001	/* don't signal myself (pgrp only) */
#define	VPROC_PGRP_SIG		0x0002	/* send sig to entire process group */

/*
 * These values are returned by the job_control parameter in VPOP_GET_ATTR
 */
#define	VPROC_NOT_PGRPLEADER	-1	/* vproc is not a pgrp leader */
#define	VPROC_ORPHANED		0	/* vproc is orphaned pgrp leader */
#define	VPROC_JOB_CONTROL	1	/* vproc is pgrp with job control */

/*
 * These are set state values accepted by REPORT_STATE.
 */
#define	VPROC_ZOMBIE		1	/* vproc est mort */
#define	VPROC_STOP		2	/* vproc has stopped */
#define	VPROC_UNSTOP		0	/* vproc has resumed */
#define VPROC_LEFT_PGRP		3	/* vproc has resigned from pgrp */
#ifdef NX
#define VPROC_NX_START		10	/* start of NX specific states */
#define VPROC_NO_SIGCHLD	(VPROC_NX_START + 0)	/* Don't send SIGCHLD sigs to parent */
#define VPROC_AGAIN_SIGCHLD   (VPROC_NX_START + 1)    /* Send SIGCHLD sigs to parent again */
#define VPROC_GANG_STOP       (VPROC_NX_START + 2)    /* Process was gang stopped.         */
#define VPROC_GANG_UNSTOP     (VPROC_NX_START + 3)    /* Process is no longer gang stopped */
#endif /* NX */

/*
 * These are option values recognized by WAIT and REAP.
 */
#define VPROC_WNOHANG		0x01	/* wait will not sleep */
#define VPROC_WUNTRACED		0x02	/* wait for stopped by signals procs */
#define VPROC_WNOWAIT		0x04	/* no actual reap - just get stat */
#define VPROC_WCONTINUED	0x08	/* wait for continued procs */
#define VPROC_WTRAPPED		0x10	/* wait for stopped by tracing procs */

/*
 * These values are request codes to VPOP_PTRACE.
 * Currently, they map directly to the underlying ptrace codes.
 */
#define VPROC_PT_TRACE_ME	0	/* child declares it's being traced */
#define VPROC_PT_READ_I		1	/* read word in child's I space */
#define VPROC_PT_READ_D		2	/* read word in child's D space */
#define VPROC_PT_READ_U		3	/* read word in child's user struct */
#define VPROC_PT_WRITE_I	4	/* write word in child's I space */
#define VPROC_PT_WRITE_D	5	/* write word in child's D space */
#define VPROC_PT_WRITE_U	6	/* write word in child's user struct */
#define VPROC_PT_CONTINUE	7	/* continue the child */
#define VPROC_PT_KILL		8	/* kill the child process */
#define VPROC_PT_STEP		9	/* single step the child */

/*
 * To debug vproc ops or not, that is the question...
 */
#ifdef	VPROC_DEBUG
#ifdef	__STDC__
#define _VPOP_(op, v, args, argfmt) \
	(vproc_db1(v,#op,argfmt), vproc_db2 args, \
	 vproc_db3(v, (*v->vp_ops->op) args))
#else	/* __STDC__ */
#define _VPOP_(op, v, args, argfmt) \
	(vproc_db1(v,"op",argfmt), vproc_db2 args, \
	 vproc_db3(v, (*v->vp_ops->op) args))
#endif	/* __STDC__ */
#else	/* VPROC_DEBUG */
#define _VPOP_(op, v, args, argfmt)	(v ? (*v->vp_ops->op) args : \
					     panic("_VPOP_: NULL vproc"))
#endif	/* VPROC_DEBUG */

/*
 * The following declarations represent the interface from the VPROC
 * layer to the base physical code.
 */

typedef struct proc proc_t;		/* this keeps ANSI happy */

extern int pproc_exit(			/* process exit */
		proc_t *p,		/* process structure */
		int rv);		/* exit code */
extern int pproc_reap(			/* reap zombie process */
		proc_t *p,		/* process structure */
		int options,		/* options (from wait system call */
		int *wstat,		/* returned wait status */
		struct rusage_dev *rusage); /* returned usage stats */
extern void pproc_wakeup(		/* awaken sleeping process */
		proc_t *p);		/* process structure */
extern int pproc_assert_sleep_wait(	/* assert a process about to sleep */
		proc_t *p);		/* process structure */
extern int pproc_sleep_waiting(		/* put process to sleep */
		proc_t *p);		/* process structure */
extern int pproc_add_rusage(		/* accumulate child usage stats */
		proc_t *p,		/* process structure */
		struct rusage_dev *ru_loc); /* stats */
extern int pproc_fork(			/* fork a process */
		proc_t *pp,		/* parent process structure */
		pid_t pid,		/* pid to use for child */
		proc_t **pchild,	/* returns child process structure */
		node_t node,		/* node to create task on */
		thread_state_t	new_state, /* thread state */
		unsigned int	new_state_count); /* thread state count */
extern int pproc_get_nice(		/* get nice value for process */
		proc_t *p,		/* process structure */
		int *n);		/* returns nice velue */
extern int pproc_set_nice(		/* set nice value for process */
		proc_t *chgp,		/* process structure to be set */
		uid_t cur_uid,		/* effective uid of calling process */
		uid_t cur_ruid,		/* real uid of calling process */
		int has_priv,		/* TRUE if superuser calling */
		int n);			/* nice value to set */
extern int pproc_chksigmask(		/* check signal masks of process */
		proc_t *p,		/* process structure */
		int sig,		/* signal number to check */
		int *ismasked,		/* returns whether signal is masked */
		int *isignored);	/* returns whether signal is ignored */
extern int pproc_psignal(		/* post signal to process */
		proc_t *p,		/* sendee's process structure */
		int sig,		/* signal to send */
		int arg,		/* argument (for SIGMIGRATE) */
		int can_block,		/* indicates if caller can block */
		int child_stop,		/* indicates sender is stopped child */
		int iftraced,		/* force delivery to traced process */
		int has_priv,		/* indicated if caller is superuser */
		uid_t uid,		/* effective uid of sender */
		uid_t ruid,		/* real uid of sender */
		pid_t sid);		/* session id of sender */
extern int pproc_get_attr(		/* get process attributes */
		proc_t *p,		/* process structure */
		pid_t *pid,		/* returns pid */
		pid_t *ppid,		/* returns pid of parent */
		pid_t *pgid,		/* returns process group id  */
		pid_t *sid,		/* returns session id */
		int *has_priv,		/* returns superuser indication */
		uid_t *uid,		/* returns effective uid */
		uid_t *ruid,		/* returns real uid */
		int *has_sctty,		/* returns if has controlling tty */
		int *has_execd);	/* returns if process has called exec */
extern int pproc_set_attr(		/* set process attributes */
		proc_t *p,		/* process structure */
		struct vproc *v,	/* corresponding vproc structure */
		pid_t *pid,		/* (ptr to) pid */
		pid_t *ppid,		/* (ptr to) pid of parent */
		pid_t *pgid,		/* (ptr to) process group id  */
		pid_t *sid,		/* (ptr to) session id */
		int *has_sctty);	/* (ptr to) if has controlling tty */
extern int pproc_release_cttyv(		/* release vnode for controlling tty */
		struct tty *tp);	/* tty struct of controlling terminal */
extern int pproc_ptrace(		/* perform trace request on process */
		proc_t *p,		/* process structure */
		int req,		/* request code */
		int *addr,		/* memory address */
		int data,		/* data to write */
		int *retval);		/* returned data */
extern int pproc_get_task_port(		/* get task_port for process */
		proc_t *p,		/* process structure */
		uid_t cur_uid,		/* effective uid of calling process */
		int has_priv,		/* indicated if caller is superuser */
		mach_port_t *portp);	/* returns port of corresponding task */
extern int pproc_signal_received(	/* learn if this proc has any sigs */
		proc_t *p);		/* process structure */

/*
 * The virtual process operations table and macros are generated automatically
 * and included here.
 */
#include <vproc/vps_struct_gen.h>
#include <vproc/vps_macros_gen.h>
struct vps_ops *vps_ops;

/*
 * To debug vproc system ops or not, that is the question...
 */
#ifdef	VPROC_DEBUG
#ifdef	__STDC__
#define _VPSOP_(op, dummy, args, argfmt) \
	(vps_db1(#op,argfmt), vps_db2 args, \
	 vps_db3((*vps_ops->op) args))
#else	/* __STDC__ */
#define _VPSOP_(op, dummy, args, argfmt) \
	(vps_db1("op",argfmt), vps_db2 args, \
	 vps_db3((*vps_ops->op) args))
#endif	/* __STDC__ */
#else	/* VPROC_DEBUG */
#define _VPSOP_(op, dummy, args, argfmt) \
	(*vps_ops->op) args
#endif	/* VPROC_DEBUG */

/*
 * The following declarations represent the interface from the VPROC
 * system layer to the base physical code.
 */

extern int pps_sigprocset(
		struct procset *ps,	/* set of processes to be signalled */
		int signo,		/* signal to be sent */
		int arg,		/* argument (for SIGMIGRATE) */
		int has_priv,		/* indicated if caller is superuser */
		uid_t uid,		/* effective uid of sender */
		uid_t ruid,		/* real uid of sender */
		pid_t pid,		/* process id of sender */
		pid_t sid,		/* session id of sender */
		int *nproc);		/* number of processes signaled */
extern int pps_procset_get_nice(
		struct procset *ps,	/* set of processes changed/queried */
		int *n);		/* nice value returned */
extern int pps_procset_set_nice(
		struct procset *ps,	/* set of processes changed/queried */
		uid_t cur_uid,		/* effective uid of calling process */
		uid_t cur_ruid,		/* real uid of calling process */
		int has_priv,		/* TRUE if superuser calling */
		int n);			/* nice value to set */
extern int pps_pid_from_task(
		task_t task,		/* task port to which pid refers to */
		pid_t *pid,		/* pid of process using task */
		char *comm,		/* command name for pid */
		unsigned int *commlen);	/* length of command name */
extern int pps_table(
		void *uap,		/* arguments to system call */
		int *retval);		/* return value */
extern int pps_sethostid(
		long new_hostid);	/* hostid to be set */
extern int pps_sethostname(
		char *new_hostname,	/* hostname to be set */
		unsigned int new_hostnamelen); /* hostname length */
extern int pps_setdomainname(
		char *new_domainname,	/* domainname to be set */
		unsigned int new_domainnamelen); /* domainname length */
extern int pps_bootsync(
		int flags,		/* indicates whether panicking */
		int options);		/* options applying to reboot */
extern int pps_boot(
		int flags,		/* indicates whether panicking */
		int options);		/* options applying to reboot */

#endif  /* _H_VPROC */
